/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaStreamTrack.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSDoubleRange.h"
#include "JSEventListener.h"
#include "JSLongRange.h"
#include "JSMediaStreamTrack.h"
#include "JSMediaTrackConstraints.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(MediaStreamTrack::State enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("live"),
        MAKE_STATIC_STRING_IMPL("ended"),
    };
    static_assert(static_cast<size_t>(MediaStreamTrack::State::Live) == 0, "MediaStreamTrack::State::Live is not 0 as expected");
    static_assert(static_cast<size_t>(MediaStreamTrack::State::Ended) == 1, "MediaStreamTrack::State::Ended is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, MediaStreamTrack::State enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<MediaStreamTrack::State> parseEnumeration<MediaStreamTrack::State>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "live")
        return MediaStreamTrack::State::Live;
    if (stringValue == "ended")
        return MediaStreamTrack::State::Ended;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<MediaStreamTrack::State>()
{
    return "\"live\", \"ended\"";
}

#if ENABLE(MEDIA_STREAM)

template<> MediaStreamTrack::TrackCapabilities convertDictionary<MediaStreamTrack::TrackCapabilities>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MediaStreamTrack::TrackCapabilities result;
    JSValue aspectRatioValue;
    if (isNullOrUndefined)
        aspectRatioValue = jsUndefined();
    else {
        aspectRatioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "aspectRatio"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!aspectRatioValue.isUndefined()) {
        result.aspectRatio = convert<IDLDictionary<DoubleRange>>(lexicalGlobalObject, aspectRatioValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue deviceIdValue;
    if (isNullOrUndefined)
        deviceIdValue = jsUndefined();
    else {
        deviceIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deviceId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deviceIdValue.isUndefined()) {
        result.deviceId = convert<IDLDOMString>(lexicalGlobalObject, deviceIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue echoCancellationValue;
    if (isNullOrUndefined)
        echoCancellationValue = jsUndefined();
    else {
        echoCancellationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "echoCancellation"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!echoCancellationValue.isUndefined()) {
        result.echoCancellation = convert<IDLSequence<IDLBoolean>>(lexicalGlobalObject, echoCancellationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue facingModeValue;
    if (isNullOrUndefined)
        facingModeValue = jsUndefined();
    else {
        facingModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "facingMode"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!facingModeValue.isUndefined()) {
        result.facingMode = convert<IDLSequence<IDLDOMString>>(lexicalGlobalObject, facingModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue frameRateValue;
    if (isNullOrUndefined)
        frameRateValue = jsUndefined();
    else {
        frameRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameRate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frameRateValue.isUndefined()) {
        result.frameRate = convert<IDLDictionary<DoubleRange>>(lexicalGlobalObject, frameRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue groupIdValue;
    if (isNullOrUndefined)
        groupIdValue = jsUndefined();
    else {
        groupIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "groupId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!groupIdValue.isUndefined()) {
        result.groupId = convert<IDLDOMString>(lexicalGlobalObject, groupIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!heightValue.isUndefined()) {
        result.height = convert<IDLDictionary<LongRange>>(lexicalGlobalObject, heightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sampleRateValue;
    if (isNullOrUndefined)
        sampleRateValue = jsUndefined();
    else {
        sampleRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleRate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleRateValue.isUndefined()) {
        result.sampleRate = convert<IDLDictionary<LongRange>>(lexicalGlobalObject, sampleRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sampleSizeValue;
    if (isNullOrUndefined)
        sampleSizeValue = jsUndefined();
    else {
        sampleSizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleSize"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleSizeValue.isUndefined()) {
        result.sampleSize = convert<IDLDictionary<LongRange>>(lexicalGlobalObject, sampleSizeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue volumeValue;
    if (isNullOrUndefined)
        volumeValue = jsUndefined();
    else {
        volumeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "volume"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!volumeValue.isUndefined()) {
        result.volume = convert<IDLDictionary<DoubleRange>>(lexicalGlobalObject, volumeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!widthValue.isUndefined()) {
        result.width = convert<IDLDictionary<LongRange>>(lexicalGlobalObject, widthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaStreamTrack::TrackCapabilities& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDictionary<DoubleRange>::isNullValue(dictionary.aspectRatio)) {
        auto aspectRatioValue = toJS<IDLDictionary<DoubleRange>>(lexicalGlobalObject, globalObject, IDLDictionary<DoubleRange>::extractValueFromNullable(dictionary.aspectRatio));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "aspectRatio"), aspectRatioValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.deviceId)) {
        auto deviceIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.deviceId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "deviceId"), deviceIdValue);
    }
    if (!IDLSequence<IDLBoolean>::isNullValue(dictionary.echoCancellation)) {
        auto echoCancellationValue = toJS<IDLSequence<IDLBoolean>>(lexicalGlobalObject, globalObject, IDLSequence<IDLBoolean>::extractValueFromNullable(dictionary.echoCancellation));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "echoCancellation"), echoCancellationValue);
    }
    if (!IDLSequence<IDLDOMString>::isNullValue(dictionary.facingMode)) {
        auto facingModeValue = toJS<IDLSequence<IDLDOMString>>(lexicalGlobalObject, globalObject, IDLSequence<IDLDOMString>::extractValueFromNullable(dictionary.facingMode));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "facingMode"), facingModeValue);
    }
    if (!IDLDictionary<DoubleRange>::isNullValue(dictionary.frameRate)) {
        auto frameRateValue = toJS<IDLDictionary<DoubleRange>>(lexicalGlobalObject, globalObject, IDLDictionary<DoubleRange>::extractValueFromNullable(dictionary.frameRate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "frameRate"), frameRateValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.groupId)) {
        auto groupIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.groupId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "groupId"), groupIdValue);
    }
    if (!IDLDictionary<LongRange>::isNullValue(dictionary.height)) {
        auto heightValue = toJS<IDLDictionary<LongRange>>(lexicalGlobalObject, globalObject, IDLDictionary<LongRange>::extractValueFromNullable(dictionary.height));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "height"), heightValue);
    }
    if (!IDLDictionary<LongRange>::isNullValue(dictionary.sampleRate)) {
        auto sampleRateValue = toJS<IDLDictionary<LongRange>>(lexicalGlobalObject, globalObject, IDLDictionary<LongRange>::extractValueFromNullable(dictionary.sampleRate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleRate"), sampleRateValue);
    }
    if (!IDLDictionary<LongRange>::isNullValue(dictionary.sampleSize)) {
        auto sampleSizeValue = toJS<IDLDictionary<LongRange>>(lexicalGlobalObject, globalObject, IDLDictionary<LongRange>::extractValueFromNullable(dictionary.sampleSize));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleSize"), sampleSizeValue);
    }
    if (!IDLDictionary<DoubleRange>::isNullValue(dictionary.volume)) {
        auto volumeValue = toJS<IDLDictionary<DoubleRange>>(lexicalGlobalObject, globalObject, IDLDictionary<DoubleRange>::extractValueFromNullable(dictionary.volume));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "volume"), volumeValue);
    }
    if (!IDLDictionary<LongRange>::isNullValue(dictionary.width)) {
        auto widthValue = toJS<IDLDictionary<LongRange>>(lexicalGlobalObject, globalObject, IDLDictionary<LongRange>::extractValueFromNullable(dictionary.width));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "width"), widthValue);
    }
    return result;
}

#endif

#if ENABLE(MEDIA_STREAM)

template<> MediaStreamTrack::TrackSettings convertDictionary<MediaStreamTrack::TrackSettings>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MediaStreamTrack::TrackSettings result;
    JSValue aspectRatioValue;
    if (isNullOrUndefined)
        aspectRatioValue = jsUndefined();
    else {
        aspectRatioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "aspectRatio"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!aspectRatioValue.isUndefined()) {
        result.aspectRatio = convert<IDLDouble>(lexicalGlobalObject, aspectRatioValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue deviceIdValue;
    if (isNullOrUndefined)
        deviceIdValue = jsUndefined();
    else {
        deviceIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deviceId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deviceIdValue.isUndefined()) {
        result.deviceId = convert<IDLDOMString>(lexicalGlobalObject, deviceIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue echoCancellationValue;
    if (isNullOrUndefined)
        echoCancellationValue = jsUndefined();
    else {
        echoCancellationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "echoCancellation"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!echoCancellationValue.isUndefined()) {
        result.echoCancellation = convert<IDLBoolean>(lexicalGlobalObject, echoCancellationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue facingModeValue;
    if (isNullOrUndefined)
        facingModeValue = jsUndefined();
    else {
        facingModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "facingMode"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!facingModeValue.isUndefined()) {
        result.facingMode = convert<IDLDOMString>(lexicalGlobalObject, facingModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue frameRateValue;
    if (isNullOrUndefined)
        frameRateValue = jsUndefined();
    else {
        frameRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameRate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frameRateValue.isUndefined()) {
        result.frameRate = convert<IDLDouble>(lexicalGlobalObject, frameRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue groupIdValue;
    if (isNullOrUndefined)
        groupIdValue = jsUndefined();
    else {
        groupIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "groupId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!groupIdValue.isUndefined()) {
        result.groupId = convert<IDLDOMString>(lexicalGlobalObject, groupIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!heightValue.isUndefined()) {
        result.height = convert<IDLLong>(lexicalGlobalObject, heightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sampleRateValue;
    if (isNullOrUndefined)
        sampleRateValue = jsUndefined();
    else {
        sampleRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleRate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleRateValue.isUndefined()) {
        result.sampleRate = convert<IDLLong>(lexicalGlobalObject, sampleRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sampleSizeValue;
    if (isNullOrUndefined)
        sampleSizeValue = jsUndefined();
    else {
        sampleSizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleSize"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleSizeValue.isUndefined()) {
        result.sampleSize = convert<IDLLong>(lexicalGlobalObject, sampleSizeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue volumeValue;
    if (isNullOrUndefined)
        volumeValue = jsUndefined();
    else {
        volumeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "volume"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!volumeValue.isUndefined()) {
        result.volume = convert<IDLDouble>(lexicalGlobalObject, volumeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!widthValue.isUndefined()) {
        result.width = convert<IDLLong>(lexicalGlobalObject, widthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaStreamTrack::TrackSettings& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDouble::isNullValue(dictionary.aspectRatio)) {
        auto aspectRatioValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.aspectRatio));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "aspectRatio"), aspectRatioValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.deviceId)) {
        auto deviceIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.deviceId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "deviceId"), deviceIdValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.echoCancellation)) {
        auto echoCancellationValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.echoCancellation));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "echoCancellation"), echoCancellationValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.facingMode)) {
        auto facingModeValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.facingMode));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "facingMode"), facingModeValue);
    }
    if (!IDLDouble::isNullValue(dictionary.frameRate)) {
        auto frameRateValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.frameRate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "frameRate"), frameRateValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.groupId)) {
        auto groupIdValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.groupId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "groupId"), groupIdValue);
    }
    if (!IDLLong::isNullValue(dictionary.height)) {
        auto heightValue = toJS<IDLLong>(IDLLong::extractValueFromNullable(dictionary.height));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "height"), heightValue);
    }
    if (!IDLLong::isNullValue(dictionary.sampleRate)) {
        auto sampleRateValue = toJS<IDLLong>(IDLLong::extractValueFromNullable(dictionary.sampleRate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleRate"), sampleRateValue);
    }
    if (!IDLLong::isNullValue(dictionary.sampleSize)) {
        auto sampleSizeValue = toJS<IDLLong>(IDLLong::extractValueFromNullable(dictionary.sampleSize));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleSize"), sampleSizeValue);
    }
    if (!IDLDouble::isNullValue(dictionary.volume)) {
        auto volumeValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.volume));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "volume"), volumeValue);
    }
    if (!IDLLong::isNullValue(dictionary.width)) {
        auto widthValue = toJS<IDLLong>(IDLLong::extractValueFromNullable(dictionary.width));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "width"), widthValue);
    }
    return result;
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMediaStreamTrackPrototypeFunctionClone(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaStreamTrackPrototypeFunctionStop(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaStreamTrackPrototypeFunctionGetCapabilities(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaStreamTrackPrototypeFunctionGetConstraints(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaStreamTrackPrototypeFunctionGetSettings(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaStreamTrackPrototypeFunctionApplyConstraints(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsMediaStreamTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaStreamTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaStreamTrackKind(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaStreamTrackId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaStreamTrackLabel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaStreamTrackEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaStreamTrackEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaStreamTrackContentHint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaStreamTrackContentHint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaStreamTrackMuted(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaStreamTrackOnmute(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaStreamTrackOnmute(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaStreamTrackOnunmute(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaStreamTrackOnunmute(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaStreamTrackReadyState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaStreamTrackOnended(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaStreamTrackOnended(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaStreamTrackOnoverconstrained(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaStreamTrackOnoverconstrained(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMediaStreamTrackPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaStreamTrackPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaStreamTrackPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaStreamTrackPrototype>(vm.heap)) JSMediaStreamTrackPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaStreamTrackPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaStreamTrackPrototype, JSMediaStreamTrackPrototype::Base);

using JSMediaStreamTrackConstructor = JSDOMConstructorNotConstructable<JSMediaStreamTrack>;

template<> JSValue JSMediaStreamTrackConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSMediaStreamTrackConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaStreamTrack::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("MediaStreamTrack"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSMediaStreamTrackConstructor::s_info = { "MediaStreamTrack", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamTrackConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaStreamTrackPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaStreamTrackConstructor) } },
    { "kind", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackKind), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "id", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "label", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackLabel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "enabled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackEnabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaStreamTrackEnabled) } },
    { "contentHint", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackContentHint), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaStreamTrackContentHint) } },
    { "muted", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackMuted), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onmute", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackOnmute), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaStreamTrackOnmute) } },
    { "onunmute", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackOnunmute), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaStreamTrackOnunmute) } },
    { "readyState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackReadyState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onended", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackOnended), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaStreamTrackOnended) } },
    { "onoverconstrained", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackOnoverconstrained), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaStreamTrackOnoverconstrained) } },
    { "clone", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaStreamTrackPrototypeFunctionClone), (intptr_t) (0) } },
    { "stop", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaStreamTrackPrototypeFunctionStop), (intptr_t) (0) } },
    { "getCapabilities", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaStreamTrackPrototypeFunctionGetCapabilities), (intptr_t) (0) } },
    { "getConstraints", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaStreamTrackPrototypeFunctionGetConstraints), (intptr_t) (0) } },
    { "getSettings", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaStreamTrackPrototypeFunctionGetSettings), (intptr_t) (0) } },
    { "applyConstraints", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaStreamTrackPrototypeFunctionApplyConstraints), (intptr_t) (0) } },
};

const ClassInfo JSMediaStreamTrackPrototype::s_info = { "MediaStreamTrackPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamTrackPrototype) };

void JSMediaStreamTrackPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaStreamTrack::info(), JSMediaStreamTrackPrototypeTableValues, *this);
}

const ClassInfo JSMediaStreamTrack::s_info = { "MediaStreamTrack", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamTrack) };

JSMediaStreamTrack::JSMediaStreamTrack(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaStreamTrack>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSMediaStreamTrack::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, MediaStreamTrack>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSMediaStreamTrack::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMediaStreamTrackPrototype::create(vm, &globalObject, JSMediaStreamTrackPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSMediaStreamTrack::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaStreamTrack>(vm, globalObject);
}

JSValue JSMediaStreamTrack::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaStreamTrackConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSMediaStreamTrack* IDLAttribute<JSMediaStreamTrack>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMediaStreamTrack*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSMediaStreamTrack* IDLOperation<JSMediaStreamTrack>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSMediaStreamTrack*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsMediaStreamTrackConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaStreamTrackPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaStreamTrack::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSMediaStreamTrackConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaStreamTrackPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsMediaStreamTrackKindGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.kind());
    return result;
}

EncodedJSValue jsMediaStreamTrackKind(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrackKindGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "kind");
}

static inline JSValue jsMediaStreamTrackIdGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id());
    return result;
}

EncodedJSValue jsMediaStreamTrackId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrackIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "id");
}

static inline JSValue jsMediaStreamTrackLabelGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.label());
    return result;
}

EncodedJSValue jsMediaStreamTrackLabel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrackLabelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "label");
}

static inline JSValue jsMediaStreamTrackEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.enabled());
    return result;
}

EncodedJSValue jsMediaStreamTrackEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrackEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "enabled");
}

static inline bool setJSMediaStreamTrackEnabledSetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setEnabled(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMediaStreamTrackEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaStreamTrack>::set<setJSMediaStreamTrackEnabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "enabled");
}

static inline JSValue jsMediaStreamTrackContentHintGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.contentHint());
    return result;
}

EncodedJSValue jsMediaStreamTrackContentHint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrackContentHintGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "contentHint");
}

static inline bool setJSMediaStreamTrackContentHintSetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setContentHint(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMediaStreamTrackContentHint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaStreamTrack>::set<setJSMediaStreamTrackContentHintSetter>(*lexicalGlobalObject, thisValue, encodedValue, "contentHint");
}

static inline JSValue jsMediaStreamTrackMutedGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.muted());
    return result;
}

EncodedJSValue jsMediaStreamTrackMuted(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrackMutedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "muted");
}

static inline JSValue jsMediaStreamTrackOnmuteGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().muteEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsMediaStreamTrackOnmute(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrackOnmuteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmute");
}

static inline bool setJSMediaStreamTrackOnmuteSetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().muteEvent, value);
    return true;
}

bool setJSMediaStreamTrackOnmute(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaStreamTrack>::set<setJSMediaStreamTrackOnmuteSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmute");
}

static inline JSValue jsMediaStreamTrackOnunmuteGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().unmuteEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsMediaStreamTrackOnunmute(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrackOnunmuteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onunmute");
}

static inline bool setJSMediaStreamTrackOnunmuteSetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().unmuteEvent, value);
    return true;
}

bool setJSMediaStreamTrackOnunmute(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaStreamTrack>::set<setJSMediaStreamTrackOnunmuteSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onunmute");
}

static inline JSValue jsMediaStreamTrackReadyStateGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<MediaStreamTrack::State>>(lexicalGlobalObject, throwScope, impl.readyState());
    return result;
}

EncodedJSValue jsMediaStreamTrackReadyState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrackReadyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "readyState");
}

static inline JSValue jsMediaStreamTrackOnendedGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().endedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsMediaStreamTrackOnended(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrackOnendedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onended");
}

static inline bool setJSMediaStreamTrackOnendedSetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().endedEvent, value);
    return true;
}

bool setJSMediaStreamTrackOnended(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaStreamTrack>::set<setJSMediaStreamTrackOnendedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onended");
}

static inline JSValue jsMediaStreamTrackOnoverconstrainedGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().overconstrainedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsMediaStreamTrackOnoverconstrained(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrackOnoverconstrainedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onoverconstrained");
}

static inline bool setJSMediaStreamTrackOnoverconstrainedSetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().overconstrainedEvent, value);
    return true;
}

bool setJSMediaStreamTrackOnoverconstrained(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaStreamTrack>::set<setJSMediaStreamTrackOnoverconstrainedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onoverconstrained");
}

static inline JSC::EncodedJSValue jsMediaStreamTrackPrototypeFunctionCloneBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStreamTrack>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.clone()));
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamTrackPrototypeFunctionClone(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaStreamTrack>::call<jsMediaStreamTrackPrototypeFunctionCloneBody>(*lexicalGlobalObject, *callFrame, "clone");
}

static inline JSC::EncodedJSValue jsMediaStreamTrackPrototypeFunctionStopBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStreamTrack>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.stopTrack();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamTrackPrototypeFunctionStop(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaStreamTrack>::call<jsMediaStreamTrackPrototypeFunctionStopBody>(*lexicalGlobalObject, *callFrame, "stop");
}

static inline JSC::EncodedJSValue jsMediaStreamTrackPrototypeFunctionGetCapabilitiesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStreamTrack>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDictionary<MediaStreamTrack::TrackCapabilities>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getCapabilities()));
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamTrackPrototypeFunctionGetCapabilities(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaStreamTrack>::call<jsMediaStreamTrackPrototypeFunctionGetCapabilitiesBody>(*lexicalGlobalObject, *callFrame, "getCapabilities");
}

static inline JSC::EncodedJSValue jsMediaStreamTrackPrototypeFunctionGetConstraintsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStreamTrack>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDictionary<MediaTrackConstraints>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getConstraints()));
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamTrackPrototypeFunctionGetConstraints(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaStreamTrack>::call<jsMediaStreamTrackPrototypeFunctionGetConstraintsBody>(*lexicalGlobalObject, *callFrame, "getConstraints");
}

static inline JSC::EncodedJSValue jsMediaStreamTrackPrototypeFunctionGetSettingsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStreamTrack>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDictionary<MediaStreamTrack::TrackSettings>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getSettings()));
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamTrackPrototypeFunctionGetSettings(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaStreamTrack>::call<jsMediaStreamTrackPrototypeFunctionGetSettingsBody>(*lexicalGlobalObject, *callFrame, "getSettings");
}

static inline JSC::EncodedJSValue jsMediaStreamTrackPrototypeFunctionApplyConstraintsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSMediaStreamTrack>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto constraints = convert<IDLDictionary<MediaTrackConstraints>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.applyConstraints(WTFMove(constraints), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamTrackPrototypeFunctionApplyConstraints(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSMediaStreamTrack>::call<jsMediaStreamTrackPrototypeFunctionApplyConstraintsBody>(*lexicalGlobalObject, *callFrame, "applyConstraints");
}

void JSMediaStreamTrack::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaStreamTrack*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaStreamTrackOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsMediaStreamTrack = jsCast<JSMediaStreamTrack*>(handle.slot()->asCell());
    if (jsMediaStreamTrack->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsMediaStreamTrack->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaStreamTrackOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaStreamTrack = static_cast<JSMediaStreamTrack*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaStreamTrack->wrapped(), jsMediaStreamTrack);
}

MediaStreamTrack* JSMediaStreamTrack::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaStreamTrack*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_STREAM)
