/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaTrackConstraints.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_STREAM)

template<> MediaTrackConstraints convertDictionary<MediaTrackConstraints>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MediaTrackConstraints result;
    JSValue aspectRatioValue;
    if (isNullOrUndefined)
        aspectRatioValue = jsUndefined();
    else {
        aspectRatioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "aspectRatio"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!aspectRatioValue.isUndefined()) {
        result.aspectRatio = convert<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, aspectRatioValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue deviceIdValue;
    if (isNullOrUndefined)
        deviceIdValue = jsUndefined();
    else {
        deviceIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deviceId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deviceIdValue.isUndefined()) {
        result.deviceId = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, deviceIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue displaySurfaceValue;
    if (isNullOrUndefined)
        displaySurfaceValue = jsUndefined();
    else {
        displaySurfaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displaySurface"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displaySurfaceValue.isUndefined()) {
        result.displaySurface = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, displaySurfaceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue echoCancellationValue;
    if (isNullOrUndefined)
        echoCancellationValue = jsUndefined();
    else {
        echoCancellationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "echoCancellation"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!echoCancellationValue.isUndefined()) {
        result.echoCancellation = convert<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, echoCancellationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue facingModeValue;
    if (isNullOrUndefined)
        facingModeValue = jsUndefined();
    else {
        facingModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "facingMode"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!facingModeValue.isUndefined()) {
        result.facingMode = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, facingModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue frameRateValue;
    if (isNullOrUndefined)
        frameRateValue = jsUndefined();
    else {
        frameRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameRate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frameRateValue.isUndefined()) {
        result.frameRate = convert<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, frameRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue groupIdValue;
    if (isNullOrUndefined)
        groupIdValue = jsUndefined();
    else {
        groupIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "groupId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!groupIdValue.isUndefined()) {
        result.groupId = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, groupIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!heightValue.isUndefined()) {
        result.height = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, heightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue logicalSurfaceValue;
    if (isNullOrUndefined)
        logicalSurfaceValue = jsUndefined();
    else {
        logicalSurfaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "logicalSurface"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!logicalSurfaceValue.isUndefined()) {
        result.logicalSurface = convert<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, logicalSurfaceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sampleRateValue;
    if (isNullOrUndefined)
        sampleRateValue = jsUndefined();
    else {
        sampleRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleRate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleRateValue.isUndefined()) {
        result.sampleRate = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, sampleRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sampleSizeValue;
    if (isNullOrUndefined)
        sampleSizeValue = jsUndefined();
    else {
        sampleSizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleSize"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleSizeValue.isUndefined()) {
        result.sampleSize = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, sampleSizeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue volumeValue;
    if (isNullOrUndefined)
        volumeValue = jsUndefined();
    else {
        volumeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "volume"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!volumeValue.isUndefined()) {
        result.volume = convert<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, volumeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!widthValue.isUndefined()) {
        result.width = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, widthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue advancedValue;
    if (isNullOrUndefined)
        advancedValue = jsUndefined();
    else {
        advancedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "advanced"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!advancedValue.isUndefined()) {
        result.advanced = convert<IDLSequence<IDLDictionary<MediaTrackConstraintSet>>>(lexicalGlobalObject, advancedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaTrackConstraints& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::isNullValue(dictionary.aspectRatio)) {
        auto aspectRatioValue = toJS<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::extractValueFromNullable(dictionary.aspectRatio));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "aspectRatio"), aspectRatioValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.deviceId)) {
        auto deviceIdValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.deviceId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "deviceId"), deviceIdValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.displaySurface)) {
        auto displaySurfaceValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.displaySurface));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "displaySurface"), displaySurfaceValue);
    }
    if (!IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::isNullValue(dictionary.echoCancellation)) {
        auto echoCancellationValue = toJS<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::extractValueFromNullable(dictionary.echoCancellation));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "echoCancellation"), echoCancellationValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.facingMode)) {
        auto facingModeValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.facingMode));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "facingMode"), facingModeValue);
    }
    if (!IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::isNullValue(dictionary.frameRate)) {
        auto frameRateValue = toJS<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::extractValueFromNullable(dictionary.frameRate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "frameRate"), frameRateValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.groupId)) {
        auto groupIdValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.groupId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "groupId"), groupIdValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.height)) {
        auto heightValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.height));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "height"), heightValue);
    }
    if (!IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::isNullValue(dictionary.logicalSurface)) {
        auto logicalSurfaceValue = toJS<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::extractValueFromNullable(dictionary.logicalSurface));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "logicalSurface"), logicalSurfaceValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.sampleRate)) {
        auto sampleRateValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.sampleRate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleRate"), sampleRateValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.sampleSize)) {
        auto sampleSizeValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.sampleSize));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleSize"), sampleSizeValue);
    }
    if (!IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::isNullValue(dictionary.volume)) {
        auto volumeValue = toJS<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::extractValueFromNullable(dictionary.volume));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "volume"), volumeValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.width)) {
        auto widthValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.width));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "width"), widthValue);
    }
    if (!IDLSequence<IDLDictionary<MediaTrackConstraintSet>>::isNullValue(dictionary.advanced)) {
        auto advancedValue = toJS<IDLSequence<IDLDictionary<MediaTrackConstraintSet>>>(lexicalGlobalObject, globalObject, IDLSequence<IDLDictionary<MediaTrackConstraintSet>>::extractValueFromNullable(dictionary.advanced));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "advanced"), advancedValue);
    }
    return result;
}

#endif

#if ENABLE(MEDIA_STREAM)

template<> MediaTrackConstraintSet convertDictionary<MediaTrackConstraintSet>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MediaTrackConstraintSet result;
    JSValue aspectRatioValue;
    if (isNullOrUndefined)
        aspectRatioValue = jsUndefined();
    else {
        aspectRatioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "aspectRatio"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!aspectRatioValue.isUndefined()) {
        result.aspectRatio = convert<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, aspectRatioValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue deviceIdValue;
    if (isNullOrUndefined)
        deviceIdValue = jsUndefined();
    else {
        deviceIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deviceId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deviceIdValue.isUndefined()) {
        result.deviceId = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, deviceIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue displaySurfaceValue;
    if (isNullOrUndefined)
        displaySurfaceValue = jsUndefined();
    else {
        displaySurfaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displaySurface"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displaySurfaceValue.isUndefined()) {
        result.displaySurface = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, displaySurfaceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue echoCancellationValue;
    if (isNullOrUndefined)
        echoCancellationValue = jsUndefined();
    else {
        echoCancellationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "echoCancellation"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!echoCancellationValue.isUndefined()) {
        result.echoCancellation = convert<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, echoCancellationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue facingModeValue;
    if (isNullOrUndefined)
        facingModeValue = jsUndefined();
    else {
        facingModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "facingMode"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!facingModeValue.isUndefined()) {
        result.facingMode = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, facingModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue frameRateValue;
    if (isNullOrUndefined)
        frameRateValue = jsUndefined();
    else {
        frameRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameRate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frameRateValue.isUndefined()) {
        result.frameRate = convert<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, frameRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue groupIdValue;
    if (isNullOrUndefined)
        groupIdValue = jsUndefined();
    else {
        groupIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "groupId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!groupIdValue.isUndefined()) {
        result.groupId = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, groupIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!heightValue.isUndefined()) {
        result.height = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, heightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue logicalSurfaceValue;
    if (isNullOrUndefined)
        logicalSurfaceValue = jsUndefined();
    else {
        logicalSurfaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "logicalSurface"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!logicalSurfaceValue.isUndefined()) {
        result.logicalSurface = convert<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, logicalSurfaceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sampleRateValue;
    if (isNullOrUndefined)
        sampleRateValue = jsUndefined();
    else {
        sampleRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleRate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleRateValue.isUndefined()) {
        result.sampleRate = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, sampleRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sampleSizeValue;
    if (isNullOrUndefined)
        sampleSizeValue = jsUndefined();
    else {
        sampleSizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleSize"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleSizeValue.isUndefined()) {
        result.sampleSize = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, sampleSizeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue volumeValue;
    if (isNullOrUndefined)
        volumeValue = jsUndefined();
    else {
        volumeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "volume"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!volumeValue.isUndefined()) {
        result.volume = convert<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, volumeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!widthValue.isUndefined()) {
        result.width = convert<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, widthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaTrackConstraintSet& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::isNullValue(dictionary.aspectRatio)) {
        auto aspectRatioValue = toJS<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::extractValueFromNullable(dictionary.aspectRatio));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "aspectRatio"), aspectRatioValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.deviceId)) {
        auto deviceIdValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.deviceId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "deviceId"), deviceIdValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.displaySurface)) {
        auto displaySurfaceValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.displaySurface));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "displaySurface"), displaySurfaceValue);
    }
    if (!IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::isNullValue(dictionary.echoCancellation)) {
        auto echoCancellationValue = toJS<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::extractValueFromNullable(dictionary.echoCancellation));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "echoCancellation"), echoCancellationValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.facingMode)) {
        auto facingModeValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.facingMode));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "facingMode"), facingModeValue);
    }
    if (!IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::isNullValue(dictionary.frameRate)) {
        auto frameRateValue = toJS<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::extractValueFromNullable(dictionary.frameRate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "frameRate"), frameRateValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::isNullValue(dictionary.groupId)) {
        auto groupIdValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>, IDLDictionary<ConstrainDOMStringParameters>>::extractValueFromNullable(dictionary.groupId));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "groupId"), groupIdValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.height)) {
        auto heightValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.height));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "height"), heightValue);
    }
    if (!IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::isNullValue(dictionary.logicalSurface)) {
        auto logicalSurfaceValue = toJS<IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLBoolean, IDLDictionary<ConstrainBooleanParameters>>::extractValueFromNullable(dictionary.logicalSurface));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "logicalSurface"), logicalSurfaceValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.sampleRate)) {
        auto sampleRateValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.sampleRate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleRate"), sampleRateValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.sampleSize)) {
        auto sampleSizeValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.sampleSize));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleSize"), sampleSizeValue);
    }
    if (!IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::isNullValue(dictionary.volume)) {
        auto volumeValue = toJS<IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDouble, IDLDictionary<ConstrainDoubleRange>>::extractValueFromNullable(dictionary.volume));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "volume"), volumeValue);
    }
    if (!IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::isNullValue(dictionary.width)) {
        auto widthValue = toJS<IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLLong, IDLDictionary<ConstrainLongRange>>::extractValueFromNullable(dictionary.width));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "width"), widthValue);
    }
    return result;
}

#endif

#if ENABLE(MEDIA_STREAM)

template<> ConstrainBooleanParameters convertDictionary<ConstrainBooleanParameters>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ConstrainBooleanParameters result;
    JSValue exactValue;
    if (isNullOrUndefined)
        exactValue = jsUndefined();
    else {
        exactValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "exact"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!exactValue.isUndefined()) {
        result.exact = convert<IDLBoolean>(lexicalGlobalObject, exactValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue idealValue;
    if (isNullOrUndefined)
        idealValue = jsUndefined();
    else {
        idealValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ideal"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idealValue.isUndefined()) {
        result.ideal = convert<IDLBoolean>(lexicalGlobalObject, idealValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const ConstrainBooleanParameters& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLBoolean::isNullValue(dictionary.exact)) {
        auto exactValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.exact));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "exact"), exactValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.ideal)) {
        auto idealValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.ideal));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ideal"), idealValue);
    }
    return result;
}

#endif

#if ENABLE(MEDIA_STREAM)

template<> ConstrainDOMStringParameters convertDictionary<ConstrainDOMStringParameters>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ConstrainDOMStringParameters result;
    JSValue exactValue;
    if (isNullOrUndefined)
        exactValue = jsUndefined();
    else {
        exactValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "exact"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!exactValue.isUndefined()) {
        result.exact = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>(lexicalGlobalObject, exactValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue idealValue;
    if (isNullOrUndefined)
        idealValue = jsUndefined();
    else {
        idealValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ideal"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idealValue.isUndefined()) {
        result.ideal = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>(lexicalGlobalObject, idealValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const ConstrainDOMStringParameters& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>::isNullValue(dictionary.exact)) {
        auto exactValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>::extractValueFromNullable(dictionary.exact));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "exact"), exactValue);
    }
    if (!IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>::isNullValue(dictionary.ideal)) {
        auto idealValue = toJS<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>(lexicalGlobalObject, globalObject, IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>::extractValueFromNullable(dictionary.ideal));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ideal"), idealValue);
    }
    return result;
}

#endif

#if ENABLE(MEDIA_STREAM)

template<> ConstrainDoubleRange convertDictionary<ConstrainDoubleRange>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ConstrainDoubleRange result;
    JSValue maxValue;
    if (isNullOrUndefined)
        maxValue = jsUndefined();
    else {
        maxValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "max"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maxValue.isUndefined()) {
        result.max = convert<IDLDouble>(lexicalGlobalObject, maxValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue minValue;
    if (isNullOrUndefined)
        minValue = jsUndefined();
    else {
        minValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "min"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!minValue.isUndefined()) {
        result.min = convert<IDLDouble>(lexicalGlobalObject, minValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue exactValue;
    if (isNullOrUndefined)
        exactValue = jsUndefined();
    else {
        exactValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "exact"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!exactValue.isUndefined()) {
        result.exact = convert<IDLDouble>(lexicalGlobalObject, exactValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue idealValue;
    if (isNullOrUndefined)
        idealValue = jsUndefined();
    else {
        idealValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ideal"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idealValue.isUndefined()) {
        result.ideal = convert<IDLDouble>(lexicalGlobalObject, idealValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const ConstrainDoubleRange& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDouble::isNullValue(dictionary.max)) {
        auto maxValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.max));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "max"), maxValue);
    }
    if (!IDLDouble::isNullValue(dictionary.min)) {
        auto minValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.min));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "min"), minValue);
    }
    if (!IDLDouble::isNullValue(dictionary.exact)) {
        auto exactValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.exact));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "exact"), exactValue);
    }
    if (!IDLDouble::isNullValue(dictionary.ideal)) {
        auto idealValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.ideal));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ideal"), idealValue);
    }
    return result;
}

#endif

#if ENABLE(MEDIA_STREAM)

template<> ConstrainLongRange convertDictionary<ConstrainLongRange>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ConstrainLongRange result;
    JSValue maxValue;
    if (isNullOrUndefined)
        maxValue = jsUndefined();
    else {
        maxValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "max"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maxValue.isUndefined()) {
        result.max = convert<IDLLong>(lexicalGlobalObject, maxValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue minValue;
    if (isNullOrUndefined)
        minValue = jsUndefined();
    else {
        minValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "min"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!minValue.isUndefined()) {
        result.min = convert<IDLLong>(lexicalGlobalObject, minValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue exactValue;
    if (isNullOrUndefined)
        exactValue = jsUndefined();
    else {
        exactValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "exact"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!exactValue.isUndefined()) {
        result.exact = convert<IDLLong>(lexicalGlobalObject, exactValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue idealValue;
    if (isNullOrUndefined)
        idealValue = jsUndefined();
    else {
        idealValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ideal"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idealValue.isUndefined()) {
        result.ideal = convert<IDLLong>(lexicalGlobalObject, idealValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const ConstrainLongRange& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLLong::isNullValue(dictionary.max)) {
        auto maxValue = toJS<IDLLong>(IDLLong::extractValueFromNullable(dictionary.max));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "max"), maxValue);
    }
    if (!IDLLong::isNullValue(dictionary.min)) {
        auto minValue = toJS<IDLLong>(IDLLong::extractValueFromNullable(dictionary.min));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "min"), minValue);
    }
    if (!IDLLong::isNullValue(dictionary.exact)) {
        auto exactValue = toJS<IDLLong>(IDLLong::extractValueFromNullable(dictionary.exact));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "exact"), exactValue);
    }
    if (!IDLLong::isNullValue(dictionary.ideal)) {
        auto idealValue = toJS<IDLLong>(IDLLong::extractValueFromNullable(dictionary.ideal));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ideal"), idealValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(MEDIA_STREAM)
