/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMemoryInfo.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsMemoryInfoUsedJSHeapSize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMemoryInfoTotalJSHeapSize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSMemoryInfoPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMemoryInfoPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMemoryInfoPrototype* ptr = new (NotNull, JSC::allocateCell<JSMemoryInfoPrototype>(vm.heap)) JSMemoryInfoPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMemoryInfoPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMemoryInfoPrototype, JSMemoryInfoPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSMemoryInfoPrototypeTableValues[] =
{
    { "usedJSHeapSize", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMemoryInfoUsedJSHeapSize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "totalJSHeapSize", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMemoryInfoTotalJSHeapSize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSMemoryInfoPrototype::s_info = { "MemoryInfoPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMemoryInfoPrototype) };

void JSMemoryInfoPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMemoryInfo::info(), JSMemoryInfoPrototypeTableValues, *this);
}

const ClassInfo JSMemoryInfo::s_info = { "MemoryInfo", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMemoryInfo) };

JSMemoryInfo::JSMemoryInfo(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MemoryInfo>&& impl)
    : JSDOMWrapper<MemoryInfo>(structure, globalObject, WTFMove(impl))
{
}

void JSMemoryInfo::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, MemoryInfo>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSMemoryInfo::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMemoryInfoPrototype::create(vm, &globalObject, JSMemoryInfoPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSMemoryInfo::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMemoryInfo>(vm, globalObject);
}

void JSMemoryInfo::destroy(JSC::JSCell* cell)
{
    JSMemoryInfo* thisObject = static_cast<JSMemoryInfo*>(cell);
    thisObject->JSMemoryInfo::~JSMemoryInfo();
}

template<> inline JSMemoryInfo* IDLAttribute<JSMemoryInfo>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMemoryInfo*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

static inline JSValue jsMemoryInfoUsedJSHeapSizeGetter(JSGlobalObject& lexicalGlobalObject, JSMemoryInfo& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.usedJSHeapSize());
    return result;
}

EncodedJSValue jsMemoryInfoUsedJSHeapSize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMemoryInfo>::get<jsMemoryInfoUsedJSHeapSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "usedJSHeapSize");
}

static inline JSValue jsMemoryInfoTotalJSHeapSizeGetter(JSGlobalObject& lexicalGlobalObject, JSMemoryInfo& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.totalJSHeapSize());
    return result;
}

EncodedJSValue jsMemoryInfoTotalJSHeapSize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMemoryInfo>::get<jsMemoryInfoTotalJSHeapSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "totalJSHeapSize");
}

void JSMemoryInfo::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMemoryInfo*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMemoryInfoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMemoryInfoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMemoryInfo = static_cast<JSMemoryInfo*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMemoryInfo->wrapped(), jsMemoryInfo);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MemoryInfo>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to MemoryInfo.
    static_assert(!std::is_polymorphic<MemoryInfo>::value, "MemoryInfo is polymorphic but the IDL claims it is not");
    return createWrapper<MemoryInfo>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MemoryInfo& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MemoryInfo* JSMemoryInfo::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMemoryInfo*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
