/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(CONTENT_FILTERING)

#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "MockContentFilterSettings.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSMockContentFilterSettings : public JSDOMWrapper<MockContentFilterSettings> {
public:
    using Base = JSDOMWrapper<MockContentFilterSettings>;
    static JSMockContentFilterSettings* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<MockContentFilterSettings>&& impl)
    {
        JSMockContentFilterSettings* ptr = new (NotNull, JSC::allocateCell<JSMockContentFilterSettings>(globalObject->vm().heap)) JSMockContentFilterSettings(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static MockContentFilterSettings* toWrapped(JSC::VM&, JSC::JSValue);
    static void destroy(JSC::JSCell*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
protected:
    JSMockContentFilterSettings(JSC::Structure*, JSDOMGlobalObject&, Ref<MockContentFilterSettings>&&);

    void finishCreation(JSC::VM&);
};

class JSMockContentFilterSettingsOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, MockContentFilterSettings*)
{
    static NeverDestroyed<JSMockContentFilterSettingsOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(MockContentFilterSettings* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, MockContentFilterSettings&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MockContentFilterSettings* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<MockContentFilterSettings>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<MockContentFilterSettings>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<MockContentFilterSettings> {
    using WrapperClass = JSMockContentFilterSettings;
    using ToWrappedReturnType = MockContentFilterSettings*;
};
String convertEnumerationToString(MockContentFilterSettings::DecisionPoint);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, MockContentFilterSettings::DecisionPoint);

template<> Optional<MockContentFilterSettings::DecisionPoint> parseEnumeration<MockContentFilterSettings::DecisionPoint>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<MockContentFilterSettings::DecisionPoint>();

String convertEnumerationToString(MockContentFilterSettings::Decision);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, MockContentFilterSettings::Decision);

template<> Optional<MockContentFilterSettings::Decision> parseEnumeration<MockContentFilterSettings::Decision>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<MockContentFilterSettings::Decision>();


} // namespace WebCore

#endif // ENABLE(CONTENT_FILTERING)
