/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMockPageOverlay.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMockPageOverlayPrototypeFunctionSetFrame(JSC::JSGlobalObject*, JSC::CallFrame*);

class JSMockPageOverlayPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMockPageOverlayPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMockPageOverlayPrototype* ptr = new (NotNull, JSC::allocateCell<JSMockPageOverlayPrototype>(vm.heap)) JSMockPageOverlayPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMockPageOverlayPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMockPageOverlayPrototype, JSMockPageOverlayPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSMockPageOverlayPrototypeTableValues[] =
{
    { "setFrame", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMockPageOverlayPrototypeFunctionSetFrame), (intptr_t) (4) } },
};

const ClassInfo JSMockPageOverlayPrototype::s_info = { "MockPageOverlayPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMockPageOverlayPrototype) };

void JSMockPageOverlayPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMockPageOverlay::info(), JSMockPageOverlayPrototypeTableValues, *this);
}

const ClassInfo JSMockPageOverlay::s_info = { "MockPageOverlay", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMockPageOverlay) };

JSMockPageOverlay::JSMockPageOverlay(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MockPageOverlay>&& impl)
    : JSDOMWrapper<MockPageOverlay>(structure, globalObject, WTFMove(impl))
{
}

void JSMockPageOverlay::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, MockPageOverlay>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSMockPageOverlay::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMockPageOverlayPrototype::create(vm, &globalObject, JSMockPageOverlayPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSMockPageOverlay::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMockPageOverlay>(vm, globalObject);
}

void JSMockPageOverlay::destroy(JSC::JSCell* cell)
{
    JSMockPageOverlay* thisObject = static_cast<JSMockPageOverlay*>(cell);
    thisObject->JSMockPageOverlay::~JSMockPageOverlay();
}

template<> inline JSMockPageOverlay* IDLOperation<JSMockPageOverlay>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSMockPageOverlay*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSC::EncodedJSValue jsMockPageOverlayPrototypeFunctionSetFrameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMockPageOverlay>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setFrame(WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMockPageOverlayPrototypeFunctionSetFrame(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMockPageOverlay>::call<jsMockPageOverlayPrototypeFunctionSetFrameBody>(*lexicalGlobalObject, *callFrame, "setFrame");
}

void JSMockPageOverlay::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMockPageOverlay*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMockPageOverlayOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMockPageOverlayOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMockPageOverlay = static_cast<JSMockPageOverlay*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMockPageOverlay->wrapped(), jsMockPageOverlay);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MockPageOverlay>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to MockPageOverlay.
    static_assert(!std::is_polymorphic<MockPageOverlay>::value, "MockPageOverlay is polymorphic but the IDL claims it is not");
    return createWrapper<MockPageOverlay>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MockPageOverlay& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MockPageOverlay* JSMockPageOverlay::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMockPageOverlay*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
