/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNodeIterator.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsNodeIteratorPrototypeFunctionNextNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodeIteratorPrototypeFunctionPreviousNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodeIteratorPrototypeFunctionDetach(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsNodeIteratorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSNodeIteratorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsNodeIteratorRoot(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeIteratorReferenceNode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeIteratorPointerBeforeReferenceNode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeIteratorWhatToShow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNodeIteratorFilter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSNodeIteratorPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSNodeIteratorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNodeIteratorPrototype* ptr = new (NotNull, JSC::allocateCell<JSNodeIteratorPrototype>(vm.heap)) JSNodeIteratorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNodeIteratorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNodeIteratorPrototype, JSNodeIteratorPrototype::Base);

using JSNodeIteratorConstructor = JSDOMConstructorNotConstructable<JSNodeIterator>;

template<> JSValue JSNodeIteratorConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSNodeIteratorConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSNodeIterator::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("NodeIterator"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSNodeIteratorConstructor::s_info = { "NodeIterator", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNodeIteratorConstructor) };

/* Hash table for prototype */

static const HashTableValue JSNodeIteratorPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeIteratorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNodeIteratorConstructor) } },
    { "root", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeIteratorRoot), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "referenceNode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeIteratorReferenceNode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pointerBeforeReferenceNode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeIteratorPointerBeforeReferenceNode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "whatToShow", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeIteratorWhatToShow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "filter", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeIteratorFilter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "nextNode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsNodeIteratorPrototypeFunctionNextNode), (intptr_t) (0) } },
    { "previousNode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsNodeIteratorPrototypeFunctionPreviousNode), (intptr_t) (0) } },
    { "detach", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsNodeIteratorPrototypeFunctionDetach), (intptr_t) (0) } },
};

const ClassInfo JSNodeIteratorPrototype::s_info = { "NodeIteratorPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNodeIteratorPrototype) };

void JSNodeIteratorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNodeIterator::info(), JSNodeIteratorPrototypeTableValues, *this);
}

const ClassInfo JSNodeIterator::s_info = { "NodeIterator", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNodeIterator) };

JSNodeIterator::JSNodeIterator(Structure* structure, JSDOMGlobalObject& globalObject, Ref<NodeIterator>&& impl)
    : JSDOMWrapper<NodeIterator>(structure, globalObject, WTFMove(impl))
{
}

void JSNodeIterator::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, NodeIterator>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSNodeIterator::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSNodeIteratorPrototype::create(vm, &globalObject, JSNodeIteratorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSNodeIterator::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSNodeIterator>(vm, globalObject);
}

JSValue JSNodeIterator::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNodeIteratorConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSNodeIterator::destroy(JSC::JSCell* cell)
{
    JSNodeIterator* thisObject = static_cast<JSNodeIterator*>(cell);
    thisObject->JSNodeIterator::~JSNodeIterator();
}

template<> inline JSNodeIterator* IDLAttribute<JSNodeIterator>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSNodeIterator*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSNodeIterator* IDLOperation<JSNodeIterator>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSNodeIterator*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsNodeIteratorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNodeIteratorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSNodeIterator::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSNodeIteratorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNodeIteratorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsNodeIteratorRootGetter(JSGlobalObject& lexicalGlobalObject, JSNodeIterator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Node>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.root());
    return result;
}

EncodedJSValue jsNodeIteratorRoot(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNodeIterator>::get<jsNodeIteratorRootGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "root");
}

static inline JSValue jsNodeIteratorReferenceNodeGetter(JSGlobalObject& lexicalGlobalObject, JSNodeIterator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Node>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.referenceNode());
    return result;
}

EncodedJSValue jsNodeIteratorReferenceNode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNodeIterator>::get<jsNodeIteratorReferenceNodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "referenceNode");
}

static inline JSValue jsNodeIteratorPointerBeforeReferenceNodeGetter(JSGlobalObject& lexicalGlobalObject, JSNodeIterator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.pointerBeforeReferenceNode());
    return result;
}

EncodedJSValue jsNodeIteratorPointerBeforeReferenceNode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNodeIterator>::get<jsNodeIteratorPointerBeforeReferenceNodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pointerBeforeReferenceNode");
}

static inline JSValue jsNodeIteratorWhatToShowGetter(JSGlobalObject& lexicalGlobalObject, JSNodeIterator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.whatToShow());
    return result;
}

EncodedJSValue jsNodeIteratorWhatToShow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNodeIterator>::get<jsNodeIteratorWhatToShowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "whatToShow");
}

static inline JSValue jsNodeIteratorFilterGetter(JSGlobalObject& lexicalGlobalObject, JSNodeIterator& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLCallbackInterface<JSNodeFilter>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.filter());
    return result;
}

EncodedJSValue jsNodeIteratorFilter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNodeIterator>::get<jsNodeIteratorFilterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "filter");
}

static inline JSC::EncodedJSValue jsNodeIteratorPrototypeFunctionNextNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNodeIterator>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.nextNode()));
}

EncodedJSValue JSC_HOST_CALL jsNodeIteratorPrototypeFunctionNextNode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSNodeIterator>::call<jsNodeIteratorPrototypeFunctionNextNodeBody>(*lexicalGlobalObject, *callFrame, "nextNode");
}

static inline JSC::EncodedJSValue jsNodeIteratorPrototypeFunctionPreviousNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNodeIterator>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.previousNode()));
}

EncodedJSValue JSC_HOST_CALL jsNodeIteratorPrototypeFunctionPreviousNode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSNodeIterator>::call<jsNodeIteratorPrototypeFunctionPreviousNodeBody>(*lexicalGlobalObject, *callFrame, "previousNode");
}

static inline JSC::EncodedJSValue jsNodeIteratorPrototypeFunctionDetachBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNodeIterator>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.detach();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsNodeIteratorPrototypeFunctionDetach(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSNodeIterator>::call<jsNodeIteratorPrototypeFunctionDetachBody>(*lexicalGlobalObject, *callFrame, "detach");
}

void JSNodeIterator::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSNodeIterator*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSNodeIterator::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSNodeIterator*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSNodeIterator::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSNodeIterator*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSNodeIteratorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSNodeIteratorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNodeIterator = static_cast<JSNodeIterator*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsNodeIterator->wrapped(), jsNodeIterator);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<NodeIterator>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to NodeIterator.
    static_assert(!std::is_polymorphic<NodeIterator>::value, "NodeIterator is polymorphic but the IDL claims it is not");
    return createWrapper<NodeIterator>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, NodeIterator& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

NodeIterator* JSNodeIterator::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSNodeIterator*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
