/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(NOTIFICATIONS)

#include "JSNotification.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSNotificationPermission.h"
#include "JSNotificationPermissionCallback.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(NOTIFICATIONS)

String convertEnumerationToString(Notification::Direction enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("auto"),
        MAKE_STATIC_STRING_IMPL("ltr"),
        MAKE_STATIC_STRING_IMPL("rtl"),
    };
    static_assert(static_cast<size_t>(Notification::Direction::Auto) == 0, "Notification::Direction::Auto is not 0 as expected");
    static_assert(static_cast<size_t>(Notification::Direction::Ltr) == 1, "Notification::Direction::Ltr is not 1 as expected");
    static_assert(static_cast<size_t>(Notification::Direction::Rtl) == 2, "Notification::Direction::Rtl is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, Notification::Direction enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<Notification::Direction> parseEnumeration<Notification::Direction>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "auto")
        return Notification::Direction::Auto;
    if (stringValue == "ltr")
        return Notification::Direction::Ltr;
    if (stringValue == "rtl")
        return Notification::Direction::Rtl;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<Notification::Direction>()
{
    return "\"auto\", \"ltr\", \"rtl\"";
}

#endif

#if ENABLE(NOTIFICATIONS)

template<> Notification::Options convertDictionary<Notification::Options>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    Notification::Options result;
    JSValue bodyValue;
    if (isNullOrUndefined)
        bodyValue = jsUndefined();
    else {
        bodyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "body"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bodyValue.isUndefined()) {
        result.body = convert<IDLDOMString>(lexicalGlobalObject, bodyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.body = emptyString();
    JSValue dirValue;
    if (isNullOrUndefined)
        dirValue = jsUndefined();
    else {
        dirValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "dir"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dirValue.isUndefined()) {
        result.dir = convert<IDLEnumeration<Notification::Direction>>(lexicalGlobalObject, dirValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.dir = Notification::Direction::Auto;
    JSValue iconValue;
    if (isNullOrUndefined)
        iconValue = jsUndefined();
    else {
        iconValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "icon"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!iconValue.isUndefined()) {
        result.icon = convert<IDLUSVString>(lexicalGlobalObject, iconValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue langValue;
    if (isNullOrUndefined)
        langValue = jsUndefined();
    else {
        langValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lang"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!langValue.isUndefined()) {
        result.lang = convert<IDLDOMString>(lexicalGlobalObject, langValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.lang = emptyString();
    JSValue tagValue;
    if (isNullOrUndefined)
        tagValue = jsUndefined();
    else {
        tagValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tag"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!tagValue.isUndefined()) {
        result.tag = convert<IDLDOMString>(lexicalGlobalObject, tagValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.tag = emptyString();
    return result;
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsNotificationConstructorFunctionRequestPermission(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionClose(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionShow(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsNotificationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSNotificationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsNotificationConstructorPermission(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNotificationOnclick(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSNotificationOnclick(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsNotificationOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSNotificationOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsNotificationTitle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNotificationDir(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNotificationLang(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNotificationBody(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNotificationTag(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNotificationIcon(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNotificationOnclose(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSNotificationOnclose(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsNotificationOndisplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSNotificationOndisplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsNotificationOnshow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSNotificationOnshow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSNotificationPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSNotificationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNotificationPrototype* ptr = new (NotNull, JSC::allocateCell<JSNotificationPrototype>(vm.heap)) JSNotificationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNotificationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNotificationPrototype, JSNotificationPrototype::Base);

using JSNotificationConstructor = JSDOMConstructor<JSNotification>;

/* Hash table for constructor */

static const HashTableValue JSNotificationConstructorTableValues[] =
{
    { "permission", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationConstructorPermission), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "requestPermission", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsNotificationConstructorFunctionRequestPermission), (intptr_t) (0) } },
};

template<> EncodedJSValue JSC_HOST_CALL JSNotificationConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSNotificationConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "Notification");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto title = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = convert<IDLDictionary<Notification::Options>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = Notification::create(document, WTFMove(title), WTFMove(options));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<Notification>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSNotificationConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSNotificationConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSNotification::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("Notification"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSNotification::info(), JSNotificationConstructorTableValues, *this);
}

template<> const ClassInfo JSNotificationConstructor::s_info = { "Notification", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNotificationConstructor) };

/* Hash table for prototype */

static const HashTableValue JSNotificationPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNotificationConstructor) } },
    { "onclick", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOnclick), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNotificationOnclick) } },
    { "onerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNotificationOnerror) } },
    { "title", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationTitle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "dir", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationDir), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lang", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationLang), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "body", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationBody), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "tag", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationTag), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "icon", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationIcon), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onclose", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOnclose), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNotificationOnclose) } },
    { "ondisplay", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOndisplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNotificationOndisplay) } },
    { "onshow", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOnshow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNotificationOnshow) } },
    { "close", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsNotificationPrototypeFunctionClose), (intptr_t) (0) } },
    { "show", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsNotificationPrototypeFunctionShow), (intptr_t) (0) } },
};

const ClassInfo JSNotificationPrototype::s_info = { "NotificationPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNotificationPrototype) };

void JSNotificationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNotification::info(), JSNotificationPrototypeTableValues, *this);
}

const ClassInfo JSNotification::s_info = { "Notification", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNotification) };

JSNotification::JSNotification(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Notification>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSNotification::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, Notification>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSNotification::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSNotificationPrototype::create(vm, &globalObject, JSNotificationPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSNotification::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSNotification>(vm, globalObject);
}

JSValue JSNotification::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNotificationConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSNotification* IDLAttribute<JSNotification>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSNotification*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSNotification* IDLOperation<JSNotification>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSNotification*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsNotificationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNotificationPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSNotification::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSNotificationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNotificationPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsNotificationConstructorPermissionGetter(JSGlobalObject& lexicalGlobalObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return jsUndefined();
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    JSValue result = toJS<IDLEnumeration<NotificationPermission>>(lexicalGlobalObject, throwScope, Notification::permission(document));
    return result;
}

EncodedJSValue jsNotificationConstructorPermission(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNotification>::getStatic<jsNotificationConstructorPermissionGetter>(*lexicalGlobalObject, thisValue, "permission");
}

static inline JSValue jsNotificationOnclickGetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().clickEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsNotificationOnclick(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNotification>::get<jsNotificationOnclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onclick");
}

static inline bool setJSNotificationOnclickSetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().clickEvent, value);
    return true;
}

bool setJSNotificationOnclick(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSNotification>::set<setJSNotificationOnclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onclick");
}

static inline JSValue jsNotificationOnerrorGetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsNotificationOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNotification>::get<jsNotificationOnerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onerror");
}

static inline bool setJSNotificationOnerrorSetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().errorEvent, value);
    return true;
}

bool setJSNotificationOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSNotification>::set<setJSNotificationOnerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onerror");
}

static inline JSValue jsNotificationTitleGetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.title());
    return result;
}

EncodedJSValue jsNotificationTitle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNotification>::get<jsNotificationTitleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "title");
}

static inline JSValue jsNotificationDirGetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<Notification::Direction>>(lexicalGlobalObject, throwScope, impl.dir());
    return result;
}

EncodedJSValue jsNotificationDir(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNotification>::get<jsNotificationDirGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "dir");
}

static inline JSValue jsNotificationLangGetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.lang());
    return result;
}

EncodedJSValue jsNotificationLang(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNotification>::get<jsNotificationLangGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lang");
}

static inline JSValue jsNotificationBodyGetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.body());
    return result;
}

EncodedJSValue jsNotificationBody(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNotification>::get<jsNotificationBodyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "body");
}

static inline JSValue jsNotificationTagGetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.tag());
    return result;
}

EncodedJSValue jsNotificationTag(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNotification>::get<jsNotificationTagGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "tag");
}

static inline JSValue jsNotificationIconGetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.icon());
    return result;
}

EncodedJSValue jsNotificationIcon(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNotification>::get<jsNotificationIconGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "icon");
}

static inline JSValue jsNotificationOncloseGetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().closeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsNotificationOnclose(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNotification>::get<jsNotificationOncloseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onclose");
}

static inline bool setJSNotificationOncloseSetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().closeEvent, value);
    return true;
}

bool setJSNotificationOnclose(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSNotification>::set<setJSNotificationOncloseSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onclose");
}

static inline JSValue jsNotificationOndisplayGetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().showEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsNotificationOndisplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNotification>::get<jsNotificationOndisplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondisplay");
}

static inline bool setJSNotificationOndisplaySetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().showEvent, value);
    return true;
}

bool setJSNotificationOndisplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSNotification>::set<setJSNotificationOndisplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondisplay");
}

static inline JSValue jsNotificationOnshowGetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().showEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsNotificationOnshow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSNotification>::get<jsNotificationOnshowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onshow");
}

static inline bool setJSNotificationOnshowSetter(JSGlobalObject& lexicalGlobalObject, JSNotification& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().showEvent, value);
    return true;
}

bool setJSNotificationOnshow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSNotification>::set<setJSNotificationOnshowSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onshow");
}

static inline JSC::EncodedJSValue jsNotificationConstructorFunctionRequestPermissionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto deprecatedCallback = convert<IDLNullable<IDLCallbackFunction<JSNotificationPermissionCallback>>>(*lexicalGlobalObject, callFrame->argument(0), *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "deprecatedCallback", "Notification", "requestPermission"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    Notification::requestPermission(document, WTFMove(deprecatedCallback));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsNotificationConstructorFunctionRequestPermission(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSNotification>::callStatic<jsNotificationConstructorFunctionRequestPermissionBody>(*lexicalGlobalObject, *callFrame, "requestPermission");
}

static inline JSC::EncodedJSValue jsNotificationPrototypeFunctionCloseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNotification>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.close();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionClose(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSNotification>::call<jsNotificationPrototypeFunctionCloseBody>(*lexicalGlobalObject, *callFrame, "close");
}

static inline JSC::EncodedJSValue jsNotificationPrototypeFunctionShowBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNotification>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.show();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionShow(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSNotification>::call<jsNotificationPrototypeFunctionShowBody>(*lexicalGlobalObject, *callFrame, "show");
}

void JSNotification::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSNotification*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSNotificationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsNotification = jsCast<JSNotification*>(handle.slot()->asCell());
    if (jsNotification->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsNotification->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSNotificationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNotification = static_cast<JSNotification*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsNotification->wrapped(), jsNotification);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Notification@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12NotificationE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<Notification>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7Notification@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12NotificationE[2];
#endif

    // If this fails Notification does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<Notification>::value, "Notification is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // Notification has subclasses. If Notification has subclasses that get passed
    // to toJS() we currently require Notification you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<Notification>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Notification& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

Notification* JSNotification::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSNotification*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(NOTIFICATIONS)
