/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESStandardDerivatives.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSOESStandardDerivativesPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESStandardDerivativesPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESStandardDerivativesPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESStandardDerivativesPrototype>(vm.heap)) JSOESStandardDerivativesPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESStandardDerivativesPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESStandardDerivativesPrototype, JSOESStandardDerivativesPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSOESStandardDerivativesPrototypeTableValues[] =
{
    { "FRAGMENT_SHADER_DERIVATIVE_HINT_OES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8B8B) } },
};

const ClassInfo JSOESStandardDerivativesPrototype::s_info = { "OESStandardDerivativesPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESStandardDerivativesPrototype) };

void JSOESStandardDerivativesPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOESStandardDerivatives::info(), JSOESStandardDerivativesPrototypeTableValues, *this);
}

const ClassInfo JSOESStandardDerivatives::s_info = { "OESStandardDerivatives", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESStandardDerivatives) };

JSOESStandardDerivatives::JSOESStandardDerivatives(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESStandardDerivatives>&& impl)
    : JSDOMWrapper<OESStandardDerivatives>(structure, globalObject, WTFMove(impl))
{
}

void JSOESStandardDerivatives::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, OESStandardDerivatives>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSOESStandardDerivatives::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSOESStandardDerivativesPrototype::create(vm, &globalObject, JSOESStandardDerivativesPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSOESStandardDerivatives::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESStandardDerivatives>(vm, globalObject);
}

void JSOESStandardDerivatives::destroy(JSC::JSCell* cell)
{
    JSOESStandardDerivatives* thisObject = static_cast<JSOESStandardDerivatives*>(cell);
    thisObject->JSOESStandardDerivatives::~JSOESStandardDerivatives();
}

void JSOESStandardDerivatives::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESStandardDerivatives*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESStandardDerivativesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsOESStandardDerivatives = jsCast<JSOESStandardDerivatives*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsOESStandardDerivatives->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from OESStandardDerivatives";
    return visitor.containsOpaqueRoot(root);
}

void JSOESStandardDerivativesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESStandardDerivatives = static_cast<JSOESStandardDerivatives*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOESStandardDerivatives->wrapped(), jsOESStandardDerivatives);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESStandardDerivatives@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22OESStandardDerivativesE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESStandardDerivatives>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7OESStandardDerivatives@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore22OESStandardDerivativesE[2];
#endif

    // If this fails OESStandardDerivatives does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<OESStandardDerivatives>::value, "OESStandardDerivatives is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // OESStandardDerivatives has subclasses. If OESStandardDerivatives has subclasses that get passed
    // to toJS() we currently require OESStandardDerivatives you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<OESStandardDerivatives>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESStandardDerivatives& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESStandardDerivatives* JSOESStandardDerivatives::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESStandardDerivatives*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
