/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESVertexArrayObject.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWebGLVertexArrayObjectOES.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsOESVertexArrayObjectPrototypeFunctionCreateVertexArrayOES(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOESVertexArrayObjectPrototypeFunctionDeleteVertexArrayOES(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOESVertexArrayObjectPrototypeFunctionIsVertexArrayOES(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOESVertexArrayObjectPrototypeFunctionBindVertexArrayOES(JSC::JSGlobalObject*, JSC::CallFrame*);

class JSOESVertexArrayObjectPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESVertexArrayObjectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESVertexArrayObjectPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESVertexArrayObjectPrototype>(vm.heap)) JSOESVertexArrayObjectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESVertexArrayObjectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESVertexArrayObjectPrototype, JSOESVertexArrayObjectPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSOESVertexArrayObjectPrototypeTableValues[] =
{
    { "createVertexArrayOES", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOESVertexArrayObjectPrototypeFunctionCreateVertexArrayOES), (intptr_t) (0) } },
    { "deleteVertexArrayOES", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOESVertexArrayObjectPrototypeFunctionDeleteVertexArrayOES), (intptr_t) (0) } },
    { "isVertexArrayOES", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOESVertexArrayObjectPrototypeFunctionIsVertexArrayOES), (intptr_t) (0) } },
    { "bindVertexArrayOES", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOESVertexArrayObjectPrototypeFunctionBindVertexArrayOES), (intptr_t) (0) } },
    { "VERTEX_ARRAY_BINDING_OES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x85B5) } },
};

const ClassInfo JSOESVertexArrayObjectPrototype::s_info = { "OESVertexArrayObjectPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESVertexArrayObjectPrototype) };

void JSOESVertexArrayObjectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOESVertexArrayObject::info(), JSOESVertexArrayObjectPrototypeTableValues, *this);
}

const ClassInfo JSOESVertexArrayObject::s_info = { "OESVertexArrayObject", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESVertexArrayObject) };

JSOESVertexArrayObject::JSOESVertexArrayObject(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESVertexArrayObject>&& impl)
    : JSDOMWrapper<OESVertexArrayObject>(structure, globalObject, WTFMove(impl))
{
}

void JSOESVertexArrayObject::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, OESVertexArrayObject>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSOESVertexArrayObject::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSOESVertexArrayObjectPrototype::create(vm, &globalObject, JSOESVertexArrayObjectPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSOESVertexArrayObject::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESVertexArrayObject>(vm, globalObject);
}

void JSOESVertexArrayObject::destroy(JSC::JSCell* cell)
{
    JSOESVertexArrayObject* thisObject = static_cast<JSOESVertexArrayObject*>(cell);
    thisObject->JSOESVertexArrayObject::~JSOESVertexArrayObject();
}

template<> inline JSOESVertexArrayObject* IDLOperation<JSOESVertexArrayObject>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSOESVertexArrayObject*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSC::EncodedJSValue jsOESVertexArrayObjectPrototypeFunctionCreateVertexArrayOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESVertexArrayObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<WebGLVertexArrayObjectOES>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createVertexArrayOES()));
}

EncodedJSValue JSC_HOST_CALL jsOESVertexArrayObjectPrototypeFunctionCreateVertexArrayOES(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOESVertexArrayObject>::call<jsOESVertexArrayObjectPrototypeFunctionCreateVertexArrayOESBody>(*lexicalGlobalObject, *callFrame, "createVertexArrayOES");
}

static inline JSC::EncodedJSValue jsOESVertexArrayObjectPrototypeFunctionDeleteVertexArrayOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESVertexArrayObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto arrayObject = convert<IDLNullable<IDLInterface<WebGLVertexArrayObjectOES>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "arrayObject", "OESVertexArrayObject", "deleteVertexArrayOES", "WebGLVertexArrayObjectOES"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.deleteVertexArrayOES(WTFMove(arrayObject));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOESVertexArrayObjectPrototypeFunctionDeleteVertexArrayOES(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOESVertexArrayObject>::call<jsOESVertexArrayObjectPrototypeFunctionDeleteVertexArrayOESBody>(*lexicalGlobalObject, *callFrame, "deleteVertexArrayOES");
}

static inline JSC::EncodedJSValue jsOESVertexArrayObjectPrototypeFunctionIsVertexArrayOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESVertexArrayObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto arrayObject = convert<IDLNullable<IDLInterface<WebGLVertexArrayObjectOES>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "arrayObject", "OESVertexArrayObject", "isVertexArrayOES", "WebGLVertexArrayObjectOES"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isVertexArrayOES(WTFMove(arrayObject))));
}

EncodedJSValue JSC_HOST_CALL jsOESVertexArrayObjectPrototypeFunctionIsVertexArrayOES(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOESVertexArrayObject>::call<jsOESVertexArrayObjectPrototypeFunctionIsVertexArrayOESBody>(*lexicalGlobalObject, *callFrame, "isVertexArrayOES");
}

static inline JSC::EncodedJSValue jsOESVertexArrayObjectPrototypeFunctionBindVertexArrayOESBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOESVertexArrayObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto arrayObject = convert<IDLNullable<IDLInterface<WebGLVertexArrayObjectOES>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "arrayObject", "OESVertexArrayObject", "bindVertexArrayOES", "WebGLVertexArrayObjectOES"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.bindVertexArrayOES(WTFMove(arrayObject));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOESVertexArrayObjectPrototypeFunctionBindVertexArrayOES(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOESVertexArrayObject>::call<jsOESVertexArrayObjectPrototypeFunctionBindVertexArrayOESBody>(*lexicalGlobalObject, *callFrame, "bindVertexArrayOES");
}

void JSOESVertexArrayObject::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESVertexArrayObject*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESVertexArrayObjectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsOESVertexArrayObject = jsCast<JSOESVertexArrayObject*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsOESVertexArrayObject->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from OESVertexArrayObject";
    return visitor.containsOpaqueRoot(root);
}

void JSOESVertexArrayObjectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESVertexArrayObject = static_cast<JSOESVertexArrayObject*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOESVertexArrayObject->wrapped(), jsOESVertexArrayObject);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESVertexArrayObject@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20OESVertexArrayObjectE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESVertexArrayObject>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7OESVertexArrayObject@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore20OESVertexArrayObjectE[2];
#endif

    // If this fails OESVertexArrayObject does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<OESVertexArrayObject>::value, "OESVertexArrayObject is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // OESVertexArrayObject has subclasses. If OESVertexArrayObject has subclasses that get passed
    // to toJS() we currently require OESVertexArrayObject you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<OESVertexArrayObject>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESVertexArrayObject& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESVertexArrayObject* JSOESVertexArrayObject::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESVertexArrayObject*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
