/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSOscillatorNode.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSAudioParam.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSPeriodicWave.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(OscillatorNode::Type enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("sine"),
        MAKE_STATIC_STRING_IMPL("square"),
        MAKE_STATIC_STRING_IMPL("sawtooth"),
        MAKE_STATIC_STRING_IMPL("triangle"),
        MAKE_STATIC_STRING_IMPL("custom"),
    };
    static_assert(static_cast<size_t>(OscillatorNode::Type::Sine) == 0, "OscillatorNode::Type::Sine is not 0 as expected");
    static_assert(static_cast<size_t>(OscillatorNode::Type::Square) == 1, "OscillatorNode::Type::Square is not 1 as expected");
    static_assert(static_cast<size_t>(OscillatorNode::Type::Sawtooth) == 2, "OscillatorNode::Type::Sawtooth is not 2 as expected");
    static_assert(static_cast<size_t>(OscillatorNode::Type::Triangle) == 3, "OscillatorNode::Type::Triangle is not 3 as expected");
    static_assert(static_cast<size_t>(OscillatorNode::Type::Custom) == 4, "OscillatorNode::Type::Custom is not 4 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, OscillatorNode::Type enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<OscillatorNode::Type> parseEnumeration<OscillatorNode::Type>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "sine")
        return OscillatorNode::Type::Sine;
    if (stringValue == "square")
        return OscillatorNode::Type::Square;
    if (stringValue == "sawtooth")
        return OscillatorNode::Type::Sawtooth;
    if (stringValue == "triangle")
        return OscillatorNode::Type::Triangle;
    if (stringValue == "custom")
        return OscillatorNode::Type::Custom;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<OscillatorNode::Type>()
{
    return "\"sine\", \"square\", \"sawtooth\", \"triangle\", \"custom\"";
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionStart(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionStop(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionSetPeriodicWave(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsOscillatorNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOscillatorNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOscillatorNodeType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOscillatorNodeType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOscillatorNodePlaybackState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsOscillatorNodeFrequency(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsOscillatorNodeDetune(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsOscillatorNodeOnended(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOscillatorNodeOnended(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSOscillatorNodePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOscillatorNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOscillatorNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSOscillatorNodePrototype>(vm.heap)) JSOscillatorNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOscillatorNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOscillatorNodePrototype, JSOscillatorNodePrototype::Base);

using JSOscillatorNodeConstructor = JSDOMConstructorNotConstructable<JSOscillatorNode>;

/* Hash table for constructor */

static const HashTableValue JSOscillatorNodeConstructorTableValues[] =
{
    { "UNSCHEDULED_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SCHEDULED_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "PLAYING_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "FINISHED_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

static_assert(OscillatorNode::UNSCHEDULED_STATE == 0, "UNSCHEDULED_STATE in OscillatorNode does not match value from IDL");
static_assert(OscillatorNode::SCHEDULED_STATE == 1, "SCHEDULED_STATE in OscillatorNode does not match value from IDL");
static_assert(OscillatorNode::PLAYING_STATE == 2, "PLAYING_STATE in OscillatorNode does not match value from IDL");
static_assert(OscillatorNode::FINISHED_STATE == 3, "FINISHED_STATE in OscillatorNode does not match value from IDL");

template<> JSValue JSOscillatorNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSOscillatorNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSOscillatorNode::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("OscillatorNode"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSOscillatorNode::info(), JSOscillatorNodeConstructorTableValues, *this);
}

template<> const ClassInfo JSOscillatorNodeConstructor::s_info = { "OscillatorNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOscillatorNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSOscillatorNodePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOscillatorNodeConstructor) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOscillatorNodeType) } },
    { "playbackState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodePlaybackState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "frequency", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeFrequency), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "detune", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeDetune), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onended", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOscillatorNodeOnended), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOscillatorNodeOnended) } },
    { "start", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOscillatorNodePrototypeFunctionStart), (intptr_t) (0) } },
    { "stop", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOscillatorNodePrototypeFunctionStop), (intptr_t) (0) } },
    { "setPeriodicWave", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsOscillatorNodePrototypeFunctionSetPeriodicWave), (intptr_t) (1) } },
    { "UNSCHEDULED_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SCHEDULED_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "PLAYING_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "FINISHED_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

const ClassInfo JSOscillatorNodePrototype::s_info = { "OscillatorNodePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOscillatorNodePrototype) };

void JSOscillatorNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOscillatorNode::info(), JSOscillatorNodePrototypeTableValues, *this);
}

const ClassInfo JSOscillatorNode::s_info = { "OscillatorNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOscillatorNode) };

JSOscillatorNode::JSOscillatorNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OscillatorNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

void JSOscillatorNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, OscillatorNode>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSOscillatorNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSOscillatorNodePrototype::create(vm, &globalObject, JSOscillatorNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject)));
}

JSObject* JSOscillatorNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOscillatorNode>(vm, globalObject);
}

JSValue JSOscillatorNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOscillatorNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSOscillatorNode* IDLAttribute<JSOscillatorNode>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSOscillatorNode*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSOscillatorNode* IDLOperation<JSOscillatorNode>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSOscillatorNode*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsOscillatorNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSOscillatorNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSOscillatorNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSOscillatorNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSOscillatorNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsOscillatorNodeTypeGetter(JSGlobalObject& lexicalGlobalObject, JSOscillatorNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<OscillatorNode::Type>>(lexicalGlobalObject, throwScope, impl.type());
    return result;
}

EncodedJSValue jsOscillatorNodeType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOscillatorNode>::get<jsOscillatorNodeTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline bool setJSOscillatorNodeTypeSetter(JSGlobalObject& lexicalGlobalObject, JSOscillatorNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<OscillatorNode::Type>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setType(WTFMove(nativeValue));
    });
    return true;
}

bool setJSOscillatorNodeType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOscillatorNode>::set<setJSOscillatorNodeTypeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "type");
}

static inline JSValue jsOscillatorNodePlaybackStateGetter(JSGlobalObject& lexicalGlobalObject, JSOscillatorNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.playbackState());
    return result;
}

EncodedJSValue jsOscillatorNodePlaybackState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOscillatorNode>::get<jsOscillatorNodePlaybackStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "playbackState");
}

static inline JSValue jsOscillatorNodeFrequencyGetter(JSGlobalObject& lexicalGlobalObject, JSOscillatorNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.frequency());
    return result;
}

EncodedJSValue jsOscillatorNodeFrequency(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOscillatorNode>::get<jsOscillatorNodeFrequencyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "frequency");
}

static inline JSValue jsOscillatorNodeDetuneGetter(JSGlobalObject& lexicalGlobalObject, JSOscillatorNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.detune());
    return result;
}

EncodedJSValue jsOscillatorNodeDetune(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOscillatorNode>::get<jsOscillatorNodeDetuneGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "detune");
}

static inline JSValue jsOscillatorNodeOnendedGetter(JSGlobalObject& lexicalGlobalObject, JSOscillatorNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().endedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsOscillatorNodeOnended(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOscillatorNode>::get<jsOscillatorNodeOnendedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onended");
}

static inline bool setJSOscillatorNodeOnendedSetter(JSGlobalObject& lexicalGlobalObject, JSOscillatorNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().endedEvent, value);
    return true;
}

bool setJSOscillatorNodeOnended(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSOscillatorNode>::set<setJSOscillatorNodeOnendedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onended");
}

static inline JSC::EncodedJSValue jsOscillatorNodePrototypeFunctionStartBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOscillatorNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto when = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.startLater(WTFMove(when)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionStart(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOscillatorNode>::call<jsOscillatorNodePrototypeFunctionStartBody>(*lexicalGlobalObject, *callFrame, "start");
}

static inline JSC::EncodedJSValue jsOscillatorNodePrototypeFunctionStopBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOscillatorNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto when = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.stopLater(WTFMove(when)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionStop(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOscillatorNode>::call<jsOscillatorNodePrototypeFunctionStopBody>(*lexicalGlobalObject, *callFrame, "stop");
}

static inline JSC::EncodedJSValue jsOscillatorNodePrototypeFunctionSetPeriodicWaveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOscillatorNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto wave = convert<IDLNullable<IDLInterface<PeriodicWave>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "wave", "OscillatorNode", "setPeriodicWave", "PeriodicWave"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setPeriodicWave(WTFMove(wave));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsOscillatorNodePrototypeFunctionSetPeriodicWave(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSOscillatorNode>::call<jsOscillatorNodePrototypeFunctionSetPeriodicWaveBody>(*lexicalGlobalObject, *callFrame, "setPeriodicWave");
}

void JSOscillatorNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOscillatorNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSOscillatorNodeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsOscillatorNode = jsCast<JSOscillatorNode*>(handle.slot()->asCell());
    if (jsOscillatorNode->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsOscillatorNode->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSOscillatorNodeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOscillatorNode = static_cast<JSOscillatorNode*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOscillatorNode->wrapped(), jsOscillatorNode);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OscillatorNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14OscillatorNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OscillatorNode>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7OscillatorNode@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14OscillatorNodeE[2];
#endif

    // If this fails OscillatorNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<OscillatorNode>::value, "OscillatorNode is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // OscillatorNode has subclasses. If OscillatorNode has subclasses that get passed
    // to toJS() we currently require OscillatorNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<OscillatorNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OscillatorNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
