/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSOverconstrainedError.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsOverconstrainedErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSOverconstrainedErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsOverconstrainedErrorMessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsOverconstrainedErrorConstraint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsOverconstrainedErrorName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSOverconstrainedErrorPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOverconstrainedErrorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOverconstrainedErrorPrototype* ptr = new (NotNull, JSC::allocateCell<JSOverconstrainedErrorPrototype>(vm.heap)) JSOverconstrainedErrorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOverconstrainedErrorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOverconstrainedErrorPrototype, JSOverconstrainedErrorPrototype::Base);

using JSOverconstrainedErrorConstructor = JSDOMConstructor<JSOverconstrainedError>;

template<> EncodedJSValue JSC_HOST_CALL JSOverconstrainedErrorConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSOverconstrainedErrorConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto constraint = callFrame->argument(0).isUndefined() ? emptyString() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto message = callFrame->argument(1).isUndefined() ? emptyString() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = OverconstrainedError::create(WTFMove(constraint), WTFMove(message));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<OverconstrainedError>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSOverconstrainedErrorConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSOverconstrainedErrorConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSOverconstrainedError::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("OverconstrainedError"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSOverconstrainedErrorConstructor::s_info = { "OverconstrainedError", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOverconstrainedErrorConstructor) };

/* Hash table for prototype */

static const HashTableValue JSOverconstrainedErrorPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverconstrainedErrorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOverconstrainedErrorConstructor) } },
    { "message", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverconstrainedErrorMessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "constraint", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverconstrainedErrorConstraint), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "name", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverconstrainedErrorName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSOverconstrainedErrorPrototype::s_info = { "OverconstrainedErrorPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOverconstrainedErrorPrototype) };

void JSOverconstrainedErrorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOverconstrainedError::info(), JSOverconstrainedErrorPrototypeTableValues, *this);
}

const ClassInfo JSOverconstrainedError::s_info = { "OverconstrainedError", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOverconstrainedError) };

JSOverconstrainedError::JSOverconstrainedError(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OverconstrainedError>&& impl)
    : JSDOMWrapper<OverconstrainedError>(structure, globalObject, WTFMove(impl))
{
}

void JSOverconstrainedError::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, OverconstrainedError>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSOverconstrainedError::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSOverconstrainedErrorPrototype::create(vm, &globalObject, JSOverconstrainedErrorPrototype::createStructure(vm, &globalObject, globalObject.errorPrototype()));
}

JSObject* JSOverconstrainedError::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOverconstrainedError>(vm, globalObject);
}

JSValue JSOverconstrainedError::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOverconstrainedErrorConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSOverconstrainedError::destroy(JSC::JSCell* cell)
{
    JSOverconstrainedError* thisObject = static_cast<JSOverconstrainedError*>(cell);
    thisObject->JSOverconstrainedError::~JSOverconstrainedError();
}

template<> inline JSOverconstrainedError* IDLAttribute<JSOverconstrainedError>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSOverconstrainedError*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsOverconstrainedErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSOverconstrainedErrorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSOverconstrainedError::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSOverconstrainedErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSOverconstrainedErrorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsOverconstrainedErrorMessageGetter(JSGlobalObject& lexicalGlobalObject, JSOverconstrainedError& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.message());
    return result;
}

EncodedJSValue jsOverconstrainedErrorMessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOverconstrainedError>::get<jsOverconstrainedErrorMessageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "message");
}

static inline JSValue jsOverconstrainedErrorConstraintGetter(JSGlobalObject& lexicalGlobalObject, JSOverconstrainedError& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.constraint());
    return result;
}

EncodedJSValue jsOverconstrainedErrorConstraint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOverconstrainedError>::get<jsOverconstrainedErrorConstraintGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "constraint");
}

static inline JSValue jsOverconstrainedErrorNameGetter(JSGlobalObject& lexicalGlobalObject, JSOverconstrainedError& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name());
    return result;
}

EncodedJSValue jsOverconstrainedErrorName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSOverconstrainedError>::get<jsOverconstrainedErrorNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "name");
}

void JSOverconstrainedError::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOverconstrainedError*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSOverconstrainedErrorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSOverconstrainedErrorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOverconstrainedError = static_cast<JSOverconstrainedError*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsOverconstrainedError->wrapped(), jsOverconstrainedError);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OverconstrainedError>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to OverconstrainedError.
    static_assert(!std::is_polymorphic<OverconstrainedError>::value, "OverconstrainedError is polymorphic but the IDL claims it is not");
    return createWrapper<OverconstrainedError>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OverconstrainedError& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OverconstrainedError* JSOverconstrainedError::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOverconstrainedError*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_STREAM)
