/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(CSS_PAINTING_API)

#include "JSPaintWorkletGlobalScope.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(CSS_PAINTING_API)
#include "JSCSSPaintSize.h"
#include "JSPaintWorkletGlobalScope.h"
#endif

#if ENABLE(CSS_TYPED_OM)
#include "JSStylePropertyMapReadOnly.h"
#include "JSTypedOMCSSImageValue.h"
#include "JSTypedOMCSSNumericValue.h"
#include "JSTypedOMCSSStyleValue.h"
#include "JSTypedOMCSSUnitValue.h"
#include "JSTypedOMCSSUnparsedValue.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsPaintWorkletGlobalScopeInstanceFunctionRegisterPaint(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsPaintWorkletGlobalScopeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintWorkletGlobalScopeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaintWorkletGlobalScopeDevicePixelRatio(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(CSS_PAINTING_API)
JSC::EncodedJSValue jsPaintWorkletGlobalScopeCSSPaintSizeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintWorkletGlobalScopeCSSPaintSizeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_TYPED_OM)
JSC::EncodedJSValue jsPaintWorkletGlobalScopeStylePropertyMapReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintWorkletGlobalScopeStylePropertyMapReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_TYPED_OM)
JSC::EncodedJSValue jsPaintWorkletGlobalScopeCSSImageValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintWorkletGlobalScopeCSSImageValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_TYPED_OM)
JSC::EncodedJSValue jsPaintWorkletGlobalScopeCSSNumericValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintWorkletGlobalScopeCSSNumericValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_TYPED_OM)
JSC::EncodedJSValue jsPaintWorkletGlobalScopeCSSStyleValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintWorkletGlobalScopeCSSStyleValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_TYPED_OM)
JSC::EncodedJSValue jsPaintWorkletGlobalScopeCSSUnitValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintWorkletGlobalScopeCSSUnitValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_TYPED_OM)
JSC::EncodedJSValue jsPaintWorkletGlobalScopeCSSUnparsedValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintWorkletGlobalScopeCSSUnparsedValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_PAINTING_API)
JSC::EncodedJSValue jsPaintWorkletGlobalScopePaintWorkletGlobalScopeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaintWorkletGlobalScopePaintWorkletGlobalScopeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif

using JSPaintWorkletGlobalScopeConstructor = JSDOMConstructorNotConstructable<JSPaintWorkletGlobalScope>;

/* Hash table */

static const struct CompactHashIndex JSPaintWorkletGlobalScopeTableIndex[4] = {
    { 0, -1 },
    { -1, -1 },
    { -1, -1 },
    { 1, -1 },
};


static const HashTableValue JSPaintWorkletGlobalScopeTableValues[] =
{
    { "devicePixelRatio", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintWorkletGlobalScopeDevicePixelRatio), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "registerPaint", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaintWorkletGlobalScopeInstanceFunctionRegisterPaint), (intptr_t) (2) } },
};

static const HashTable JSPaintWorkletGlobalScopeTable = { 2, 3, true, JSPaintWorkletGlobalScope::info(), JSPaintWorkletGlobalScopeTableValues, JSPaintWorkletGlobalScopeTableIndex };
template<> JSValue JSPaintWorkletGlobalScopeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSWorkletGlobalScope::getConstructor(vm, &globalObject);
}

template<> void JSPaintWorkletGlobalScopeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, globalObject.getPrototypeDirect(vm), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("PaintWorkletGlobalScope"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSPaintWorkletGlobalScopeConstructor::s_info = { "PaintWorkletGlobalScope", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaintWorkletGlobalScopeConstructor) };

/* Hash table for prototype */

static const struct CompactHashIndex JSPaintWorkletGlobalScopePrototypeTableIndex[2] = {
    { -1, -1 },
    { 0, -1 },
};


static const HashTableValue JSPaintWorkletGlobalScopePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaintWorkletGlobalScopeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaintWorkletGlobalScopeConstructor) } },
};

static const HashTable JSPaintWorkletGlobalScopePrototypeTable = { 1, 1, true, JSPaintWorkletGlobalScope::info(), JSPaintWorkletGlobalScopePrototypeTableValues, JSPaintWorkletGlobalScopePrototypeTableIndex };
const ClassInfo JSPaintWorkletGlobalScopePrototype::s_info = { "PaintWorkletGlobalScopePrototype", &Base::s_info, &JSPaintWorkletGlobalScopePrototypeTable, nullptr, CREATE_METHOD_TABLE(JSPaintWorkletGlobalScopePrototype) };

const ClassInfo JSPaintWorkletGlobalScope::s_info = { "PaintWorkletGlobalScope", &Base::s_info, &JSPaintWorkletGlobalScopeTable, nullptr, CREATE_METHOD_TABLE(JSPaintWorkletGlobalScope) };

JSPaintWorkletGlobalScope::JSPaintWorkletGlobalScope(VM& vm, Structure* structure, Ref<PaintWorkletGlobalScope>&& impl)
    : JSWorkletGlobalScope(vm, structure, WTFMove(impl))
{
}

void JSPaintWorkletGlobalScope::finishCreation(VM& vm, JSProxy* proxy)
{
    Base::finishCreation(vm, proxy);

    static_assert(!std::is_base_of<ActiveDOMObject, PaintWorkletGlobalScope>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

#if ENABLE(CSS_PAINTING_API)
    if (RuntimeEnabledFeatures::sharedFeatures().cssPaintingAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CSSPaintSizePublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScopeCSSPaintSizeConstructor, setJSPaintWorkletGlobalScopeCSSPaintSizeConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(CSS_TYPED_OM)
    if (RuntimeEnabledFeatures::sharedFeatures().cssTypedOMEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().StylePropertyMapReadOnlyPublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScopeStylePropertyMapReadOnlyConstructor, setJSPaintWorkletGlobalScopeStylePropertyMapReadOnlyConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(CSS_TYPED_OM)
    if (RuntimeEnabledFeatures::sharedFeatures().cssTypedOMEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CSSImageValuePublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScopeCSSImageValueConstructor, setJSPaintWorkletGlobalScopeCSSImageValueConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(CSS_TYPED_OM)
    if (RuntimeEnabledFeatures::sharedFeatures().cssTypedOMEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CSSNumericValuePublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScopeCSSNumericValueConstructor, setJSPaintWorkletGlobalScopeCSSNumericValueConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(CSS_TYPED_OM)
    if (RuntimeEnabledFeatures::sharedFeatures().cssTypedOMEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CSSStyleValuePublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScopeCSSStyleValueConstructor, setJSPaintWorkletGlobalScopeCSSStyleValueConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(CSS_TYPED_OM)
    if (RuntimeEnabledFeatures::sharedFeatures().cssTypedOMEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CSSUnitValuePublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScopeCSSUnitValueConstructor, setJSPaintWorkletGlobalScopeCSSUnitValueConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(CSS_TYPED_OM)
    if (RuntimeEnabledFeatures::sharedFeatures().cssTypedOMEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CSSUnparsedValuePublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScopeCSSUnparsedValueConstructor, setJSPaintWorkletGlobalScopeCSSUnparsedValueConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(CSS_PAINTING_API)
    if (RuntimeEnabledFeatures::sharedFeatures().cssPaintingAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PaintWorkletGlobalScopePublicName(), CustomGetterSetter::create(vm, jsPaintWorkletGlobalScopePaintWorkletGlobalScopeConstructor, setJSPaintWorkletGlobalScopePaintWorkletGlobalScopeConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
}

JSValue JSPaintWorkletGlobalScope::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPaintWorkletGlobalScopeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSPaintWorkletGlobalScope* IDLAttribute<JSPaintWorkletGlobalScope>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto decodedThisValue = JSValue::decode(thisValue);
    if (decodedThisValue.isUndefinedOrNull())
        decodedThisValue = JSValue(&lexicalGlobalObject).toThis(&lexicalGlobalObject, NotStrictMode);
    return jsDynamicCast<JSPaintWorkletGlobalScope*>(vm, decodedThisValue);
}

template<> inline JSPaintWorkletGlobalScope* IDLOperation<JSPaintWorkletGlobalScope>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSPaintWorkletGlobalScope*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsPaintWorkletGlobalScopeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPaintWorkletGlobalScopePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPaintWorkletGlobalScope::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSPaintWorkletGlobalScopeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPaintWorkletGlobalScopePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsPaintWorkletGlobalScopeDevicePixelRatioGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.devicePixelRatio());
    return result;
}

EncodedJSValue jsPaintWorkletGlobalScopeDevicePixelRatio(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScopeDevicePixelRatioGetter>(*lexicalGlobalObject, thisValue, "devicePixelRatio");
}

#if ENABLE(CSS_PAINTING_API)
static inline JSValue jsPaintWorkletGlobalScopeCSSPaintSizeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSCSSPaintSize::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsPaintWorkletGlobalScopeCSSPaintSizeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScopeCSSPaintSizeConstructorGetter>(*lexicalGlobalObject, thisValue, "CSSPaintSize");
}

#endif

#if ENABLE(CSS_PAINTING_API)
static inline bool setJSPaintWorkletGlobalScopeCSSPaintSizeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("CSSPaintSize"), strlen("CSSPaintSize")), value);
}

bool setJSPaintWorkletGlobalScopeCSSPaintSizeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::set<setJSPaintWorkletGlobalScopeCSSPaintSizeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "CSSPaintSize");
}

#endif

#if ENABLE(CSS_TYPED_OM)
static inline JSValue jsPaintWorkletGlobalScopeStylePropertyMapReadOnlyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSStylePropertyMapReadOnly::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsPaintWorkletGlobalScopeStylePropertyMapReadOnlyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScopeStylePropertyMapReadOnlyConstructorGetter>(*lexicalGlobalObject, thisValue, "StylePropertyMapReadOnly");
}

#endif

#if ENABLE(CSS_TYPED_OM)
static inline bool setJSPaintWorkletGlobalScopeStylePropertyMapReadOnlyConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("StylePropertyMapReadOnly"), strlen("StylePropertyMapReadOnly")), value);
}

bool setJSPaintWorkletGlobalScopeStylePropertyMapReadOnlyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::set<setJSPaintWorkletGlobalScopeStylePropertyMapReadOnlyConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "StylePropertyMapReadOnly");
}

#endif

#if ENABLE(CSS_TYPED_OM)
static inline JSValue jsPaintWorkletGlobalScopeCSSImageValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTypedOMCSSImageValue::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsPaintWorkletGlobalScopeCSSImageValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScopeCSSImageValueConstructorGetter>(*lexicalGlobalObject, thisValue, "CSSImageValue");
}

#endif

#if ENABLE(CSS_TYPED_OM)
static inline bool setJSPaintWorkletGlobalScopeCSSImageValueConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("CSSImageValue"), strlen("CSSImageValue")), value);
}

bool setJSPaintWorkletGlobalScopeCSSImageValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::set<setJSPaintWorkletGlobalScopeCSSImageValueConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "CSSImageValue");
}

#endif

#if ENABLE(CSS_TYPED_OM)
static inline JSValue jsPaintWorkletGlobalScopeCSSNumericValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTypedOMCSSNumericValue::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsPaintWorkletGlobalScopeCSSNumericValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScopeCSSNumericValueConstructorGetter>(*lexicalGlobalObject, thisValue, "CSSNumericValue");
}

#endif

#if ENABLE(CSS_TYPED_OM)
static inline bool setJSPaintWorkletGlobalScopeCSSNumericValueConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("CSSNumericValue"), strlen("CSSNumericValue")), value);
}

bool setJSPaintWorkletGlobalScopeCSSNumericValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::set<setJSPaintWorkletGlobalScopeCSSNumericValueConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "CSSNumericValue");
}

#endif

#if ENABLE(CSS_TYPED_OM)
static inline JSValue jsPaintWorkletGlobalScopeCSSStyleValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTypedOMCSSStyleValue::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsPaintWorkletGlobalScopeCSSStyleValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScopeCSSStyleValueConstructorGetter>(*lexicalGlobalObject, thisValue, "CSSStyleValue");
}

#endif

#if ENABLE(CSS_TYPED_OM)
static inline bool setJSPaintWorkletGlobalScopeCSSStyleValueConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("CSSStyleValue"), strlen("CSSStyleValue")), value);
}

bool setJSPaintWorkletGlobalScopeCSSStyleValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::set<setJSPaintWorkletGlobalScopeCSSStyleValueConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "CSSStyleValue");
}

#endif

#if ENABLE(CSS_TYPED_OM)
static inline JSValue jsPaintWorkletGlobalScopeCSSUnitValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTypedOMCSSUnitValue::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsPaintWorkletGlobalScopeCSSUnitValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScopeCSSUnitValueConstructorGetter>(*lexicalGlobalObject, thisValue, "CSSUnitValue");
}

#endif

#if ENABLE(CSS_TYPED_OM)
static inline bool setJSPaintWorkletGlobalScopeCSSUnitValueConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("CSSUnitValue"), strlen("CSSUnitValue")), value);
}

bool setJSPaintWorkletGlobalScopeCSSUnitValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::set<setJSPaintWorkletGlobalScopeCSSUnitValueConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "CSSUnitValue");
}

#endif

#if ENABLE(CSS_TYPED_OM)
static inline JSValue jsPaintWorkletGlobalScopeCSSUnparsedValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSTypedOMCSSUnparsedValue::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsPaintWorkletGlobalScopeCSSUnparsedValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScopeCSSUnparsedValueConstructorGetter>(*lexicalGlobalObject, thisValue, "CSSUnparsedValue");
}

#endif

#if ENABLE(CSS_TYPED_OM)
static inline bool setJSPaintWorkletGlobalScopeCSSUnparsedValueConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("CSSUnparsedValue"), strlen("CSSUnparsedValue")), value);
}

bool setJSPaintWorkletGlobalScopeCSSUnparsedValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::set<setJSPaintWorkletGlobalScopeCSSUnparsedValueConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "CSSUnparsedValue");
}

#endif

#if ENABLE(CSS_PAINTING_API)
static inline JSValue jsPaintWorkletGlobalScopePaintWorkletGlobalScopeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return JSPaintWorkletGlobalScope::getConstructor(JSC::getVM(&lexicalGlobalObject), thisObject.globalObject());
}

EncodedJSValue jsPaintWorkletGlobalScopePaintWorkletGlobalScopeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::get<jsPaintWorkletGlobalScopePaintWorkletGlobalScopeConstructorGetter>(*lexicalGlobalObject, thisValue, "PaintWorkletGlobalScope");
}

#endif

#if ENABLE(CSS_PAINTING_API)
static inline bool setJSPaintWorkletGlobalScopePaintWorkletGlobalScopeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSPaintWorkletGlobalScope& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("PaintWorkletGlobalScope"), strlen("PaintWorkletGlobalScope")), value);
}

bool setJSPaintWorkletGlobalScopePaintWorkletGlobalScopeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPaintWorkletGlobalScope>::set<setJSPaintWorkletGlobalScopePaintWorkletGlobalScopeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "PaintWorkletGlobalScope");
}

#endif

static inline JSC::EncodedJSValue jsPaintWorkletGlobalScopeInstanceFunctionRegisterPaintBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaintWorkletGlobalScope>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto paintConstructor = convert<IDLObject>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.registerPaint(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(name), WTFMove(paintConstructor)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaintWorkletGlobalScopeInstanceFunctionRegisterPaint(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaintWorkletGlobalScope>::call<jsPaintWorkletGlobalScopeInstanceFunctionRegisterPaintBody>(*lexicalGlobalObject, *callFrame, "registerPaint");
}

JSC::IsoSubspace* JSPaintWorkletGlobalScope::subspaceForImpl(JSC::VM& vm)
{
    return &static_cast<JSVMClientData*>(vm.clientData)->subspaceForJSPaintWorkletGlobalScope();
}

void JSPaintWorkletGlobalScope::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSPaintWorkletGlobalScope*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSPaintWorkletGlobalScope::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSPaintWorkletGlobalScope*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSPaintWorkletGlobalScope::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPaintWorkletGlobalScope*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

PaintWorkletGlobalScope* JSPaintWorkletGlobalScope::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPaintWorkletGlobalScope*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(CSS_PAINTING_API)
