/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSPannerNode.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

String convertEnumerationToString(PanningModelType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("equalpower"),
        MAKE_STATIC_STRING_IMPL("HRTF"),
    };
    static_assert(static_cast<size_t>(PanningModelType::Equalpower) == 0, "PanningModelType::Equalpower is not 0 as expected");
    static_assert(static_cast<size_t>(PanningModelType::HRTF) == 1, "PanningModelType::HRTF is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, PanningModelType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<PanningModelType> parseEnumeration<PanningModelType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "equalpower")
        return PanningModelType::Equalpower;
    if (stringValue == "HRTF")
        return PanningModelType::HRTF;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<PanningModelType>()
{
    return "\"equalpower\", \"HRTF\"";
}

#endif

#if ENABLE(WEB_AUDIO)

String convertEnumerationToString(DistanceModelType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("linear"),
        MAKE_STATIC_STRING_IMPL("inverse"),
        MAKE_STATIC_STRING_IMPL("exponential"),
    };
    static_assert(static_cast<size_t>(DistanceModelType::Linear) == 0, "DistanceModelType::Linear is not 0 as expected");
    static_assert(static_cast<size_t>(DistanceModelType::Inverse) == 1, "DistanceModelType::Inverse is not 1 as expected");
    static_assert(static_cast<size_t>(DistanceModelType::Exponential) == 2, "DistanceModelType::Exponential is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, DistanceModelType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<DistanceModelType> parseEnumeration<DistanceModelType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "linear")
        return DistanceModelType::Linear;
    if (stringValue == "inverse")
        return DistanceModelType::Inverse;
    if (stringValue == "exponential")
        return DistanceModelType::Exponential;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<DistanceModelType>()
{
    return "\"linear\", \"inverse\", \"exponential\"";
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsPannerNodePrototypeFunctionSetPosition(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPannerNodePrototypeFunctionSetOrientation(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPannerNodePrototypeFunctionSetVelocity(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsPannerNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPannerNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodePanningModel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPannerNodePanningModel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodeDistanceModel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPannerNodeDistanceModel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodeRefDistance(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPannerNodeRefDistance(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodeMaxDistance(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPannerNodeMaxDistance(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodeRolloffFactor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPannerNodeRolloffFactor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodeConeInnerAngle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPannerNodeConeInnerAngle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodeConeOuterAngle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPannerNodeConeOuterAngle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPannerNodeConeOuterGain(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPannerNodeConeOuterGain(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSPannerNodePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPannerNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPannerNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSPannerNodePrototype>(vm.heap)) JSPannerNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPannerNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPannerNodePrototype, JSPannerNodePrototype::Base);

using JSPannerNodeConstructor = JSDOMConstructorNotConstructable<JSPannerNode>;

template<> JSValue JSPannerNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSPannerNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPannerNode::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("webkitAudioPannerNode"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSPannerNodeConstructor::s_info = { "webkitAudioPannerNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPannerNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPannerNodePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeConstructor) } },
    { "panningModel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodePanningModel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodePanningModel) } },
    { "distanceModel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeDistanceModel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeDistanceModel) } },
    { "refDistance", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeRefDistance), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeRefDistance) } },
    { "maxDistance", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeMaxDistance), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeMaxDistance) } },
    { "rolloffFactor", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeRolloffFactor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeRolloffFactor) } },
    { "coneInnerAngle", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeConeInnerAngle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeConeInnerAngle) } },
    { "coneOuterAngle", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeConeOuterAngle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeConeOuterAngle) } },
    { "coneOuterGain", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPannerNodeConeOuterGain), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPannerNodeConeOuterGain) } },
    { "setPosition", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPannerNodePrototypeFunctionSetPosition), (intptr_t) (3) } },
    { "setOrientation", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPannerNodePrototypeFunctionSetOrientation), (intptr_t) (3) } },
    { "setVelocity", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPannerNodePrototypeFunctionSetVelocity), (intptr_t) (3) } },
};

const ClassInfo JSPannerNodePrototype::s_info = { "webkitAudioPannerNodePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPannerNodePrototype) };

void JSPannerNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPannerNode::info(), JSPannerNodePrototypeTableValues, *this);
}

const ClassInfo JSPannerNode::s_info = { "webkitAudioPannerNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPannerNode) };

JSPannerNode::JSPannerNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PannerNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

void JSPannerNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, PannerNode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSPannerNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSPannerNodePrototype::create(vm, &globalObject, JSPannerNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject)));
}

JSObject* JSPannerNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPannerNode>(vm, globalObject);
}

JSValue JSPannerNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPannerNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSPannerNode* IDLAttribute<JSPannerNode>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSPannerNode*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSPannerNode* IDLOperation<JSPannerNode>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSPannerNode*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsPannerNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPannerNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPannerNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSPannerNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPannerNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsPannerNodePanningModelGetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<PanningModelType>>(lexicalGlobalObject, throwScope, impl.panningModel());
    return result;
}

EncodedJSValue jsPannerNodePanningModel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPannerNode>::get<jsPannerNodePanningModelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "panningModel");
}

static inline bool setJSPannerNodePanningModelSetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<PanningModelType>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setPanningModel(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPannerNodePanningModel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPannerNode>::set<setJSPannerNodePanningModelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "panningModel");
}

static inline JSValue jsPannerNodeDistanceModelGetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<DistanceModelType>>(lexicalGlobalObject, throwScope, impl.distanceModel());
    return result;
}

EncodedJSValue jsPannerNodeDistanceModel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPannerNode>::get<jsPannerNodeDistanceModelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "distanceModel");
}

static inline bool setJSPannerNodeDistanceModelSetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<DistanceModelType>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDistanceModel(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPannerNodeDistanceModel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPannerNode>::set<setJSPannerNodeDistanceModelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "distanceModel");
}

static inline JSValue jsPannerNodeRefDistanceGetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.refDistance());
    return result;
}

EncodedJSValue jsPannerNodeRefDistance(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPannerNode>::get<jsPannerNodeRefDistanceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "refDistance");
}

static inline bool setJSPannerNodeRefDistanceSetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setRefDistance(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPannerNodeRefDistance(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPannerNode>::set<setJSPannerNodeRefDistanceSetter>(*lexicalGlobalObject, thisValue, encodedValue, "refDistance");
}

static inline JSValue jsPannerNodeMaxDistanceGetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.maxDistance());
    return result;
}

EncodedJSValue jsPannerNodeMaxDistance(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPannerNode>::get<jsPannerNodeMaxDistanceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "maxDistance");
}

static inline bool setJSPannerNodeMaxDistanceSetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setMaxDistance(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPannerNodeMaxDistance(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPannerNode>::set<setJSPannerNodeMaxDistanceSetter>(*lexicalGlobalObject, thisValue, encodedValue, "maxDistance");
}

static inline JSValue jsPannerNodeRolloffFactorGetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.rolloffFactor());
    return result;
}

EncodedJSValue jsPannerNodeRolloffFactor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPannerNode>::get<jsPannerNodeRolloffFactorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rolloffFactor");
}

static inline bool setJSPannerNodeRolloffFactorSetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setRolloffFactor(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPannerNodeRolloffFactor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPannerNode>::set<setJSPannerNodeRolloffFactorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "rolloffFactor");
}

static inline JSValue jsPannerNodeConeInnerAngleGetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.coneInnerAngle());
    return result;
}

EncodedJSValue jsPannerNodeConeInnerAngle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPannerNode>::get<jsPannerNodeConeInnerAngleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "coneInnerAngle");
}

static inline bool setJSPannerNodeConeInnerAngleSetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setConeInnerAngle(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPannerNodeConeInnerAngle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPannerNode>::set<setJSPannerNodeConeInnerAngleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "coneInnerAngle");
}

static inline JSValue jsPannerNodeConeOuterAngleGetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.coneOuterAngle());
    return result;
}

EncodedJSValue jsPannerNodeConeOuterAngle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPannerNode>::get<jsPannerNodeConeOuterAngleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "coneOuterAngle");
}

static inline bool setJSPannerNodeConeOuterAngleSetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setConeOuterAngle(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPannerNodeConeOuterAngle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPannerNode>::set<setJSPannerNodeConeOuterAngleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "coneOuterAngle");
}

static inline JSValue jsPannerNodeConeOuterGainGetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.coneOuterGain());
    return result;
}

EncodedJSValue jsPannerNodeConeOuterGain(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPannerNode>::get<jsPannerNodeConeOuterGainGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "coneOuterGain");
}

static inline bool setJSPannerNodeConeOuterGainSetter(JSGlobalObject& lexicalGlobalObject, JSPannerNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setConeOuterGain(WTFMove(nativeValue));
    });
    return true;
}

bool setJSPannerNodeConeOuterGain(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSPannerNode>::set<setJSPannerNodeConeOuterGainSetter>(*lexicalGlobalObject, thisValue, encodedValue, "coneOuterGain");
}

static inline JSC::EncodedJSValue jsPannerNodePrototypeFunctionSetPositionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPannerNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setPosition(WTFMove(x), WTFMove(y), WTFMove(z));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPannerNodePrototypeFunctionSetPosition(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPannerNode>::call<jsPannerNodePrototypeFunctionSetPositionBody>(*lexicalGlobalObject, *callFrame, "setPosition");
}

static inline JSC::EncodedJSValue jsPannerNodePrototypeFunctionSetOrientationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPannerNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setOrientation(WTFMove(x), WTFMove(y), WTFMove(z));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPannerNodePrototypeFunctionSetOrientation(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPannerNode>::call<jsPannerNodePrototypeFunctionSetOrientationBody>(*lexicalGlobalObject, *callFrame, "setOrientation");
}

static inline JSC::EncodedJSValue jsPannerNodePrototypeFunctionSetVelocityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPannerNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setVelocity(WTFMove(x), WTFMove(y), WTFMove(z));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPannerNodePrototypeFunctionSetVelocity(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPannerNode>::call<jsPannerNodePrototypeFunctionSetVelocityBody>(*lexicalGlobalObject, *callFrame, "setVelocity");
}

void JSPannerNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPannerNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PannerNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10PannerNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PannerNode>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7PannerNode@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10PannerNodeE[2];
#endif

    // If this fails PannerNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<PannerNode>::value, "PannerNode is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // PannerNode has subclasses. If PannerNode has subclasses that get passed
    // to toJS() we currently require PannerNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<PannerNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PannerNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
