/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(WEB_AUDIO)

#include "JSAudioNode.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "PannerNode.h"

namespace WebCore {

class JSPannerNode : public JSAudioNode {
public:
    using Base = JSAudioNode;
    using DOMWrapped = PannerNode;
    static JSPannerNode* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<PannerNode>&& impl)
    {
        JSPannerNode* ptr = new (NotNull, JSC::allocateCell<JSPannerNode>(globalObject->vm().heap)) JSPannerNode(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    PannerNode& wrapped() const
    {
        return static_cast<PannerNode&>(Base::wrapped());
    }
protected:
    JSPannerNode(JSC::Structure*, JSDOMGlobalObject&, Ref<PannerNode>&&);

    void finishCreation(JSC::VM&);
};

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, PannerNode&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PannerNode* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<PannerNode>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<PannerNode>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<PannerNode> {
    using WrapperClass = JSPannerNode;
    using ToWrappedReturnType = PannerNode*;
};
#if ENABLE(WEB_AUDIO)

String convertEnumerationToString(PanningModelType);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, PanningModelType);

template<> Optional<PanningModelType> parseEnumeration<PanningModelType>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<PanningModelType>();

#endif

#if ENABLE(WEB_AUDIO)

String convertEnumerationToString(DistanceModelType);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, DistanceModelType);

template<> Optional<DistanceModelType> parseEnumeration<DistanceModelType>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<DistanceModelType>();

#endif


} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
