/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(PAYMENT_REQUEST)

#include "JSPaymentAddress.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsPaymentAddressPrototypeFunctionToJSON(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsPaymentAddressConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaymentAddressConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPaymentAddressCountry(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentAddressAddressLine(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentAddressRegion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentAddressCity(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentAddressDependentLocality(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentAddressPostalCode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentAddressSortingCode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentAddressOrganization(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentAddressRecipient(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPaymentAddressPhone(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSPaymentAddressPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPaymentAddressPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPaymentAddressPrototype* ptr = new (NotNull, JSC::allocateCell<JSPaymentAddressPrototype>(vm.heap)) JSPaymentAddressPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPaymentAddressPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPaymentAddressPrototype, JSPaymentAddressPrototype::Base);

using JSPaymentAddressConstructor = JSDOMConstructorNotConstructable<JSPaymentAddress>;

template<> JSValue JSPaymentAddressConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPaymentAddressConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPaymentAddress::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("PaymentAddress"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSPaymentAddressConstructor::s_info = { "PaymentAddress", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaymentAddressConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPaymentAddressPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentAddressConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaymentAddressConstructor) } },
    { "country", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentAddressCountry), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "addressLine", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentAddressAddressLine), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "region", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentAddressRegion), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "city", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentAddressCity), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "dependentLocality", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentAddressDependentLocality), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "postalCode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentAddressPostalCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "sortingCode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentAddressSortingCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "organization", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentAddressOrganization), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "recipient", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentAddressRecipient), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "phone", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentAddressPhone), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "toJSON", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaymentAddressPrototypeFunctionToJSON), (intptr_t) (0) } },
};

const ClassInfo JSPaymentAddressPrototype::s_info = { "PaymentAddressPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaymentAddressPrototype) };

void JSPaymentAddressPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPaymentAddress::info(), JSPaymentAddressPrototypeTableValues, *this);
}

const ClassInfo JSPaymentAddress::s_info = { "PaymentAddress", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaymentAddress) };

JSPaymentAddress::JSPaymentAddress(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PaymentAddress>&& impl)
    : JSDOMWrapper<PaymentAddress>(structure, globalObject, WTFMove(impl))
{
}

void JSPaymentAddress::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, PaymentAddress>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSPaymentAddress::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSPaymentAddressPrototype::create(vm, &globalObject, JSPaymentAddressPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSPaymentAddress::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPaymentAddress>(vm, globalObject);
}

JSValue JSPaymentAddress::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPaymentAddressConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSPaymentAddress::destroy(JSC::JSCell* cell)
{
    JSPaymentAddress* thisObject = static_cast<JSPaymentAddress*>(cell);
    thisObject->JSPaymentAddress::~JSPaymentAddress();
}

template<> inline JSPaymentAddress* IDLAttribute<JSPaymentAddress>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSPaymentAddress*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSPaymentAddress* IDLOperation<JSPaymentAddress>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSPaymentAddress*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsPaymentAddressConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPaymentAddressPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPaymentAddress::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSPaymentAddressConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPaymentAddressPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsPaymentAddressCountryGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentAddress& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.country());
    return result;
}

EncodedJSValue jsPaymentAddressCountry(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentAddress>::get<jsPaymentAddressCountryGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "country");
}

static inline JSValue jsPaymentAddressAddressLineGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentAddress& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLFrozenArray<IDLDOMString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.addressLine());
    return result;
}

EncodedJSValue jsPaymentAddressAddressLine(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentAddress>::get<jsPaymentAddressAddressLineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "addressLine");
}

static inline JSValue jsPaymentAddressRegionGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentAddress& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.region());
    return result;
}

EncodedJSValue jsPaymentAddressRegion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentAddress>::get<jsPaymentAddressRegionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "region");
}

static inline JSValue jsPaymentAddressCityGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentAddress& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.city());
    return result;
}

EncodedJSValue jsPaymentAddressCity(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentAddress>::get<jsPaymentAddressCityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "city");
}

static inline JSValue jsPaymentAddressDependentLocalityGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentAddress& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.dependentLocality());
    return result;
}

EncodedJSValue jsPaymentAddressDependentLocality(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentAddress>::get<jsPaymentAddressDependentLocalityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "dependentLocality");
}

static inline JSValue jsPaymentAddressPostalCodeGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentAddress& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.postalCode());
    return result;
}

EncodedJSValue jsPaymentAddressPostalCode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentAddress>::get<jsPaymentAddressPostalCodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "postalCode");
}

static inline JSValue jsPaymentAddressSortingCodeGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentAddress& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.sortingCode());
    return result;
}

EncodedJSValue jsPaymentAddressSortingCode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentAddress>::get<jsPaymentAddressSortingCodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "sortingCode");
}

static inline JSValue jsPaymentAddressOrganizationGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentAddress& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.organization());
    return result;
}

EncodedJSValue jsPaymentAddressOrganization(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentAddress>::get<jsPaymentAddressOrganizationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "organization");
}

static inline JSValue jsPaymentAddressRecipientGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentAddress& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.recipient());
    return result;
}

EncodedJSValue jsPaymentAddressRecipient(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentAddress>::get<jsPaymentAddressRecipientGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "recipient");
}

static inline JSValue jsPaymentAddressPhoneGetter(JSGlobalObject& lexicalGlobalObject, JSPaymentAddress& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.phone());
    return result;
}

EncodedJSValue jsPaymentAddressPhone(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPaymentAddress>::get<jsPaymentAddressPhoneGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "phone");
}

JSC::JSObject* JSPaymentAddress::serialize(JSGlobalObject& lexicalGlobalObject, JSPaymentAddress& thisObject, JSDOMGlobalObject& globalObject, ThrowScope& throwScope)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto* result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto countryValue = jsPaymentAddressCountryGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "country"), countryValue);

    auto addressLineValue = jsPaymentAddressAddressLineGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "addressLine"), addressLineValue);

    auto regionValue = jsPaymentAddressRegionGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "region"), regionValue);

    auto cityValue = jsPaymentAddressCityGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "city"), cityValue);

    auto dependentLocalityValue = jsPaymentAddressDependentLocalityGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "dependentLocality"), dependentLocalityValue);

    auto postalCodeValue = jsPaymentAddressPostalCodeGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "postalCode"), postalCodeValue);

    auto sortingCodeValue = jsPaymentAddressSortingCodeGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "sortingCode"), sortingCodeValue);

    auto organizationValue = jsPaymentAddressOrganizationGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "organization"), organizationValue);

    auto recipientValue = jsPaymentAddressRecipientGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "recipient"), recipientValue);

    auto phoneValue = jsPaymentAddressPhoneGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "phone"), phoneValue);

    return result;
}

static inline EncodedJSValue jsPaymentAddressPrototypeFunctionToJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSPaymentAddress* thisObject, JSC::ThrowScope& throwScope)
{
    return JSValue::encode(JSPaymentAddress::serialize(*lexicalGlobalObject, *thisObject, *thisObject->globalObject(), throwScope));
}

EncodedJSValue JSC_HOST_CALL jsPaymentAddressPrototypeFunctionToJSON(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaymentAddress>::call<jsPaymentAddressPrototypeFunctionToJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

void JSPaymentAddress::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPaymentAddress*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSPaymentAddressOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSPaymentAddressOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPaymentAddress = static_cast<JSPaymentAddress*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPaymentAddress->wrapped(), jsPaymentAddress);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PaymentAddress>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to PaymentAddress.
    static_assert(!std::is_polymorphic<PaymentAddress>::value, "PaymentAddress is polymorphic but the IDL claims it is not");
    return createWrapper<PaymentAddress>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PaymentAddress& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PaymentAddress* JSPaymentAddress::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPaymentAddress*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(PAYMENT_REQUEST)
