/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(PAYMENT_REQUEST)

#include "JSPaymentCurrencyAmount.h"

#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(PAYMENT_REQUEST)

template<> PaymentCurrencyAmount convertDictionary<PaymentCurrencyAmount>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PaymentCurrencyAmount result;
    JSValue currencyValue;
    if (isNullOrUndefined)
        currencyValue = jsUndefined();
    else {
        currencyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "currency"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!currencyValue.isUndefined()) {
        result.currency = convert<IDLDOMString>(lexicalGlobalObject, currencyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "currency", "PaymentCurrencyAmount", "DOMString");
        return { };
    }
    JSValue valueValue;
    if (isNullOrUndefined)
        valueValue = jsUndefined();
    else {
        valueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "value"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!valueValue.isUndefined()) {
        result.value = convert<IDLDOMString>(lexicalGlobalObject, valueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "value", "PaymentCurrencyAmount", "DOMString");
        return { };
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(PAYMENT_REQUEST)
