/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(PAYMENT_REQUEST)

#include "JSPaymentDetailsInit.h"

#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSPaymentDetailsModifier.h"
#include "JSPaymentItem.h"
#include "JSPaymentShippingOption.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(PAYMENT_REQUEST)

template<> PaymentDetailsInit convertDictionary<PaymentDetailsInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PaymentDetailsInit result;
    JSValue displayItemsValue;
    if (isNullOrUndefined)
        displayItemsValue = jsUndefined();
    else {
        displayItemsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displayItems"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displayItemsValue.isUndefined()) {
        result.displayItems = convert<IDLSequence<IDLDictionary<PaymentItem>>>(lexicalGlobalObject, displayItemsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue modifiersValue;
    if (isNullOrUndefined)
        modifiersValue = jsUndefined();
    else {
        modifiersValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifiers"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modifiersValue.isUndefined()) {
        result.modifiers = convert<IDLSequence<IDLDictionary<PaymentDetailsModifier>>>(lexicalGlobalObject, modifiersValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue shippingOptionsValue;
    if (isNullOrUndefined)
        shippingOptionsValue = jsUndefined();
    else {
        shippingOptionsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "shippingOptions"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!shippingOptionsValue.isUndefined()) {
        result.shippingOptions = convert<IDLSequence<IDLDictionary<PaymentShippingOption>>>(lexicalGlobalObject, shippingOptionsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLDOMString>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue totalValue;
    if (isNullOrUndefined)
        totalValue = jsUndefined();
    else {
        totalValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "total"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!totalValue.isUndefined()) {
        result.total = convert<IDLDictionary<PaymentItem>>(lexicalGlobalObject, totalValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "total", "PaymentDetailsInit", "PaymentItem");
        return { };
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(PAYMENT_REQUEST)
