/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(PAYMENT_REQUEST)

#include "JSPaymentItem.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertStrings.h"
#include "JSPaymentCurrencyAmount.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(PAYMENT_REQUEST)

template<> PaymentItem convertDictionary<PaymentItem>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PaymentItem result;
    JSValue amountValue;
    if (isNullOrUndefined)
        amountValue = jsUndefined();
    else {
        amountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "amount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!amountValue.isUndefined()) {
        result.amount = convert<IDLDictionary<PaymentCurrencyAmount>>(lexicalGlobalObject, amountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "amount", "PaymentItem", "PaymentCurrencyAmount");
        return { };
    }
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!labelValue.isUndefined()) {
        result.label = convert<IDLDOMString>(lexicalGlobalObject, labelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "label", "PaymentItem", "DOMString");
        return { };
    }
    JSValue pendingValue;
    if (isNullOrUndefined)
        pendingValue = jsUndefined();
    else {
        pendingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pending"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pendingValue.isUndefined()) {
        result.pending = convert<IDLBoolean>(lexicalGlobalObject, pendingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.pending = false;
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(PAYMENT_REQUEST)
