/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(PAYMENT_REQUEST)

#include "JSDOMWrapper.h"
#include "JSEventTarget.h"
#include "PaymentRequest.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSPaymentRequest : public JSEventTarget {
public:
    using Base = JSEventTarget;
    using DOMWrapped = PaymentRequest;
    static JSPaymentRequest* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<PaymentRequest>&& impl)
    {
        JSPaymentRequest* ptr = new (NotNull, JSC::allocateCell<JSPaymentRequest>(globalObject->vm().heap)) JSPaymentRequest(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static PaymentRequest* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    PaymentRequest& wrapped() const
    {
        return static_cast<PaymentRequest&>(Base::wrapped());
    }
protected:
    JSPaymentRequest(JSC::Structure*, JSDOMGlobalObject&, Ref<PaymentRequest>&&);

    void finishCreation(JSC::VM&);
};

class JSPaymentRequestOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, PaymentRequest*)
{
    static NeverDestroyed<JSPaymentRequestOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(PaymentRequest* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, PaymentRequest&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PaymentRequest* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<PaymentRequest>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<PaymentRequest>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<PaymentRequest> {
    using WrapperClass = JSPaymentRequest;
    using ToWrappedReturnType = PaymentRequest*;
};

} // namespace WebCore

#endif // ENABLE(PAYMENT_REQUEST)
