/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(PAYMENT_REQUEST)

#include "JSPaymentRequestUpdateEvent.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSPaymentDetailsUpdate.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(PAYMENT_REQUEST)
#include "JSDOMConvertStrings.h"
#include "JSPaymentRequestUpdateEventInit.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsPaymentRequestUpdateEventPrototypeFunctionUpdateWith(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsPaymentRequestUpdateEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPaymentRequestUpdateEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSPaymentRequestUpdateEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPaymentRequestUpdateEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPaymentRequestUpdateEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSPaymentRequestUpdateEventPrototype>(vm.heap)) JSPaymentRequestUpdateEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPaymentRequestUpdateEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPaymentRequestUpdateEventPrototype, JSPaymentRequestUpdateEventPrototype::Base);

using JSPaymentRequestUpdateEventConstructor = JSDOMConstructor<JSPaymentRequestUpdateEvent>;

template<> EncodedJSValue JSC_HOST_CALL JSPaymentRequestUpdateEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSPaymentRequestUpdateEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<PaymentRequestUpdateEventInit>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = PaymentRequestUpdateEvent::create(WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<PaymentRequestUpdateEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSPaymentRequestUpdateEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSPaymentRequestUpdateEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPaymentRequestUpdateEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("PaymentRequestUpdateEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSPaymentRequestUpdateEventConstructor::s_info = { "PaymentRequestUpdateEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaymentRequestUpdateEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPaymentRequestUpdateEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPaymentRequestUpdateEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPaymentRequestUpdateEventConstructor) } },
    { "updateWith", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPaymentRequestUpdateEventPrototypeFunctionUpdateWith), (intptr_t) (1) } },
};

const ClassInfo JSPaymentRequestUpdateEventPrototype::s_info = { "PaymentRequestUpdateEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaymentRequestUpdateEventPrototype) };

void JSPaymentRequestUpdateEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPaymentRequestUpdateEvent::info(), JSPaymentRequestUpdateEventPrototypeTableValues, *this);
}

const ClassInfo JSPaymentRequestUpdateEvent::s_info = { "PaymentRequestUpdateEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPaymentRequestUpdateEvent) };

JSPaymentRequestUpdateEvent::JSPaymentRequestUpdateEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PaymentRequestUpdateEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

void JSPaymentRequestUpdateEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, PaymentRequestUpdateEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSPaymentRequestUpdateEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSPaymentRequestUpdateEventPrototype::create(vm, &globalObject, JSPaymentRequestUpdateEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject)));
}

JSObject* JSPaymentRequestUpdateEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPaymentRequestUpdateEvent>(vm, globalObject);
}

JSValue JSPaymentRequestUpdateEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPaymentRequestUpdateEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSPaymentRequestUpdateEvent* IDLOperation<JSPaymentRequestUpdateEvent>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSPaymentRequestUpdateEvent*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsPaymentRequestUpdateEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPaymentRequestUpdateEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPaymentRequestUpdateEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSPaymentRequestUpdateEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPaymentRequestUpdateEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsPaymentRequestUpdateEventPrototypeFunctionUpdateWithBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPaymentRequestUpdateEvent>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto detailsPromise = convert<IDLPromise<IDLDictionary<PaymentDetailsUpdate>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.updateWith(detailsPromise.releaseNonNull()));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPaymentRequestUpdateEventPrototypeFunctionUpdateWith(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPaymentRequestUpdateEvent>::call<jsPaymentRequestUpdateEventPrototypeFunctionUpdateWithBody>(*lexicalGlobalObject, *callFrame, "updateWith");
}

void JSPaymentRequestUpdateEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPaymentRequestUpdateEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PaymentRequestUpdateEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25PaymentRequestUpdateEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PaymentRequestUpdateEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7PaymentRequestUpdateEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore25PaymentRequestUpdateEventE[2];
#endif

    // If this fails PaymentRequestUpdateEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<PaymentRequestUpdateEvent>::value, "PaymentRequestUpdateEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // PaymentRequestUpdateEvent has subclasses. If PaymentRequestUpdateEvent has subclasses that get passed
    // to toJS() we currently require PaymentRequestUpdateEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<PaymentRequestUpdateEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PaymentRequestUpdateEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(PAYMENT_REQUEST)
