/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(PAYMENT_REQUEST)

#include "JSDOMWrapper.h"
#include "JSEventTarget.h"
#include "PaymentResponse.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSPaymentResponse : public JSEventTarget {
public:
    using Base = JSEventTarget;
    using DOMWrapped = PaymentResponse;
    static JSPaymentResponse* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<PaymentResponse>&& impl)
    {
        JSPaymentResponse* ptr = new (NotNull, JSC::allocateCell<JSPaymentResponse>(globalObject->vm().heap)) JSPaymentResponse(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static PaymentResponse* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static JSC::JSObject* serialize(JSC::JSGlobalObject&, JSPaymentResponse& thisObject, JSDOMGlobalObject&, JSC::ThrowScope&);
    static void visitChildren(JSCell*, JSC::SlotVisitor&);
    void visitAdditionalChildren(JSC::SlotVisitor&);

    static void visitOutputConstraints(JSCell*, JSC::SlotVisitor&);
    template<typename, JSC::SubspaceAccess> static JSC::CompleteSubspace* subspaceFor(JSC::VM& vm) { return outputConstraintSubspaceFor(vm); }
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);

    // Custom attributes
    JSC::JSValue details(JSC::JSGlobalObject&) const;
    PaymentResponse& wrapped() const
    {
        return static_cast<PaymentResponse&>(Base::wrapped());
    }
protected:
    JSPaymentResponse(JSC::Structure*, JSDOMGlobalObject&, Ref<PaymentResponse>&&);

    void finishCreation(JSC::VM&);
};

class JSPaymentResponseOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, PaymentResponse*)
{
    static NeverDestroyed<JSPaymentResponseOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(PaymentResponse* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, PaymentResponse&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PaymentResponse* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<PaymentResponse>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<PaymentResponse>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<PaymentResponse> {
    using WrapperClass = JSPaymentResponse;
    using ToWrappedReturnType = PaymentResponse*;
};

} // namespace WebCore

#endif // ENABLE(PAYMENT_REQUEST)
