/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(PAYMENT_REQUEST)

#include "JSPaymentValidationErrors.h"

#include "JSAddressErrors.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertStrings.h"
#include "JSPayerErrorFields.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(PAYMENT_REQUEST)

template<> PaymentValidationErrors convertDictionary<PaymentValidationErrors>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PaymentValidationErrors result;
    JSValue errorValue;
    if (isNullOrUndefined)
        errorValue = jsUndefined();
    else {
        errorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "error"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!errorValue.isUndefined()) {
        result.error = convert<IDLDOMString>(lexicalGlobalObject, errorValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue payerValue;
    if (isNullOrUndefined)
        payerValue = jsUndefined();
    else {
        payerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "payer"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!payerValue.isUndefined()) {
        result.payer = convert<IDLDictionary<PayerErrorFields>>(lexicalGlobalObject, payerValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue paymentMethodValue;
    if (isNullOrUndefined)
        paymentMethodValue = jsUndefined();
    else {
        paymentMethodValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "paymentMethod"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!paymentMethodValue.isUndefined()) {
        result.paymentMethod = convert<IDLObject>(lexicalGlobalObject, paymentMethodValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue shippingAddressValue;
    if (isNullOrUndefined)
        shippingAddressValue = jsUndefined();
    else {
        shippingAddressValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "shippingAddress"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!shippingAddressValue.isUndefined()) {
        result.shippingAddress = convert<IDLDictionary<AddressErrors>>(lexicalGlobalObject, shippingAddressValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(PAYMENT_REQUEST)
