/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPerformanceObserver.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSPerformanceObserverCallback.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> PerformanceObserver::Init convertDictionary<PerformanceObserver::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PerformanceObserver::Init result;
    JSValue entryTypesValue;
    if (isNullOrUndefined)
        entryTypesValue = jsUndefined();
    else {
        entryTypesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "entryTypes"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!entryTypesValue.isUndefined()) {
        result.entryTypes = convert<IDLSequence<IDLDOMString>>(lexicalGlobalObject, entryTypesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "entryTypes", "PerformanceObserverInit", "sequence");
        return { };
    }
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsPerformanceObserverPrototypeFunctionObserve(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPerformanceObserverPrototypeFunctionDisconnect(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsPerformanceObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPerformanceObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPerformanceObserverConstructorSupportedEntryTypes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSPerformanceObserverPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPerformanceObserverPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPerformanceObserverPrototype* ptr = new (NotNull, JSC::allocateCell<JSPerformanceObserverPrototype>(vm.heap)) JSPerformanceObserverPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPerformanceObserverPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPerformanceObserverPrototype, JSPerformanceObserverPrototype::Base);

using JSPerformanceObserverConstructor = JSDOMConstructor<JSPerformanceObserver>;

/* Hash table for constructor */

static const HashTableValue JSPerformanceObserverConstructorTableValues[] =
{
    { "supportedEntryTypes", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceObserverConstructorSupportedEntryTypes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

template<> EncodedJSValue JSC_HOST_CALL JSPerformanceObserverConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSPerformanceObserverConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "PerformanceObserver");
    auto callback = convert<IDLCallbackFunction<JSPerformanceObserverCallback>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback", "PerformanceObserver", nullptr); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = PerformanceObserver::create(*context, callback.releaseNonNull());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<PerformanceObserver>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSPerformanceObserverConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPerformanceObserverConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPerformanceObserver::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("PerformanceObserver"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSPerformanceObserver::info(), JSPerformanceObserverConstructorTableValues, *this);
}

template<> const ClassInfo JSPerformanceObserverConstructor::s_info = { "PerformanceObserver", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceObserverConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPerformanceObserverPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceObserverConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPerformanceObserverConstructor) } },
    { "observe", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPerformanceObserverPrototypeFunctionObserve), (intptr_t) (1) } },
    { "disconnect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPerformanceObserverPrototypeFunctionDisconnect), (intptr_t) (0) } },
};

const ClassInfo JSPerformanceObserverPrototype::s_info = { "PerformanceObserverPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceObserverPrototype) };

void JSPerformanceObserverPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPerformanceObserver::info(), JSPerformanceObserverPrototypeTableValues, *this);
}

const ClassInfo JSPerformanceObserver::s_info = { "PerformanceObserver", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceObserver) };

JSPerformanceObserver::JSPerformanceObserver(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PerformanceObserver>&& impl)
    : JSDOMWrapper<PerformanceObserver>(structure, globalObject, WTFMove(impl))
{
}

void JSPerformanceObserver::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, PerformanceObserver>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSPerformanceObserver::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSPerformanceObserverPrototype::create(vm, &globalObject, JSPerformanceObserverPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSPerformanceObserver::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPerformanceObserver>(vm, globalObject);
}

JSValue JSPerformanceObserver::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPerformanceObserverConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSPerformanceObserver::destroy(JSC::JSCell* cell)
{
    JSPerformanceObserver* thisObject = static_cast<JSPerformanceObserver*>(cell);
    thisObject->JSPerformanceObserver::~JSPerformanceObserver();
}

template<> inline JSPerformanceObserver* IDLAttribute<JSPerformanceObserver>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSPerformanceObserver*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSPerformanceObserver* IDLOperation<JSPerformanceObserver>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSPerformanceObserver*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsPerformanceObserverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPerformanceObserverPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPerformanceObserver::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSPerformanceObserverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPerformanceObserverPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsPerformanceObserverConstructorSupportedEntryTypesGetter(JSGlobalObject& lexicalGlobalObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    JSValue result = toJS<IDLFrozenArray<IDLDOMString>>(lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject), throwScope, PerformanceObserver::supportedEntryTypes());
    return result;
}

EncodedJSValue jsPerformanceObserverConstructorSupportedEntryTypes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPerformanceObserver>::getStatic<jsPerformanceObserverConstructorSupportedEntryTypesGetter>(*lexicalGlobalObject, thisValue, "supportedEntryTypes");
}

static inline JSC::EncodedJSValue jsPerformanceObserverPrototypeFunctionObserveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPerformanceObserver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto options = convert<IDLDictionary<PerformanceObserver::Init>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.observe(WTFMove(options)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPerformanceObserverPrototypeFunctionObserve(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPerformanceObserver>::call<jsPerformanceObserverPrototypeFunctionObserveBody>(*lexicalGlobalObject, *callFrame, "observe");
}

static inline JSC::EncodedJSValue jsPerformanceObserverPrototypeFunctionDisconnectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPerformanceObserver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.disconnect();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPerformanceObserverPrototypeFunctionDisconnect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPerformanceObserver>::call<jsPerformanceObserverPrototypeFunctionDisconnectBody>(*lexicalGlobalObject, *callFrame, "disconnect");
}

void JSPerformanceObserver::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSPerformanceObserver*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSPerformanceObserver::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSPerformanceObserver*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSPerformanceObserver::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPerformanceObserver*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

void JSPerformanceObserverOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPerformanceObserver = static_cast<JSPerformanceObserver*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPerformanceObserver->wrapped(), jsPerformanceObserver);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PerformanceObserver>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to PerformanceObserver.
    static_assert(!std::is_polymorphic<PerformanceObserver>::value, "PerformanceObserver is polymorphic but the IDL claims it is not");
    return createWrapper<PerformanceObserver>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PerformanceObserver& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PerformanceObserver* JSPerformanceObserver::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPerformanceObserver*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
