/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUTHN)

#include "JSPublicKeyCredential.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "JSAuthenticationExtensionsClientOutputs.h"
#include "JSAuthenticatorResponse.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsPublicKeyCredentialPrototypeFunctionGetClientExtensionResults(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsPublicKeyCredentialConstructorFunctionIsUserVerifyingPlatformAuthenticatorAvailable(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsPublicKeyCredentialConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSPublicKeyCredentialConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsPublicKeyCredentialRawId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsPublicKeyCredentialResponse(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSPublicKeyCredentialPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPublicKeyCredentialPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPublicKeyCredentialPrototype* ptr = new (NotNull, JSC::allocateCell<JSPublicKeyCredentialPrototype>(vm.heap)) JSPublicKeyCredentialPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPublicKeyCredentialPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPublicKeyCredentialPrototype, JSPublicKeyCredentialPrototype::Base);

using JSPublicKeyCredentialConstructor = JSDOMConstructorNotConstructable<JSPublicKeyCredential>;

/* Hash table for constructor */

static const HashTableValue JSPublicKeyCredentialConstructorTableValues[] =
{
    { "isUserVerifyingPlatformAuthenticatorAvailable", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPublicKeyCredentialConstructorFunctionIsUserVerifyingPlatformAuthenticatorAvailable), (intptr_t) (0) } },
};

template<> JSValue JSPublicKeyCredentialConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSBasicCredential::getConstructor(vm, &globalObject);
}

template<> void JSPublicKeyCredentialConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSPublicKeyCredential::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("PublicKeyCredential"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSPublicKeyCredential::info(), JSPublicKeyCredentialConstructorTableValues, *this);
}

template<> const ClassInfo JSPublicKeyCredentialConstructor::s_info = { "PublicKeyCredential", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPublicKeyCredentialConstructor) };

/* Hash table for prototype */

static const HashTableValue JSPublicKeyCredentialPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPublicKeyCredentialConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSPublicKeyCredentialConstructor) } },
    { "rawId", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPublicKeyCredentialRawId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "response", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPublicKeyCredentialResponse), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getClientExtensionResults", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsPublicKeyCredentialPrototypeFunctionGetClientExtensionResults), (intptr_t) (0) } },
};

const ClassInfo JSPublicKeyCredentialPrototype::s_info = { "PublicKeyCredentialPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPublicKeyCredentialPrototype) };

void JSPublicKeyCredentialPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPublicKeyCredential::info(), JSPublicKeyCredentialPrototypeTableValues, *this);
}

const ClassInfo JSPublicKeyCredential::s_info = { "PublicKeyCredential", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPublicKeyCredential) };

JSPublicKeyCredential::JSPublicKeyCredential(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PublicKeyCredential>&& impl)
    : JSBasicCredential(structure, globalObject, WTFMove(impl))
{
}

void JSPublicKeyCredential::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, PublicKeyCredential>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSPublicKeyCredential::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSPublicKeyCredentialPrototype::create(vm, &globalObject, JSPublicKeyCredentialPrototype::createStructure(vm, &globalObject, JSBasicCredential::prototype(vm, globalObject)));
}

JSObject* JSPublicKeyCredential::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPublicKeyCredential>(vm, globalObject);
}

JSValue JSPublicKeyCredential::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPublicKeyCredentialConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSPublicKeyCredential* IDLAttribute<JSPublicKeyCredential>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSPublicKeyCredential*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSPublicKeyCredential* IDLOperation<JSPublicKeyCredential>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSPublicKeyCredential*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsPublicKeyCredentialConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPublicKeyCredentialPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPublicKeyCredential::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSPublicKeyCredentialConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPublicKeyCredentialPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsPublicKeyCredentialRawIdGetter(JSGlobalObject& lexicalGlobalObject, JSPublicKeyCredential& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLArrayBuffer>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.rawId());
    return result;
}

EncodedJSValue jsPublicKeyCredentialRawId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPublicKeyCredential>::get<jsPublicKeyCredentialRawIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rawId");
}

static inline JSValue jsPublicKeyCredentialResponseGetter(JSGlobalObject& lexicalGlobalObject, JSPublicKeyCredential& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<AuthenticatorResponse>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.response());
    return result;
}

EncodedJSValue jsPublicKeyCredentialResponse(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSPublicKeyCredential>::get<jsPublicKeyCredentialResponseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "response");
}

static inline JSC::EncodedJSValue jsPublicKeyCredentialPrototypeFunctionGetClientExtensionResultsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPublicKeyCredential>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDictionary<AuthenticationExtensionsClientOutputs>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getClientExtensionResults()));
}

EncodedJSValue JSC_HOST_CALL jsPublicKeyCredentialPrototypeFunctionGetClientExtensionResults(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSPublicKeyCredential>::call<jsPublicKeyCredentialPrototypeFunctionGetClientExtensionResultsBody>(*lexicalGlobalObject, *callFrame, "getClientExtensionResults");
}

static inline JSC::EncodedJSValue jsPublicKeyCredentialConstructorFunctionIsUserVerifyingPlatformAuthenticatorAvailableBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    PublicKeyCredential::isUserVerifyingPlatformAuthenticatorAvailable(document, WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsPublicKeyCredentialConstructorFunctionIsUserVerifyingPlatformAuthenticatorAvailable(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSPublicKeyCredential>::callStatic<jsPublicKeyCredentialConstructorFunctionIsUserVerifyingPlatformAuthenticatorAvailableBody>(*lexicalGlobalObject, *callFrame, "isUserVerifyingPlatformAuthenticatorAvailable");
}

void JSPublicKeyCredential::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPublicKeyCredential*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}

#endif // ENABLE(WEB_AUTHN)
