/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUTHN)

#include "JSPublicKeyCredentialCreationOptions.h"

#include "JSAttestationConveyancePreference.h"
#include "JSAuthenticationExtensionsClientInputs.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSPublicKeyCredentialDescriptor.h"
#include "JSPublicKeyCredentialType.h"
#include "JSUserVerificationRequirement.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUTHN)

template<> PublicKeyCredentialCreationOptions convertDictionary<PublicKeyCredentialCreationOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PublicKeyCredentialCreationOptions result;
    JSValue attestationValue;
    if (isNullOrUndefined)
        attestationValue = jsUndefined();
    else {
        attestationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "attestation"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!attestationValue.isUndefined()) {
        result.attestation = convert<IDLEnumeration<AttestationConveyancePreference>>(lexicalGlobalObject, attestationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.attestation = AttestationConveyancePreference::None;
    JSValue authenticatorSelectionValue;
    if (isNullOrUndefined)
        authenticatorSelectionValue = jsUndefined();
    else {
        authenticatorSelectionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "authenticatorSelection"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!authenticatorSelectionValue.isUndefined()) {
        result.authenticatorSelection = convert<IDLDictionary<PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria>>(lexicalGlobalObject, authenticatorSelectionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue challengeValue;
    if (isNullOrUndefined)
        challengeValue = jsUndefined();
    else {
        challengeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "challenge"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!challengeValue.isUndefined()) {
        result.challenge = convert<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>(lexicalGlobalObject, challengeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "challenge", "PublicKeyCredentialCreationOptions", "(ArrayBufferView or ArrayBuffer)");
        return { };
    }
    JSValue excludeCredentialsValue;
    if (isNullOrUndefined)
        excludeCredentialsValue = jsUndefined();
    else {
        excludeCredentialsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "excludeCredentials"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!excludeCredentialsValue.isUndefined()) {
        result.excludeCredentials = convert<IDLSequence<IDLDictionary<PublicKeyCredentialDescriptor>>>(lexicalGlobalObject, excludeCredentialsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.excludeCredentials = Converter<IDLSequence<IDLDictionary<PublicKeyCredentialDescriptor>>>::ReturnType{ };
    JSValue extensionsValue;
    if (isNullOrUndefined)
        extensionsValue = jsUndefined();
    else {
        extensionsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "extensions"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!extensionsValue.isUndefined()) {
        result.extensions = convert<IDLDictionary<AuthenticationExtensionsClientInputs>>(lexicalGlobalObject, extensionsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue pubKeyCredParamsValue;
    if (isNullOrUndefined)
        pubKeyCredParamsValue = jsUndefined();
    else {
        pubKeyCredParamsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pubKeyCredParams"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pubKeyCredParamsValue.isUndefined()) {
        result.pubKeyCredParams = convert<IDLSequence<IDLDictionary<PublicKeyCredentialCreationOptions::Parameters>>>(lexicalGlobalObject, pubKeyCredParamsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "pubKeyCredParams", "PublicKeyCredentialCreationOptions", "sequence");
        return { };
    }
    JSValue rpValue;
    if (isNullOrUndefined)
        rpValue = jsUndefined();
    else {
        rpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rpValue.isUndefined()) {
        result.rp = convert<IDLDictionary<PublicKeyCredentialCreationOptions::RpEntity>>(lexicalGlobalObject, rpValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "rp", "PublicKeyCredentialCreationOptions", "PublicKeyCredentialRpEntity");
        return { };
    }
    JSValue timeoutValue;
    if (isNullOrUndefined)
        timeoutValue = jsUndefined();
    else {
        timeoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timeout"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timeoutValue.isUndefined()) {
        result.timeout = convert<IDLUnsignedLong>(lexicalGlobalObject, timeoutValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue userValue;
    if (isNullOrUndefined)
        userValue = jsUndefined();
    else {
        userValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "user"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!userValue.isUndefined()) {
        result.user = convert<IDLDictionary<PublicKeyCredentialCreationOptions::UserEntity>>(lexicalGlobalObject, userValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "user", "PublicKeyCredentialCreationOptions", "PublicKeyCredentialUserEntity");
        return { };
    }
    return result;
}

#endif

#if ENABLE(WEB_AUTHN)

String convertEnumerationToString(PublicKeyCredentialCreationOptions::AuthenticatorAttachment enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("platform"),
        MAKE_STATIC_STRING_IMPL("cross-platform"),
    };
    static_assert(static_cast<size_t>(PublicKeyCredentialCreationOptions::AuthenticatorAttachment::Platform) == 0, "PublicKeyCredentialCreationOptions::AuthenticatorAttachment::Platform is not 0 as expected");
    static_assert(static_cast<size_t>(PublicKeyCredentialCreationOptions::AuthenticatorAttachment::CrossPlatform) == 1, "PublicKeyCredentialCreationOptions::AuthenticatorAttachment::CrossPlatform is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, PublicKeyCredentialCreationOptions::AuthenticatorAttachment enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<PublicKeyCredentialCreationOptions::AuthenticatorAttachment> parseEnumeration<PublicKeyCredentialCreationOptions::AuthenticatorAttachment>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "platform")
        return PublicKeyCredentialCreationOptions::AuthenticatorAttachment::Platform;
    if (stringValue == "cross-platform")
        return PublicKeyCredentialCreationOptions::AuthenticatorAttachment::CrossPlatform;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<PublicKeyCredentialCreationOptions::AuthenticatorAttachment>()
{
    return "\"platform\", \"cross-platform\"";
}

#endif

#if ENABLE(WEB_AUTHN)

template<> PublicKeyCredentialCreationOptions::Entity convertDictionary<PublicKeyCredentialCreationOptions::Entity>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PublicKeyCredentialCreationOptions::Entity result;
    JSValue iconValue;
    if (isNullOrUndefined)
        iconValue = jsUndefined();
    else {
        iconValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "icon"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!iconValue.isUndefined()) {
        result.icon = convert<IDLUSVString>(lexicalGlobalObject, iconValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nameValue.isUndefined()) {
        result.name = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name", "PublicKeyCredentialEntity", "DOMString");
        return { };
    }
    return result;
}

#endif

#if ENABLE(WEB_AUTHN)

template<> PublicKeyCredentialCreationOptions::RpEntity convertDictionary<PublicKeyCredentialCreationOptions::RpEntity>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PublicKeyCredentialCreationOptions::RpEntity result;
    JSValue iconValue;
    if (isNullOrUndefined)
        iconValue = jsUndefined();
    else {
        iconValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "icon"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!iconValue.isUndefined()) {
        result.icon = convert<IDLUSVString>(lexicalGlobalObject, iconValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nameValue.isUndefined()) {
        result.name = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name", "PublicKeyCredentialRpEntity", "DOMString");
        return { };
    }
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLDOMString>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

#if ENABLE(WEB_AUTHN)

template<> PublicKeyCredentialCreationOptions::UserEntity convertDictionary<PublicKeyCredentialCreationOptions::UserEntity>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PublicKeyCredentialCreationOptions::UserEntity result;
    JSValue iconValue;
    if (isNullOrUndefined)
        iconValue = jsUndefined();
    else {
        iconValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "icon"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!iconValue.isUndefined()) {
        result.icon = convert<IDLUSVString>(lexicalGlobalObject, iconValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nameValue.isUndefined()) {
        result.name = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name", "PublicKeyCredentialUserEntity", "DOMString");
        return { };
    }
    JSValue displayNameValue;
    if (isNullOrUndefined)
        displayNameValue = jsUndefined();
    else {
        displayNameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displayName"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displayNameValue.isUndefined()) {
        result.displayName = convert<IDLDOMString>(lexicalGlobalObject, displayNameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "displayName", "PublicKeyCredentialUserEntity", "DOMString");
        return { };
    }
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "id", "PublicKeyCredentialUserEntity", "(ArrayBufferView or ArrayBuffer)");
        return { };
    }
    return result;
}

#endif

#if ENABLE(WEB_AUTHN)

template<> PublicKeyCredentialCreationOptions::Parameters convertDictionary<PublicKeyCredentialCreationOptions::Parameters>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PublicKeyCredentialCreationOptions::Parameters result;
    JSValue algValue;
    if (isNullOrUndefined)
        algValue = jsUndefined();
    else {
        algValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "alg"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!algValue.isUndefined()) {
        result.alg = convert<IDLLong>(lexicalGlobalObject, algValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "alg", "PublicKeyCredentialParameters", "long");
        return { };
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<PublicKeyCredentialType>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "type", "PublicKeyCredentialParameters", "PublicKeyCredentialType");
        return { };
    }
    return result;
}

#endif

#if ENABLE(WEB_AUTHN)

template<> PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria convertDictionary<PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria result;
    JSValue authenticatorAttachmentValue;
    if (isNullOrUndefined)
        authenticatorAttachmentValue = jsUndefined();
    else {
        authenticatorAttachmentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "authenticatorAttachment"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!authenticatorAttachmentValue.isUndefined()) {
        result.authenticatorAttachment = convert<IDLEnumeration<PublicKeyCredentialCreationOptions::AuthenticatorAttachment>>(lexicalGlobalObject, authenticatorAttachmentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue requireResidentKeyValue;
    if (isNullOrUndefined)
        requireResidentKeyValue = jsUndefined();
    else {
        requireResidentKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "requireResidentKey"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!requireResidentKeyValue.isUndefined()) {
        result.requireResidentKey = convert<IDLBoolean>(lexicalGlobalObject, requireResidentKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.requireResidentKey = false;
    JSValue userVerificationValue;
    if (isNullOrUndefined)
        userVerificationValue = jsUndefined();
    else {
        userVerificationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "userVerification"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!userVerificationValue.isUndefined()) {
        result.userVerification = convert<IDLEnumeration<UserVerificationRequirement>>(lexicalGlobalObject, userVerificationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.userVerification = UserVerificationRequirement::Preferred;
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUTHN)
