/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCConfiguration.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMGlobalObject.h"
#include "JSRTCCertificate.h"
#include "JSRTCIceServer.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_RTC)

template<> RTCConfiguration convertDictionary<RTCConfiguration>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCConfiguration result;
    JSValue bundlePolicyValue;
    if (isNullOrUndefined)
        bundlePolicyValue = jsUndefined();
    else {
        bundlePolicyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bundlePolicy"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bundlePolicyValue.isUndefined()) {
        result.bundlePolicy = convert<IDLEnumeration<RTCBundlePolicy>>(lexicalGlobalObject, bundlePolicyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bundlePolicy = RTCBundlePolicy::Balanced;
    JSValue certificatesValue;
    if (isNullOrUndefined)
        certificatesValue = jsUndefined();
    else {
        certificatesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "certificates"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!certificatesValue.isUndefined()) {
        result.certificates = convert<IDLSequence<IDLInterface<RTCCertificate>>>(lexicalGlobalObject, certificatesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue iceCandidatePoolSizeValue;
    if (isNullOrUndefined)
        iceCandidatePoolSizeValue = jsUndefined();
    else {
        iceCandidatePoolSizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iceCandidatePoolSize"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!iceCandidatePoolSizeValue.isUndefined()) {
        result.iceCandidatePoolSize = convert<IDLEnforceRangeAdaptor<IDLOctet>>(lexicalGlobalObject, iceCandidatePoolSizeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.iceCandidatePoolSize = 0;
    JSValue iceServersValue;
    if (isNullOrUndefined)
        iceServersValue = jsUndefined();
    else {
        iceServersValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iceServers"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!iceServersValue.isUndefined()) {
        result.iceServers = convert<IDLSequence<IDLDictionary<RTCIceServer>>>(lexicalGlobalObject, iceServersValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue iceTransportPolicyValue;
    if (isNullOrUndefined)
        iceTransportPolicyValue = jsUndefined();
    else {
        iceTransportPolicyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iceTransportPolicy"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!iceTransportPolicyValue.isUndefined()) {
        result.iceTransportPolicy = convert<IDLEnumeration<RTCIceTransportPolicy>>(lexicalGlobalObject, iceTransportPolicyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.iceTransportPolicy = RTCIceTransportPolicy::All;
    JSValue rtcpMuxPolicyValue;
    if (isNullOrUndefined)
        rtcpMuxPolicyValue = jsUndefined();
    else {
        rtcpMuxPolicyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rtcpMuxPolicy"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rtcpMuxPolicyValue.isUndefined()) {
        result.rtcpMuxPolicy = convert<IDLEnumeration<RTCPMuxPolicy>>(lexicalGlobalObject, rtcpMuxPolicyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.rtcpMuxPolicy = RTCPMuxPolicy::Require;
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCConfiguration& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto bundlePolicyValue = toJS<IDLEnumeration<RTCBundlePolicy>>(lexicalGlobalObject, dictionary.bundlePolicy);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "bundlePolicy"), bundlePolicyValue);
    if (!IDLSequence<IDLInterface<RTCCertificate>>::isNullValue(dictionary.certificates)) {
        auto certificatesValue = toJS<IDLSequence<IDLInterface<RTCCertificate>>>(lexicalGlobalObject, globalObject, IDLSequence<IDLInterface<RTCCertificate>>::extractValueFromNullable(dictionary.certificates));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "certificates"), certificatesValue);
    }
    auto iceCandidatePoolSizeValue = toJS<IDLEnforceRangeAdaptor<IDLOctet>>(dictionary.iceCandidatePoolSize);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "iceCandidatePoolSize"), iceCandidatePoolSizeValue);
    if (!IDLSequence<IDLDictionary<RTCIceServer>>::isNullValue(dictionary.iceServers)) {
        auto iceServersValue = toJS<IDLSequence<IDLDictionary<RTCIceServer>>>(lexicalGlobalObject, globalObject, IDLSequence<IDLDictionary<RTCIceServer>>::extractValueFromNullable(dictionary.iceServers));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "iceServers"), iceServersValue);
    }
    auto iceTransportPolicyValue = toJS<IDLEnumeration<RTCIceTransportPolicy>>(lexicalGlobalObject, dictionary.iceTransportPolicy);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "iceTransportPolicy"), iceTransportPolicyValue);
    auto rtcpMuxPolicyValue = toJS<IDLEnumeration<RTCPMuxPolicy>>(lexicalGlobalObject, dictionary.rtcpMuxPolicy);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "rtcpMuxPolicy"), rtcpMuxPolicyValue);
    return result;
}

#endif

#if ENABLE(WEB_RTC)

String convertEnumerationToString(RTCIceTransportPolicy enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("relay"),
        MAKE_STATIC_STRING_IMPL("all"),
    };
    static_assert(static_cast<size_t>(RTCIceTransportPolicy::Relay) == 0, "RTCIceTransportPolicy::Relay is not 0 as expected");
    static_assert(static_cast<size_t>(RTCIceTransportPolicy::All) == 1, "RTCIceTransportPolicy::All is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCIceTransportPolicy enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCIceTransportPolicy> parseEnumeration<RTCIceTransportPolicy>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "relay")
        return RTCIceTransportPolicy::Relay;
    if (stringValue == "all")
        return RTCIceTransportPolicy::All;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCIceTransportPolicy>()
{
    return "\"relay\", \"all\"";
}

#endif

#if ENABLE(WEB_RTC)

String convertEnumerationToString(RTCBundlePolicy enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("balanced"),
        MAKE_STATIC_STRING_IMPL("max-compat"),
        MAKE_STATIC_STRING_IMPL("max-bundle"),
    };
    static_assert(static_cast<size_t>(RTCBundlePolicy::Balanced) == 0, "RTCBundlePolicy::Balanced is not 0 as expected");
    static_assert(static_cast<size_t>(RTCBundlePolicy::MaxCompat) == 1, "RTCBundlePolicy::MaxCompat is not 1 as expected");
    static_assert(static_cast<size_t>(RTCBundlePolicy::MaxBundle) == 2, "RTCBundlePolicy::MaxBundle is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCBundlePolicy enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCBundlePolicy> parseEnumeration<RTCBundlePolicy>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "balanced")
        return RTCBundlePolicy::Balanced;
    if (stringValue == "max-compat")
        return RTCBundlePolicy::MaxCompat;
    if (stringValue == "max-bundle")
        return RTCBundlePolicy::MaxBundle;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCBundlePolicy>()
{
    return "\"balanced\", \"max-compat\", \"max-bundle\"";
}

#endif

#if ENABLE(WEB_RTC)

String convertEnumerationToString(RTCPMuxPolicy enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("negotiate"),
        MAKE_STATIC_STRING_IMPL("require"),
    };
    static_assert(static_cast<size_t>(RTCPMuxPolicy::Negotiate) == 0, "RTCPMuxPolicy::Negotiate is not 0 as expected");
    static_assert(static_cast<size_t>(RTCPMuxPolicy::Require) == 1, "RTCPMuxPolicy::Require is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCPMuxPolicy enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCPMuxPolicy> parseEnumeration<RTCPMuxPolicy>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "negotiate")
        return RTCPMuxPolicy::Negotiate;
    if (stringValue == "require")
        return RTCPMuxPolicy::Require;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCPMuxPolicy>()
{
    return "\"negotiate\", \"require\"";
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_RTC)
