/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCDataChannel.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSBlob.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_RTC)

String convertEnumerationToString(RTCDataChannelState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("connecting"),
        MAKE_STATIC_STRING_IMPL("open"),
        MAKE_STATIC_STRING_IMPL("closing"),
        MAKE_STATIC_STRING_IMPL("closed"),
    };
    static_assert(static_cast<size_t>(RTCDataChannelState::Connecting) == 0, "RTCDataChannelState::Connecting is not 0 as expected");
    static_assert(static_cast<size_t>(RTCDataChannelState::Open) == 1, "RTCDataChannelState::Open is not 1 as expected");
    static_assert(static_cast<size_t>(RTCDataChannelState::Closing) == 2, "RTCDataChannelState::Closing is not 2 as expected");
    static_assert(static_cast<size_t>(RTCDataChannelState::Closed) == 3, "RTCDataChannelState::Closed is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCDataChannelState enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCDataChannelState> parseEnumeration<RTCDataChannelState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "connecting")
        return RTCDataChannelState::Connecting;
    if (stringValue == "open")
        return RTCDataChannelState::Open;
    if (stringValue == "closing")
        return RTCDataChannelState::Closing;
    if (stringValue == "closed")
        return RTCDataChannelState::Closed;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCDataChannelState>()
{
    return "\"connecting\", \"open\", \"closing\", \"closed\"";
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsRTCDataChannelPrototypeFunctionSend(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCDataChannelPrototypeFunctionClose(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsRTCDataChannelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCDataChannelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCDataChannelLabel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCDataChannelOrdered(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCDataChannelMaxPacketLifeTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCDataChannelMaxRetransmits(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCDataChannelProtocol(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCDataChannelNegotiated(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCDataChannelId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCDataChannelReadyState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCDataChannelBufferedAmount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCDataChannelBufferedAmountLowThreshold(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCDataChannelBufferedAmountLowThreshold(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCDataChannelBinaryType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCDataChannelBinaryType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCDataChannelOnopen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCDataChannelOnopen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCDataChannelOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCDataChannelOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCDataChannelOnclose(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCDataChannelOnclose(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCDataChannelOnmessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCDataChannelOnmessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCDataChannelOnbufferedamountlow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCDataChannelOnbufferedamountlow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSRTCDataChannelPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSRTCDataChannelPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRTCDataChannelPrototype* ptr = new (NotNull, JSC::allocateCell<JSRTCDataChannelPrototype>(vm.heap)) JSRTCDataChannelPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRTCDataChannelPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSRTCDataChannelPrototype, JSRTCDataChannelPrototype::Base);

using JSRTCDataChannelConstructor = JSDOMConstructorNotConstructable<JSRTCDataChannel>;

template<> JSValue JSRTCDataChannelConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSRTCDataChannelConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSRTCDataChannel::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("RTCDataChannel"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSRTCDataChannelConstructor::s_info = { "RTCDataChannel", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCDataChannelConstructor) };

/* Hash table for prototype */

static const HashTableValue JSRTCDataChannelPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCDataChannelConstructor) } },
    { "label", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelLabel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ordered", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelOrdered), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "maxPacketLifeTime", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelMaxPacketLifeTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "maxRetransmits", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelMaxRetransmits), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "protocol", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelProtocol), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "negotiated", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelNegotiated), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "id", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "readyState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelReadyState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "bufferedAmount", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelBufferedAmount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "bufferedAmountLowThreshold", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelBufferedAmountLowThreshold), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCDataChannelBufferedAmountLowThreshold) } },
    { "binaryType", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelBinaryType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCDataChannelBinaryType) } },
    { "onopen", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelOnopen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCDataChannelOnopen) } },
    { "onerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCDataChannelOnerror) } },
    { "onclose", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelOnclose), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCDataChannelOnclose) } },
    { "onmessage", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelOnmessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCDataChannelOnmessage) } },
    { "onbufferedamountlow", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCDataChannelOnbufferedamountlow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCDataChannelOnbufferedamountlow) } },
    { "send", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCDataChannelPrototypeFunctionSend), (intptr_t) (1) } },
    { "close", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCDataChannelPrototypeFunctionClose), (intptr_t) (0) } },
};

const ClassInfo JSRTCDataChannelPrototype::s_info = { "RTCDataChannelPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCDataChannelPrototype) };

void JSRTCDataChannelPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSRTCDataChannel::info(), JSRTCDataChannelPrototypeTableValues, *this);
}

const ClassInfo JSRTCDataChannel::s_info = { "RTCDataChannel", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCDataChannel) };

JSRTCDataChannel::JSRTCDataChannel(Structure* structure, JSDOMGlobalObject& globalObject, Ref<RTCDataChannel>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSRTCDataChannel::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, RTCDataChannel>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSRTCDataChannel::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSRTCDataChannelPrototype::create(vm, &globalObject, JSRTCDataChannelPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSRTCDataChannel::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSRTCDataChannel>(vm, globalObject);
}

JSValue JSRTCDataChannel::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRTCDataChannelConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSRTCDataChannel* IDLAttribute<JSRTCDataChannel>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSRTCDataChannel*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSRTCDataChannel* IDLOperation<JSRTCDataChannel>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSRTCDataChannel*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsRTCDataChannelConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCDataChannelPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSRTCDataChannel::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSRTCDataChannelConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCDataChannelPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsRTCDataChannelLabelGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.label());
    return result;
}

EncodedJSValue jsRTCDataChannelLabel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelLabelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "label");
}

static inline JSValue jsRTCDataChannelOrderedGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.ordered());
    return result;
}

EncodedJSValue jsRTCDataChannelOrdered(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelOrderedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ordered");
}

static inline JSValue jsRTCDataChannelMaxPacketLifeTimeGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnsignedShort>>(lexicalGlobalObject, throwScope, impl.maxPacketLifeTime());
    return result;
}

EncodedJSValue jsRTCDataChannelMaxPacketLifeTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelMaxPacketLifeTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "maxPacketLifeTime");
}

static inline JSValue jsRTCDataChannelMaxRetransmitsGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnsignedShort>>(lexicalGlobalObject, throwScope, impl.maxRetransmits());
    return result;
}

EncodedJSValue jsRTCDataChannelMaxRetransmits(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelMaxRetransmitsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "maxRetransmits");
}

static inline JSValue jsRTCDataChannelProtocolGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.protocol());
    return result;
}

EncodedJSValue jsRTCDataChannelProtocol(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelProtocolGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "protocol");
}

static inline JSValue jsRTCDataChannelNegotiatedGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.negotiated());
    return result;
}

EncodedJSValue jsRTCDataChannelNegotiated(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelNegotiatedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "negotiated");
}

static inline JSValue jsRTCDataChannelIdGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnsignedShort>>(lexicalGlobalObject, throwScope, impl.id());
    return result;
}

EncodedJSValue jsRTCDataChannelId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "id");
}

static inline JSValue jsRTCDataChannelReadyStateGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<RTCDataChannelState>>(lexicalGlobalObject, throwScope, impl.readyState());
    return result;
}

EncodedJSValue jsRTCDataChannelReadyState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelReadyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "readyState");
}

static inline JSValue jsRTCDataChannelBufferedAmountGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.bufferedAmount());
    return result;
}

EncodedJSValue jsRTCDataChannelBufferedAmount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelBufferedAmountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "bufferedAmount");
}

static inline JSValue jsRTCDataChannelBufferedAmountLowThresholdGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.bufferedAmountLowThreshold());
    return result;
}

EncodedJSValue jsRTCDataChannelBufferedAmountLowThreshold(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelBufferedAmountLowThresholdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "bufferedAmountLowThreshold");
}

static inline bool setJSRTCDataChannelBufferedAmountLowThresholdSetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBufferedAmountLowThreshold(WTFMove(nativeValue));
    });
    return true;
}

bool setJSRTCDataChannelBufferedAmountLowThreshold(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCDataChannel>::set<setJSRTCDataChannelBufferedAmountLowThresholdSetter>(*lexicalGlobalObject, thisValue, encodedValue, "bufferedAmountLowThreshold");
}

static inline JSValue jsRTCDataChannelBinaryTypeGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.binaryType());
    return result;
}

EncodedJSValue jsRTCDataChannelBinaryType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelBinaryTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "binaryType");
}

static inline bool setJSRTCDataChannelBinaryTypeSetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBinaryType(WTFMove(nativeValue));
    });
    return true;
}

bool setJSRTCDataChannelBinaryType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCDataChannel>::set<setJSRTCDataChannelBinaryTypeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "binaryType");
}

static inline JSValue jsRTCDataChannelOnopenGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().openEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsRTCDataChannelOnopen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelOnopenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onopen");
}

static inline bool setJSRTCDataChannelOnopenSetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().openEvent, value);
    return true;
}

bool setJSRTCDataChannelOnopen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCDataChannel>::set<setJSRTCDataChannelOnopenSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onopen");
}

static inline JSValue jsRTCDataChannelOnerrorGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsRTCDataChannelOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelOnerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onerror");
}

static inline bool setJSRTCDataChannelOnerrorSetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().errorEvent, value);
    return true;
}

bool setJSRTCDataChannelOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCDataChannel>::set<setJSRTCDataChannelOnerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onerror");
}

static inline JSValue jsRTCDataChannelOncloseGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().closeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsRTCDataChannelOnclose(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelOncloseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onclose");
}

static inline bool setJSRTCDataChannelOncloseSetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().closeEvent, value);
    return true;
}

bool setJSRTCDataChannelOnclose(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCDataChannel>::set<setJSRTCDataChannelOncloseSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onclose");
}

static inline JSValue jsRTCDataChannelOnmessageGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().messageEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsRTCDataChannelOnmessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelOnmessageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmessage");
}

static inline bool setJSRTCDataChannelOnmessageSetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().messageEvent, value);
    return true;
}

bool setJSRTCDataChannelOnmessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCDataChannel>::set<setJSRTCDataChannelOnmessageSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmessage");
}

static inline JSValue jsRTCDataChannelOnbufferedamountlowGetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().bufferedamountlowEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsRTCDataChannelOnbufferedamountlow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCDataChannel>::get<jsRTCDataChannelOnbufferedamountlowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onbufferedamountlow");
}

static inline bool setJSRTCDataChannelOnbufferedamountlowSetter(JSGlobalObject& lexicalGlobalObject, JSRTCDataChannel& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().bufferedamountlowEvent, value);
    return true;
}

bool setJSRTCDataChannelOnbufferedamountlow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCDataChannel>::set<setJSRTCDataChannelOnbufferedamountlowSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbufferedamountlow");
}

static inline JSC::EncodedJSValue jsRTCDataChannelPrototypeFunctionSend1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCDataChannel>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto data = convert<IDLArrayBuffer>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "data", "RTCDataChannel", "send", "ArrayBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.send(*data));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsRTCDataChannelPrototypeFunctionSend2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCDataChannel>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto data = convert<IDLArrayBufferView>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "data", "RTCDataChannel", "send", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.send(data.releaseNonNull()));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsRTCDataChannelPrototypeFunctionSend3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCDataChannel>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto data = convert<IDLInterface<Blob>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "data", "RTCDataChannel", "send", "Blob"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.send(*data));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsRTCDataChannelPrototypeFunctionSend4Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCDataChannel>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto data = convert<IDLUSVString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.send(WTFMove(data)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsRTCDataChannelPrototypeFunctionSendOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCDataChannel>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBuffer>(vm))
            return jsRTCDataChannelPrototypeFunctionSend1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSArrayBufferView>(vm))
            return jsRTCDataChannelPrototypeFunctionSend2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSBlob>(vm))
            return jsRTCDataChannelPrototypeFunctionSend3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsRTCDataChannelPrototypeFunctionSend4Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsRTCDataChannelPrototypeFunctionSend(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCDataChannel>::call<jsRTCDataChannelPrototypeFunctionSendOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "send");
}

static inline JSC::EncodedJSValue jsRTCDataChannelPrototypeFunctionCloseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCDataChannel>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.close();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCDataChannelPrototypeFunctionClose(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCDataChannel>::call<jsRTCDataChannelPrototypeFunctionCloseBody>(*lexicalGlobalObject, *callFrame, "close");
}

void JSRTCDataChannel::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSRTCDataChannel*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSRTCDataChannelOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsRTCDataChannel = jsCast<JSRTCDataChannel*>(handle.slot()->asCell());
    if (jsRTCDataChannel->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsRTCDataChannel->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSRTCDataChannelOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsRTCDataChannel = static_cast<JSRTCDataChannel*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsRTCDataChannel->wrapped(), jsRTCDataChannel);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7RTCDataChannel@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14RTCDataChannelE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<RTCDataChannel>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7RTCDataChannel@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14RTCDataChannelE[2];
#endif

    // If this fails RTCDataChannel does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<RTCDataChannel>::value, "RTCDataChannel is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // RTCDataChannel has subclasses. If RTCDataChannel has subclasses that get passed
    // to toJS() we currently require RTCDataChannel you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<RTCDataChannel>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RTCDataChannel& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

RTCDataChannel* JSRTCDataChannel::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSRTCDataChannel*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_RTC)
