/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCDegradationPreference.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(RTCDegradationPreference enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("maintain-framerate"),
        MAKE_STATIC_STRING_IMPL("maintain-resolution"),
        MAKE_STATIC_STRING_IMPL("balanced"),
    };
    static_assert(static_cast<size_t>(RTCDegradationPreference::MaintainFramerate) == 0, "RTCDegradationPreference::MaintainFramerate is not 0 as expected");
    static_assert(static_cast<size_t>(RTCDegradationPreference::MaintainResolution) == 1, "RTCDegradationPreference::MaintainResolution is not 1 as expected");
    static_assert(static_cast<size_t>(RTCDegradationPreference::Balanced) == 2, "RTCDegradationPreference::Balanced is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCDegradationPreference enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCDegradationPreference> parseEnumeration<RTCDegradationPreference>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "maintain-framerate")
        return RTCDegradationPreference::MaintainFramerate;
    if (stringValue == "maintain-resolution")
        return RTCDegradationPreference::MaintainResolution;
    if (stringValue == "balanced")
        return RTCDegradationPreference::Balanced;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCDegradationPreference>()
{
    return "\"maintain-framerate\", \"maintain-resolution\", \"balanced\"";
}

} // namespace WebCore

#endif // ENABLE(WEB_RTC)
