/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCIceCandidate.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_RTC)

template<> RTCIceCandidate::Init convertDictionary<RTCIceCandidate::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCIceCandidate::Init result;
    JSValue candidateValue;
    if (isNullOrUndefined)
        candidateValue = jsUndefined();
    else {
        candidateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "candidate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!candidateValue.isUndefined()) {
        result.candidate = convert<IDLDOMString>(lexicalGlobalObject, candidateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.candidate = emptyString();
    JSValue sdpMLineIndexValue;
    if (isNullOrUndefined)
        sdpMLineIndexValue = jsUndefined();
    else {
        sdpMLineIndexValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sdpMLineIndex"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sdpMLineIndexValue.isUndefined()) {
        result.sdpMLineIndex = convert<IDLNullable<IDLUnsignedShort>>(lexicalGlobalObject, sdpMLineIndexValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.sdpMLineIndex = WTF::nullopt;
    JSValue sdpMidValue;
    if (isNullOrUndefined)
        sdpMidValue = jsUndefined();
    else {
        sdpMidValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sdpMid"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sdpMidValue.isUndefined()) {
        result.sdpMid = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, sdpMidValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.sdpMid = String();
    return result;
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsRTCIceCandidatePrototypeFunctionToJSON(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsRTCIceCandidateConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCIceCandidateConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCIceCandidateCandidate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCIceCandidateSdpMid(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCIceCandidateSdpMLineIndex(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSRTCIceCandidatePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSRTCIceCandidatePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRTCIceCandidatePrototype* ptr = new (NotNull, JSC::allocateCell<JSRTCIceCandidatePrototype>(vm.heap)) JSRTCIceCandidatePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRTCIceCandidatePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSRTCIceCandidatePrototype, JSRTCIceCandidatePrototype::Base);

using JSRTCIceCandidateConstructor = JSDOMConstructor<JSRTCIceCandidate>;

template<> EncodedJSValue JSC_HOST_CALL JSRTCIceCandidateConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSRTCIceCandidateConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto candidateInitDict = convert<IDLDictionary<RTCIceCandidate::Init>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = RTCIceCandidate::create(WTFMove(candidateInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<RTCIceCandidate>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> JSValue JSRTCIceCandidateConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSRTCIceCandidateConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSRTCIceCandidate::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("RTCIceCandidate"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSRTCIceCandidateConstructor::s_info = { "RTCIceCandidate", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCIceCandidateConstructor) };

/* Hash table for prototype */

static const HashTableValue JSRTCIceCandidatePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCIceCandidateConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCIceCandidateConstructor) } },
    { "candidate", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCIceCandidateCandidate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "sdpMid", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCIceCandidateSdpMid), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "sdpMLineIndex", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCIceCandidateSdpMLineIndex), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "toJSON", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCIceCandidatePrototypeFunctionToJSON), (intptr_t) (0) } },
};

const ClassInfo JSRTCIceCandidatePrototype::s_info = { "RTCIceCandidatePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCIceCandidatePrototype) };

void JSRTCIceCandidatePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSRTCIceCandidate::info(), JSRTCIceCandidatePrototypeTableValues, *this);
}

const ClassInfo JSRTCIceCandidate::s_info = { "RTCIceCandidate", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCIceCandidate) };

JSRTCIceCandidate::JSRTCIceCandidate(Structure* structure, JSDOMGlobalObject& globalObject, Ref<RTCIceCandidate>&& impl)
    : JSDOMWrapper<RTCIceCandidate>(structure, globalObject, WTFMove(impl))
{
}

void JSRTCIceCandidate::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, RTCIceCandidate>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSRTCIceCandidate::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSRTCIceCandidatePrototype::create(vm, &globalObject, JSRTCIceCandidatePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSRTCIceCandidate::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSRTCIceCandidate>(vm, globalObject);
}

JSValue JSRTCIceCandidate::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRTCIceCandidateConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSRTCIceCandidate::destroy(JSC::JSCell* cell)
{
    JSRTCIceCandidate* thisObject = static_cast<JSRTCIceCandidate*>(cell);
    thisObject->JSRTCIceCandidate::~JSRTCIceCandidate();
}

template<> inline JSRTCIceCandidate* IDLAttribute<JSRTCIceCandidate>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSRTCIceCandidate*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSRTCIceCandidate* IDLOperation<JSRTCIceCandidate>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSRTCIceCandidate*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsRTCIceCandidateConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCIceCandidatePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSRTCIceCandidate::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSRTCIceCandidateConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCIceCandidatePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsRTCIceCandidateCandidateGetter(JSGlobalObject& lexicalGlobalObject, JSRTCIceCandidate& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.candidate());
    return result;
}

EncodedJSValue jsRTCIceCandidateCandidate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCIceCandidate>::get<jsRTCIceCandidateCandidateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "candidate");
}

static inline JSValue jsRTCIceCandidateSdpMidGetter(JSGlobalObject& lexicalGlobalObject, JSRTCIceCandidate& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.sdpMid());
    return result;
}

EncodedJSValue jsRTCIceCandidateSdpMid(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCIceCandidate>::get<jsRTCIceCandidateSdpMidGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "sdpMid");
}

static inline JSValue jsRTCIceCandidateSdpMLineIndexGetter(JSGlobalObject& lexicalGlobalObject, JSRTCIceCandidate& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnsignedShort>>(lexicalGlobalObject, throwScope, impl.sdpMLineIndex());
    return result;
}

EncodedJSValue jsRTCIceCandidateSdpMLineIndex(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCIceCandidate>::get<jsRTCIceCandidateSdpMLineIndexGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "sdpMLineIndex");
}

JSC::JSObject* JSRTCIceCandidate::serialize(JSGlobalObject& lexicalGlobalObject, JSRTCIceCandidate& thisObject, JSDOMGlobalObject& globalObject, ThrowScope& throwScope)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto* result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto candidateValue = jsRTCIceCandidateCandidateGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "candidate"), candidateValue);

    auto sdpMidValue = jsRTCIceCandidateSdpMidGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "sdpMid"), sdpMidValue);

    auto sdpMLineIndexValue = jsRTCIceCandidateSdpMLineIndexGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "sdpMLineIndex"), sdpMLineIndexValue);

    return result;
}

static inline EncodedJSValue jsRTCIceCandidatePrototypeFunctionToJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSRTCIceCandidate* thisObject, JSC::ThrowScope& throwScope)
{
    return JSValue::encode(JSRTCIceCandidate::serialize(*lexicalGlobalObject, *thisObject, *thisObject->globalObject(), throwScope));
}

EncodedJSValue JSC_HOST_CALL jsRTCIceCandidatePrototypeFunctionToJSON(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCIceCandidate>::call<jsRTCIceCandidatePrototypeFunctionToJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

void JSRTCIceCandidate::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSRTCIceCandidate*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSRTCIceCandidateOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSRTCIceCandidateOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsRTCIceCandidate = static_cast<JSRTCIceCandidate*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsRTCIceCandidate->wrapped(), jsRTCIceCandidate);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<RTCIceCandidate>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to RTCIceCandidate.
    static_assert(!std::is_polymorphic<RTCIceCandidate>::value, "RTCIceCandidate is polymorphic but the IDL claims it is not");
    return createWrapper<RTCIceCandidate>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RTCIceCandidate& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

RTCIceCandidate* JSRTCIceCandidate::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSRTCIceCandidate*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_RTC)
