/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCIceTransportState.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(RTCIceTransportState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("new"),
        MAKE_STATIC_STRING_IMPL("checking"),
        MAKE_STATIC_STRING_IMPL("connected"),
        MAKE_STATIC_STRING_IMPL("completed"),
        MAKE_STATIC_STRING_IMPL("failed"),
        MAKE_STATIC_STRING_IMPL("disconnected"),
        MAKE_STATIC_STRING_IMPL("closed"),
    };
    static_assert(static_cast<size_t>(RTCIceTransportState::New) == 0, "RTCIceTransportState::New is not 0 as expected");
    static_assert(static_cast<size_t>(RTCIceTransportState::Checking) == 1, "RTCIceTransportState::Checking is not 1 as expected");
    static_assert(static_cast<size_t>(RTCIceTransportState::Connected) == 2, "RTCIceTransportState::Connected is not 2 as expected");
    static_assert(static_cast<size_t>(RTCIceTransportState::Completed) == 3, "RTCIceTransportState::Completed is not 3 as expected");
    static_assert(static_cast<size_t>(RTCIceTransportState::Failed) == 4, "RTCIceTransportState::Failed is not 4 as expected");
    static_assert(static_cast<size_t>(RTCIceTransportState::Disconnected) == 5, "RTCIceTransportState::Disconnected is not 5 as expected");
    static_assert(static_cast<size_t>(RTCIceTransportState::Closed) == 6, "RTCIceTransportState::Closed is not 6 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCIceTransportState enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCIceTransportState> parseEnumeration<RTCIceTransportState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "new")
        return RTCIceTransportState::New;
    if (stringValue == "checking")
        return RTCIceTransportState::Checking;
    if (stringValue == "connected")
        return RTCIceTransportState::Connected;
    if (stringValue == "completed")
        return RTCIceTransportState::Completed;
    if (stringValue == "failed")
        return RTCIceTransportState::Failed;
    if (stringValue == "disconnected")
        return RTCIceTransportState::Disconnected;
    if (stringValue == "closed")
        return RTCIceTransportState::Closed;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCIceTransportState>()
{
    return "\"new\", \"checking\", \"connected\", \"completed\", \"failed\", \"disconnected\", \"closed\"";
}

} // namespace WebCore

#endif // ENABLE(WEB_RTC)
