/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCPeerConnectionState.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(RTCPeerConnectionState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("new"),
        MAKE_STATIC_STRING_IMPL("connecting"),
        MAKE_STATIC_STRING_IMPL("connected"),
        MAKE_STATIC_STRING_IMPL("disconnected"),
        MAKE_STATIC_STRING_IMPL("failed"),
        MAKE_STATIC_STRING_IMPL("closed"),
    };
    static_assert(static_cast<size_t>(RTCPeerConnectionState::New) == 0, "RTCPeerConnectionState::New is not 0 as expected");
    static_assert(static_cast<size_t>(RTCPeerConnectionState::Connecting) == 1, "RTCPeerConnectionState::Connecting is not 1 as expected");
    static_assert(static_cast<size_t>(RTCPeerConnectionState::Connected) == 2, "RTCPeerConnectionState::Connected is not 2 as expected");
    static_assert(static_cast<size_t>(RTCPeerConnectionState::Disconnected) == 3, "RTCPeerConnectionState::Disconnected is not 3 as expected");
    static_assert(static_cast<size_t>(RTCPeerConnectionState::Failed) == 4, "RTCPeerConnectionState::Failed is not 4 as expected");
    static_assert(static_cast<size_t>(RTCPeerConnectionState::Closed) == 5, "RTCPeerConnectionState::Closed is not 5 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCPeerConnectionState enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCPeerConnectionState> parseEnumeration<RTCPeerConnectionState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "new")
        return RTCPeerConnectionState::New;
    if (stringValue == "connecting")
        return RTCPeerConnectionState::Connecting;
    if (stringValue == "connected")
        return RTCPeerConnectionState::Connected;
    if (stringValue == "disconnected")
        return RTCPeerConnectionState::Disconnected;
    if (stringValue == "failed")
        return RTCPeerConnectionState::Failed;
    if (stringValue == "closed")
        return RTCPeerConnectionState::Closed;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCPeerConnectionState>()
{
    return "\"new\", \"connecting\", \"connected\", \"disconnected\", \"failed\", \"closed\"";
}

} // namespace WebCore

#endif // ENABLE(WEB_RTC)
