/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCPriorityType.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(RTCPriorityType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("very-low"),
        MAKE_STATIC_STRING_IMPL("low"),
        MAKE_STATIC_STRING_IMPL("medium"),
        MAKE_STATIC_STRING_IMPL("high"),
    };
    static_assert(static_cast<size_t>(RTCPriorityType::VeryLow) == 0, "RTCPriorityType::VeryLow is not 0 as expected");
    static_assert(static_cast<size_t>(RTCPriorityType::Low) == 1, "RTCPriorityType::Low is not 1 as expected");
    static_assert(static_cast<size_t>(RTCPriorityType::Medium) == 2, "RTCPriorityType::Medium is not 2 as expected");
    static_assert(static_cast<size_t>(RTCPriorityType::High) == 3, "RTCPriorityType::High is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCPriorityType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCPriorityType> parseEnumeration<RTCPriorityType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "very-low")
        return RTCPriorityType::VeryLow;
    if (stringValue == "low")
        return RTCPriorityType::Low;
    if (stringValue == "medium")
        return RTCPriorityType::Medium;
    if (stringValue == "high")
        return RTCPriorityType::High;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCPriorityType>()
{
    return "\"very-low\", \"low\", \"medium\", \"high\"";
}

} // namespace WebCore

#endif // ENABLE(WEB_RTC)
