/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCRtpCodecCapability.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_RTC)

template<> RTCRtpCodecCapability convertDictionary<RTCRtpCodecCapability>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCRtpCodecCapability result;
    JSValue channelsValue;
    if (isNullOrUndefined)
        channelsValue = jsUndefined();
    else {
        channelsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channels"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelsValue.isUndefined()) {
        result.channels = convert<IDLUnsignedShort>(lexicalGlobalObject, channelsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue clockRateValue;
    if (isNullOrUndefined)
        clockRateValue = jsUndefined();
    else {
        clockRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clockRate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clockRateValue.isUndefined()) {
        result.clockRate = convert<IDLUnsignedLong>(lexicalGlobalObject, clockRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "clockRate", "RTCRtpCodecCapability", "unsigned long");
        return { };
    }
    JSValue mimeTypeValue;
    if (isNullOrUndefined)
        mimeTypeValue = jsUndefined();
    else {
        mimeTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mimeType"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mimeTypeValue.isUndefined()) {
        result.mimeType = convert<IDLDOMString>(lexicalGlobalObject, mimeTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "mimeType", "RTCRtpCodecCapability", "DOMString");
        return { };
    }
    JSValue sdpFmtpLineValue;
    if (isNullOrUndefined)
        sdpFmtpLineValue = jsUndefined();
    else {
        sdpFmtpLineValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sdpFmtpLine"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sdpFmtpLineValue.isUndefined()) {
        result.sdpFmtpLine = convert<IDLDOMString>(lexicalGlobalObject, sdpFmtpLineValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCRtpCodecCapability& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUnsignedShort::isNullValue(dictionary.channels)) {
        auto channelsValue = toJS<IDLUnsignedShort>(IDLUnsignedShort::extractValueFromNullable(dictionary.channels));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "channels"), channelsValue);
    }
    auto clockRateValue = toJS<IDLUnsignedLong>(dictionary.clockRate);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "clockRate"), clockRateValue);
    auto mimeTypeValue = toJS<IDLDOMString>(lexicalGlobalObject, dictionary.mimeType);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "mimeType"), mimeTypeValue);
    if (!IDLDOMString::isNullValue(dictionary.sdpFmtpLine)) {
        auto sdpFmtpLineValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.sdpFmtpLine));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sdpFmtpLine"), sdpFmtpLineValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_RTC)
