/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCRtpEncodingParameters.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include "JSRTCDtxStatus.h"
#include "JSRTCPriorityType.h"
#include "JSRTCRtpFecParameters.h"
#include "JSRTCRtpRtxParameters.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_RTC)

template<> RTCRtpEncodingParameters convertDictionary<RTCRtpEncodingParameters>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    RTCRtpEncodingParameters result;
    JSValue ridValue;
    if (isNullOrUndefined)
        ridValue = jsUndefined();
    else {
        ridValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rid"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ridValue.isUndefined()) {
        result.rid = convert<IDLDOMString>(lexicalGlobalObject, ridValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue activeValue;
    if (isNullOrUndefined)
        activeValue = jsUndefined();
    else {
        activeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "active"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!activeValue.isUndefined()) {
        result.active = convert<IDLBoolean>(lexicalGlobalObject, activeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue dtxValue;
    if (isNullOrUndefined)
        dtxValue = jsUndefined();
    else {
        dtxValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "dtx"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dtxValue.isUndefined()) {
        result.dtx = convert<IDLEnumeration<RTCDtxStatus>>(lexicalGlobalObject, dtxValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue fecValue;
    if (isNullOrUndefined)
        fecValue = jsUndefined();
    else {
        fecValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fec"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!fecValue.isUndefined()) {
        result.fec = convert<IDLDictionary<RTCRtpFecParameters>>(lexicalGlobalObject, fecValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue maxBitrateValue;
    if (isNullOrUndefined)
        maxBitrateValue = jsUndefined();
    else {
        maxBitrateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxBitrate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maxBitrateValue.isUndefined()) {
        result.maxBitrate = convert<IDLUnsignedLong>(lexicalGlobalObject, maxBitrateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue maxFramerateValue;
    if (isNullOrUndefined)
        maxFramerateValue = jsUndefined();
    else {
        maxFramerateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxFramerate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maxFramerateValue.isUndefined()) {
        result.maxFramerate = convert<IDLUnsignedLong>(lexicalGlobalObject, maxFramerateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue priorityValue;
    if (isNullOrUndefined)
        priorityValue = jsUndefined();
    else {
        priorityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "priority"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!priorityValue.isUndefined()) {
        result.priority = convert<IDLEnumeration<RTCPriorityType>>(lexicalGlobalObject, priorityValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue rtxValue;
    if (isNullOrUndefined)
        rtxValue = jsUndefined();
    else {
        rtxValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rtx"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rtxValue.isUndefined()) {
        result.rtx = convert<IDLDictionary<RTCRtpRtxParameters>>(lexicalGlobalObject, rtxValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue scaleResolutionDownByValue;
    if (isNullOrUndefined)
        scaleResolutionDownByValue = jsUndefined();
    else {
        scaleResolutionDownByValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "scaleResolutionDownBy"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!scaleResolutionDownByValue.isUndefined()) {
        result.scaleResolutionDownBy = convert<IDLDouble>(lexicalGlobalObject, scaleResolutionDownByValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.scaleResolutionDownBy = 1;
    JSValue ssrcValue;
    if (isNullOrUndefined)
        ssrcValue = jsUndefined();
    else {
        ssrcValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ssrc"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ssrcValue.isUndefined()) {
        result.ssrc = convert<IDLUnsignedLong>(lexicalGlobalObject, ssrcValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const RTCRtpEncodingParameters& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.rid)) {
        auto ridValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.rid));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "rid"), ridValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.active)) {
        auto activeValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.active));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "active"), activeValue);
    }
    if (!IDLEnumeration<RTCDtxStatus>::isNullValue(dictionary.dtx)) {
        auto dtxValue = toJS<IDLEnumeration<RTCDtxStatus>>(lexicalGlobalObject, IDLEnumeration<RTCDtxStatus>::extractValueFromNullable(dictionary.dtx));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "dtx"), dtxValue);
    }
    if (!IDLDictionary<RTCRtpFecParameters>::isNullValue(dictionary.fec)) {
        auto fecValue = toJS<IDLDictionary<RTCRtpFecParameters>>(lexicalGlobalObject, globalObject, IDLDictionary<RTCRtpFecParameters>::extractValueFromNullable(dictionary.fec));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "fec"), fecValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.maxBitrate)) {
        auto maxBitrateValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.maxBitrate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "maxBitrate"), maxBitrateValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.maxFramerate)) {
        auto maxFramerateValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.maxFramerate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "maxFramerate"), maxFramerateValue);
    }
    if (!IDLEnumeration<RTCPriorityType>::isNullValue(dictionary.priority)) {
        auto priorityValue = toJS<IDLEnumeration<RTCPriorityType>>(lexicalGlobalObject, IDLEnumeration<RTCPriorityType>::extractValueFromNullable(dictionary.priority));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "priority"), priorityValue);
    }
    if (!IDLDictionary<RTCRtpRtxParameters>::isNullValue(dictionary.rtx)) {
        auto rtxValue = toJS<IDLDictionary<RTCRtpRtxParameters>>(lexicalGlobalObject, globalObject, IDLDictionary<RTCRtpRtxParameters>::extractValueFromNullable(dictionary.rtx));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "rtx"), rtxValue);
    }
    auto scaleResolutionDownByValue = toJS<IDLDouble>(dictionary.scaleResolutionDownBy);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "scaleResolutionDownBy"), scaleResolutionDownByValue);
    if (!IDLUnsignedLong::isNullValue(dictionary.ssrc)) {
        auto ssrcValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.ssrc));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ssrc"), ssrcValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_RTC)
