/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCRtpReceiver.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaStreamTrack.h"
#include "JSRTCRtpCapabilities.h"
#include "JSRTCRtpContributingSource.h"
#include "JSRTCRtpParameters.h"
#include "JSRTCRtpSynchronizationSource.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsRTCRtpReceiverConstructorFunctionGetCapabilities(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCRtpReceiverPrototypeFunctionGetParameters(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCRtpReceiverPrototypeFunctionGetContributingSources(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCRtpReceiverPrototypeFunctionGetSynchronizationSources(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCRtpReceiverPrototypeFunctionGetStats(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsRTCRtpReceiverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCRtpReceiverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCRtpReceiverTrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSRTCRtpReceiverPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSRTCRtpReceiverPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRTCRtpReceiverPrototype* ptr = new (NotNull, JSC::allocateCell<JSRTCRtpReceiverPrototype>(vm.heap)) JSRTCRtpReceiverPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRTCRtpReceiverPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSRTCRtpReceiverPrototype, JSRTCRtpReceiverPrototype::Base);

using JSRTCRtpReceiverConstructor = JSDOMConstructorNotConstructable<JSRTCRtpReceiver>;

/* Hash table for constructor */

static const HashTableValue JSRTCRtpReceiverConstructorTableValues[] =
{
    { "getCapabilities", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCRtpReceiverConstructorFunctionGetCapabilities), (intptr_t) (1) } },
};

template<> JSValue JSRTCRtpReceiverConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSRTCRtpReceiverConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSRTCRtpReceiver::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("RTCRtpReceiver"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSRTCRtpReceiver::info(), JSRTCRtpReceiverConstructorTableValues, *this);
}

template<> const ClassInfo JSRTCRtpReceiverConstructor::s_info = { "RTCRtpReceiver", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCRtpReceiverConstructor) };

/* Hash table for prototype */

static const HashTableValue JSRTCRtpReceiverPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCRtpReceiverConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCRtpReceiverConstructor) } },
    { "track", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCRtpReceiverTrack), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getParameters", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCRtpReceiverPrototypeFunctionGetParameters), (intptr_t) (0) } },
    { "getContributingSources", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCRtpReceiverPrototypeFunctionGetContributingSources), (intptr_t) (0) } },
    { "getSynchronizationSources", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCRtpReceiverPrototypeFunctionGetSynchronizationSources), (intptr_t) (0) } },
    { "getStats", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCRtpReceiverPrototypeFunctionGetStats), (intptr_t) (0) } },
};

const ClassInfo JSRTCRtpReceiverPrototype::s_info = { "RTCRtpReceiverPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCRtpReceiverPrototype) };

void JSRTCRtpReceiverPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSRTCRtpReceiver::info(), JSRTCRtpReceiverPrototypeTableValues, *this);
}

const ClassInfo JSRTCRtpReceiver::s_info = { "RTCRtpReceiver", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCRtpReceiver) };

JSRTCRtpReceiver::JSRTCRtpReceiver(Structure* structure, JSDOMGlobalObject& globalObject, Ref<RTCRtpReceiver>&& impl)
    : JSDOMWrapper<RTCRtpReceiver>(structure, globalObject, WTFMove(impl))
{
}

void JSRTCRtpReceiver::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, RTCRtpReceiver>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSRTCRtpReceiver::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSRTCRtpReceiverPrototype::create(vm, &globalObject, JSRTCRtpReceiverPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSRTCRtpReceiver::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSRTCRtpReceiver>(vm, globalObject);
}

JSValue JSRTCRtpReceiver::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRTCRtpReceiverConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSRTCRtpReceiver::destroy(JSC::JSCell* cell)
{
    JSRTCRtpReceiver* thisObject = static_cast<JSRTCRtpReceiver*>(cell);
    thisObject->JSRTCRtpReceiver::~JSRTCRtpReceiver();
}

template<> inline JSRTCRtpReceiver* IDLAttribute<JSRTCRtpReceiver>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSRTCRtpReceiver*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSRTCRtpReceiver* IDLOperation<JSRTCRtpReceiver>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSRTCRtpReceiver*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsRTCRtpReceiverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCRtpReceiverPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSRTCRtpReceiver::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSRTCRtpReceiverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCRtpReceiverPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsRTCRtpReceiverTrackGetter(JSGlobalObject& lexicalGlobalObject, JSRTCRtpReceiver& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<MediaStreamTrack>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.track());
    return result;
}

EncodedJSValue jsRTCRtpReceiverTrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCRtpReceiver>::get<jsRTCRtpReceiverTrackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "track");
}

static inline JSC::EncodedJSValue jsRTCRtpReceiverConstructorFunctionGetCapabilitiesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    auto kind = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLDictionary<RTCRtpCapabilities>>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), RTCRtpReceiver::getCapabilities(*context, WTFMove(kind))));
}

EncodedJSValue JSC_HOST_CALL jsRTCRtpReceiverConstructorFunctionGetCapabilities(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCRtpReceiver>::callStatic<jsRTCRtpReceiverConstructorFunctionGetCapabilitiesBody>(*lexicalGlobalObject, *callFrame, "getCapabilities");
}

static inline JSC::EncodedJSValue jsRTCRtpReceiverPrototypeFunctionGetParametersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCRtpReceiver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDictionary<RTCRtpParameters>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getParameters()));
}

EncodedJSValue JSC_HOST_CALL jsRTCRtpReceiverPrototypeFunctionGetParameters(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCRtpReceiver>::call<jsRTCRtpReceiverPrototypeFunctionGetParametersBody>(*lexicalGlobalObject, *callFrame, "getParameters");
}

static inline JSC::EncodedJSValue jsRTCRtpReceiverPrototypeFunctionGetContributingSourcesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCRtpReceiver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLDictionary<RTCRtpContributingSource>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getContributingSources()));
}

EncodedJSValue JSC_HOST_CALL jsRTCRtpReceiverPrototypeFunctionGetContributingSources(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCRtpReceiver>::call<jsRTCRtpReceiverPrototypeFunctionGetContributingSourcesBody>(*lexicalGlobalObject, *callFrame, "getContributingSources");
}

static inline JSC::EncodedJSValue jsRTCRtpReceiverPrototypeFunctionGetSynchronizationSourcesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCRtpReceiver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLDictionary<RTCRtpSynchronizationSource>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getSynchronizationSources()));
}

EncodedJSValue JSC_HOST_CALL jsRTCRtpReceiverPrototypeFunctionGetSynchronizationSources(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCRtpReceiver>::call<jsRTCRtpReceiverPrototypeFunctionGetSynchronizationSourcesBody>(*lexicalGlobalObject, *callFrame, "getSynchronizationSources");
}

static inline JSC::EncodedJSValue jsRTCRtpReceiverPrototypeFunctionGetStatsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSRTCRtpReceiver>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.getStats(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCRtpReceiverPrototypeFunctionGetStats(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSRTCRtpReceiver>::call<jsRTCRtpReceiverPrototypeFunctionGetStatsBody>(*lexicalGlobalObject, *callFrame, "getStats");
}

void JSRTCRtpReceiver::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSRTCRtpReceiver*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSRTCRtpReceiverOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSRTCRtpReceiverOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsRTCRtpReceiver = static_cast<JSRTCRtpReceiver*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsRTCRtpReceiver->wrapped(), jsRTCRtpReceiver);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<RTCRtpReceiver>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to RTCRtpReceiver.
    static_assert(!std::is_polymorphic<RTCRtpReceiver>::value, "RTCRtpReceiver is polymorphic but the IDL claims it is not");
    return createWrapper<RTCRtpReceiver>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RTCRtpReceiver& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

RTCRtpReceiver* JSRTCRtpReceiver::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSRTCRtpReceiver*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_RTC)
