/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCRtpSender.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaStreamTrack.h"
#include "JSRTCRtpCapabilities.h"
#include "JSRTCRtpSendParameters.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(WEB_RTC)
#include "JSRTCDTMFSender.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsRTCRtpSenderConstructorFunctionGetCapabilities(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCRtpSenderPrototypeFunctionGetParameters(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCRtpSenderPrototypeFunctionSetParameters(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCRtpSenderPrototypeFunctionReplaceTrack(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCRtpSenderPrototypeFunctionGetStats(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsRTCRtpSenderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCRtpSenderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCRtpSenderTrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsRTCRtpSenderDtmf(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif

class JSRTCRtpSenderPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSRTCRtpSenderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRTCRtpSenderPrototype* ptr = new (NotNull, JSC::allocateCell<JSRTCRtpSenderPrototype>(vm.heap)) JSRTCRtpSenderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRTCRtpSenderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSRTCRtpSenderPrototype, JSRTCRtpSenderPrototype::Base);

using JSRTCRtpSenderConstructor = JSDOMConstructorNotConstructable<JSRTCRtpSender>;

/* Hash table for constructor */

static const HashTableValue JSRTCRtpSenderConstructorTableValues[] =
{
    { "getCapabilities", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCRtpSenderConstructorFunctionGetCapabilities), (intptr_t) (1) } },
};

template<> JSValue JSRTCRtpSenderConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSRTCRtpSenderConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSRTCRtpSender::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("RTCRtpSender"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSRTCRtpSender::info(), JSRTCRtpSenderConstructorTableValues, *this);
}

template<> const ClassInfo JSRTCRtpSenderConstructor::s_info = { "RTCRtpSender", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCRtpSenderConstructor) };

/* Hash table for prototype */

static const HashTableValue JSRTCRtpSenderPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCRtpSenderConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCRtpSenderConstructor) } },
    { "track", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCRtpSenderTrack), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(WEB_RTC)
    { "dtmf", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCRtpSenderDtmf), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "getParameters", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCRtpSenderPrototypeFunctionGetParameters), (intptr_t) (0) } },
    { "setParameters", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCRtpSenderPrototypeFunctionSetParameters), (intptr_t) (1) } },
    { "replaceTrack", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCRtpSenderPrototypeFunctionReplaceTrack), (intptr_t) (1) } },
    { "getStats", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCRtpSenderPrototypeFunctionGetStats), (intptr_t) (0) } },
};

const ClassInfo JSRTCRtpSenderPrototype::s_info = { "RTCRtpSenderPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCRtpSenderPrototype) };

void JSRTCRtpSenderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSRTCRtpSender::info(), JSRTCRtpSenderPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(WEB_RTC)
    if (!RuntimeEnabledFeatures::sharedFeatures().webRTCDTMFEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("dtmf"), strlen("dtmf"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSRTCRtpSender::s_info = { "RTCRtpSender", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCRtpSender) };

JSRTCRtpSender::JSRTCRtpSender(Structure* structure, JSDOMGlobalObject& globalObject, Ref<RTCRtpSender>&& impl)
    : JSDOMWrapper<RTCRtpSender>(structure, globalObject, WTFMove(impl))
{
}

void JSRTCRtpSender::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, RTCRtpSender>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSRTCRtpSender::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSRTCRtpSenderPrototype::create(vm, &globalObject, JSRTCRtpSenderPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSRTCRtpSender::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSRTCRtpSender>(vm, globalObject);
}

JSValue JSRTCRtpSender::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRTCRtpSenderConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSRTCRtpSender::destroy(JSC::JSCell* cell)
{
    JSRTCRtpSender* thisObject = static_cast<JSRTCRtpSender*>(cell);
    thisObject->JSRTCRtpSender::~JSRTCRtpSender();
}

template<> inline JSRTCRtpSender* IDLAttribute<JSRTCRtpSender>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSRTCRtpSender*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSRTCRtpSender* IDLOperation<JSRTCRtpSender>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSRTCRtpSender*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsRTCRtpSenderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCRtpSenderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSRTCRtpSender::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSRTCRtpSenderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCRtpSenderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsRTCRtpSenderTrackGetter(JSGlobalObject& lexicalGlobalObject, JSRTCRtpSender& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<MediaStreamTrack>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.track());
    return result;
}

EncodedJSValue jsRTCRtpSenderTrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCRtpSender>::get<jsRTCRtpSenderTrackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "track");
}

#if ENABLE(WEB_RTC)
static inline JSValue jsRTCRtpSenderDtmfGetter(JSGlobalObject& lexicalGlobalObject, JSRTCRtpSender& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<RTCDTMFSender>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.dtmf());
    return result;
}

EncodedJSValue jsRTCRtpSenderDtmf(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCRtpSender>::get<jsRTCRtpSenderDtmfGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "dtmf");
}

#endif

static inline JSC::EncodedJSValue jsRTCRtpSenderConstructorFunctionGetCapabilitiesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    auto kind = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLDictionary<RTCRtpCapabilities>>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), RTCRtpSender::getCapabilities(*context, WTFMove(kind))));
}

EncodedJSValue JSC_HOST_CALL jsRTCRtpSenderConstructorFunctionGetCapabilities(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCRtpSender>::callStatic<jsRTCRtpSenderConstructorFunctionGetCapabilitiesBody>(*lexicalGlobalObject, *callFrame, "getCapabilities");
}

static inline JSC::EncodedJSValue jsRTCRtpSenderPrototypeFunctionGetParametersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCRtpSender>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDictionary<RTCRtpSendParameters>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getParameters()));
}

EncodedJSValue JSC_HOST_CALL jsRTCRtpSenderPrototypeFunctionGetParameters(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCRtpSender>::call<jsRTCRtpSenderPrototypeFunctionGetParametersBody>(*lexicalGlobalObject, *callFrame, "getParameters");
}

static inline JSC::EncodedJSValue jsRTCRtpSenderPrototypeFunctionSetParametersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSRTCRtpSender>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto parameters = convert<IDLDictionary<RTCRtpSendParameters>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setParameters(WTFMove(parameters), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCRtpSenderPrototypeFunctionSetParameters(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSRTCRtpSender>::call<jsRTCRtpSenderPrototypeFunctionSetParametersBody>(*lexicalGlobalObject, *callFrame, "setParameters");
}

static inline JSC::EncodedJSValue jsRTCRtpSenderPrototypeFunctionReplaceTrackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSRTCRtpSender>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    auto withTrack = convert<IDLNullable<IDLInterface<MediaStreamTrack>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "withTrack", "RTCRtpSender", "replaceTrack", "MediaStreamTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.replaceTrack(*context, WTFMove(withTrack), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCRtpSenderPrototypeFunctionReplaceTrack(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSRTCRtpSender>::call<jsRTCRtpSenderPrototypeFunctionReplaceTrackBody>(*lexicalGlobalObject, *callFrame, "replaceTrack");
}

static inline JSC::EncodedJSValue jsRTCRtpSenderPrototypeFunctionGetStatsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSRTCRtpSender>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.getStats(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCRtpSenderPrototypeFunctionGetStats(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSRTCRtpSender>::call<jsRTCRtpSenderPrototypeFunctionGetStatsBody>(*lexicalGlobalObject, *callFrame, "getStats");
}

void JSRTCRtpSender::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSRTCRtpSender*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSRTCRtpSenderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSRTCRtpSenderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsRTCRtpSender = static_cast<JSRTCRtpSender*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsRTCRtpSender->wrapped(), jsRTCRtpSender);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<RTCRtpSender>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to RTCRtpSender.
    static_assert(!std::is_polymorphic<RTCRtpSender>::value, "RTCRtpSender is polymorphic but the IDL claims it is not");
    return createWrapper<RTCRtpSender>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RTCRtpSender& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

RTCRtpSender* JSRTCRtpSender::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSRTCRtpSender*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_RTC)
