/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCRtpTransceiver.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSRTCRtpCodecCapability.h"
#include "JSRTCRtpReceiver.h"
#include "JSRTCRtpSender.h"
#include "JSRTCRtpTransceiverDirection.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsRTCRtpTransceiverPrototypeFunctionStop(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsRTCRtpTransceiverPrototypeFunctionSetCodecPreferences(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsRTCRtpTransceiverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCRtpTransceiverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCRtpTransceiverMid(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCRtpTransceiverSender(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCRtpTransceiverReceiver(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCRtpTransceiverStopped(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRTCRtpTransceiverDirection(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSRTCRtpTransceiverDirection(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsRTCRtpTransceiverCurrentDirection(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSRTCRtpTransceiverPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSRTCRtpTransceiverPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRTCRtpTransceiverPrototype* ptr = new (NotNull, JSC::allocateCell<JSRTCRtpTransceiverPrototype>(vm.heap)) JSRTCRtpTransceiverPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRTCRtpTransceiverPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSRTCRtpTransceiverPrototype, JSRTCRtpTransceiverPrototype::Base);

using JSRTCRtpTransceiverConstructor = JSDOMConstructorNotConstructable<JSRTCRtpTransceiver>;

template<> JSValue JSRTCRtpTransceiverConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSRTCRtpTransceiverConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSRTCRtpTransceiver::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("RTCRtpTransceiver"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSRTCRtpTransceiverConstructor::s_info = { "RTCRtpTransceiver", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCRtpTransceiverConstructor) };

/* Hash table for prototype */

static const HashTableValue JSRTCRtpTransceiverPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCRtpTransceiverConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCRtpTransceiverConstructor) } },
    { "mid", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCRtpTransceiverMid), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "sender", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCRtpTransceiverSender), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "receiver", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCRtpTransceiverReceiver), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "stopped", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCRtpTransceiverStopped), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "direction", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCRtpTransceiverDirection), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRTCRtpTransceiverDirection) } },
    { "currentDirection", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRTCRtpTransceiverCurrentDirection), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "stop", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCRtpTransceiverPrototypeFunctionStop), (intptr_t) (0) } },
    { "setCodecPreferences", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsRTCRtpTransceiverPrototypeFunctionSetCodecPreferences), (intptr_t) (1) } },
};

const ClassInfo JSRTCRtpTransceiverPrototype::s_info = { "RTCRtpTransceiverPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCRtpTransceiverPrototype) };

void JSRTCRtpTransceiverPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSRTCRtpTransceiver::info(), JSRTCRtpTransceiverPrototypeTableValues, *this);
}

const ClassInfo JSRTCRtpTransceiver::s_info = { "RTCRtpTransceiver", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSRTCRtpTransceiver) };

JSRTCRtpTransceiver::JSRTCRtpTransceiver(Structure* structure, JSDOMGlobalObject& globalObject, Ref<RTCRtpTransceiver>&& impl)
    : JSDOMWrapper<RTCRtpTransceiver>(structure, globalObject, WTFMove(impl))
{
}

void JSRTCRtpTransceiver::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, RTCRtpTransceiver>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSRTCRtpTransceiver::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSRTCRtpTransceiverPrototype::create(vm, &globalObject, JSRTCRtpTransceiverPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSRTCRtpTransceiver::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSRTCRtpTransceiver>(vm, globalObject);
}

JSValue JSRTCRtpTransceiver::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRTCRtpTransceiverConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSRTCRtpTransceiver::destroy(JSC::JSCell* cell)
{
    JSRTCRtpTransceiver* thisObject = static_cast<JSRTCRtpTransceiver*>(cell);
    thisObject->JSRTCRtpTransceiver::~JSRTCRtpTransceiver();
}

template<> inline JSRTCRtpTransceiver* IDLAttribute<JSRTCRtpTransceiver>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSRTCRtpTransceiver*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSRTCRtpTransceiver* IDLOperation<JSRTCRtpTransceiver>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSRTCRtpTransceiver*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsRTCRtpTransceiverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCRtpTransceiverPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSRTCRtpTransceiver::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSRTCRtpTransceiverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSRTCRtpTransceiverPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsRTCRtpTransceiverMidGetter(JSGlobalObject& lexicalGlobalObject, JSRTCRtpTransceiver& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.mid());
    return result;
}

EncodedJSValue jsRTCRtpTransceiverMid(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCRtpTransceiver>::get<jsRTCRtpTransceiverMidGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "mid");
}

static inline JSValue jsRTCRtpTransceiverSenderGetter(JSGlobalObject& lexicalGlobalObject, JSRTCRtpTransceiver& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<RTCRtpSender>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.sender());
    return result;
}

EncodedJSValue jsRTCRtpTransceiverSender(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCRtpTransceiver>::get<jsRTCRtpTransceiverSenderGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "sender");
}

static inline JSValue jsRTCRtpTransceiverReceiverGetter(JSGlobalObject& lexicalGlobalObject, JSRTCRtpTransceiver& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<RTCRtpReceiver>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.receiver());
    return result;
}

EncodedJSValue jsRTCRtpTransceiverReceiver(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCRtpTransceiver>::get<jsRTCRtpTransceiverReceiverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "receiver");
}

static inline JSValue jsRTCRtpTransceiverStoppedGetter(JSGlobalObject& lexicalGlobalObject, JSRTCRtpTransceiver& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.stopped());
    return result;
}

EncodedJSValue jsRTCRtpTransceiverStopped(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCRtpTransceiver>::get<jsRTCRtpTransceiverStoppedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "stopped");
}

static inline JSValue jsRTCRtpTransceiverDirectionGetter(JSGlobalObject& lexicalGlobalObject, JSRTCRtpTransceiver& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<RTCRtpTransceiverDirection>>(lexicalGlobalObject, throwScope, impl.direction());
    return result;
}

EncodedJSValue jsRTCRtpTransceiverDirection(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCRtpTransceiver>::get<jsRTCRtpTransceiverDirectionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "direction");
}

static inline bool setJSRTCRtpTransceiverDirectionSetter(JSGlobalObject& lexicalGlobalObject, JSRTCRtpTransceiver& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<RTCRtpTransceiverDirection>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDirection(WTFMove(nativeValue));
    });
    return true;
}

bool setJSRTCRtpTransceiverDirection(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSRTCRtpTransceiver>::set<setJSRTCRtpTransceiverDirectionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "direction");
}

static inline JSValue jsRTCRtpTransceiverCurrentDirectionGetter(JSGlobalObject& lexicalGlobalObject, JSRTCRtpTransceiver& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLEnumeration<RTCRtpTransceiverDirection>>>(lexicalGlobalObject, throwScope, impl.currentDirection());
    return result;
}

EncodedJSValue jsRTCRtpTransceiverCurrentDirection(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSRTCRtpTransceiver>::get<jsRTCRtpTransceiverCurrentDirectionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentDirection");
}

static inline JSC::EncodedJSValue jsRTCRtpTransceiverPrototypeFunctionStopBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCRtpTransceiver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.stop();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCRtpTransceiverPrototypeFunctionStop(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCRtpTransceiver>::call<jsRTCRtpTransceiverPrototypeFunctionStopBody>(*lexicalGlobalObject, *callFrame, "stop");
}

static inline JSC::EncodedJSValue jsRTCRtpTransceiverPrototypeFunctionSetCodecPreferencesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSRTCRtpTransceiver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto codecs = convert<IDLSequence<IDLDictionary<RTCRtpCodecCapability>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setCodecPreferences(WTFMove(codecs));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRTCRtpTransceiverPrototypeFunctionSetCodecPreferences(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSRTCRtpTransceiver>::call<jsRTCRtpTransceiverPrototypeFunctionSetCodecPreferencesBody>(*lexicalGlobalObject, *callFrame, "setCodecPreferences");
}

void JSRTCRtpTransceiver::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSRTCRtpTransceiver*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSRTCRtpTransceiverOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSRTCRtpTransceiverOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsRTCRtpTransceiver = static_cast<JSRTCRtpTransceiver*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsRTCRtpTransceiver->wrapped(), jsRTCRtpTransceiver);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7RTCRtpTransceiver@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17RTCRtpTransceiverE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<RTCRtpTransceiver>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7RTCRtpTransceiver@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore17RTCRtpTransceiverE[2];
#endif

    // If this fails RTCRtpTransceiver does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<RTCRtpTransceiver>::value, "RTCRtpTransceiver is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // RTCRtpTransceiver has subclasses. If RTCRtpTransceiver has subclasses that get passed
    // to toJS() we currently require RTCRtpTransceiver you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<RTCRtpTransceiver>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RTCRtpTransceiver& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

RTCRtpTransceiver* JSRTCRtpTransceiver::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSRTCRtpTransceiver*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_RTC)
