/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_RTC)

#include "JSRTCRtpTransceiverDirection.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(RTCRtpTransceiverDirection enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("sendrecv"),
        MAKE_STATIC_STRING_IMPL("sendonly"),
        MAKE_STATIC_STRING_IMPL("recvonly"),
        MAKE_STATIC_STRING_IMPL("inactive"),
    };
    static_assert(static_cast<size_t>(RTCRtpTransceiverDirection::Sendrecv) == 0, "RTCRtpTransceiverDirection::Sendrecv is not 0 as expected");
    static_assert(static_cast<size_t>(RTCRtpTransceiverDirection::Sendonly) == 1, "RTCRtpTransceiverDirection::Sendonly is not 1 as expected");
    static_assert(static_cast<size_t>(RTCRtpTransceiverDirection::Recvonly) == 2, "RTCRtpTransceiverDirection::Recvonly is not 2 as expected");
    static_assert(static_cast<size_t>(RTCRtpTransceiverDirection::Inactive) == 3, "RTCRtpTransceiverDirection::Inactive is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, RTCRtpTransceiverDirection enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<RTCRtpTransceiverDirection> parseEnumeration<RTCRtpTransceiverDirection>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "sendrecv")
        return RTCRtpTransceiverDirection::Sendrecv;
    if (stringValue == "sendonly")
        return RTCRtpTransceiverDirection::Sendonly;
    if (stringValue == "recvonly")
        return RTCRtpTransceiverDirection::Recvonly;
    if (stringValue == "inactive")
        return RTCRtpTransceiverDirection::Inactive;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<RTCRtpTransceiverDirection>()
{
    return "\"sendrecv\", \"sendonly\", \"recvonly\", \"inactive\"";
}

} // namespace WebCore

#endif // ENABLE(WEB_RTC)
