/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(WEB_RTC)

#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "RTCStatsReport.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSRTCStatsReport : public JSDOMWrapper<RTCStatsReport> {
public:
    using Base = JSDOMWrapper<RTCStatsReport>;
    static JSRTCStatsReport* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<RTCStatsReport>&& impl)
    {
        JSRTCStatsReport* ptr = new (NotNull, JSC::allocateCell<JSRTCStatsReport>(globalObject->vm().heap)) JSRTCStatsReport(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static RTCStatsReport* toWrapped(JSC::VM&, JSC::JSValue);
    static void destroy(JSC::JSCell*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
protected:
    JSRTCStatsReport(JSC::Structure*, JSDOMGlobalObject&, Ref<RTCStatsReport>&&);

    void finishCreation(JSC::VM&);
};

class JSRTCStatsReportOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, RTCStatsReport*)
{
    static NeverDestroyed<JSRTCStatsReportOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(RTCStatsReport* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, RTCStatsReport&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RTCStatsReport* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<RTCStatsReport>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<RTCStatsReport>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<RTCStatsReport> {
    using WrapperClass = JSRTCStatsReport;
    using ToWrappedReturnType = RTCStatsReport*;
};
String convertEnumerationToString(RTCStatsReport::Type);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, RTCStatsReport::Type);

template<> Optional<RTCStatsReport::Type> parseEnumeration<RTCStatsReport::Type>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<RTCStatsReport::Type>();

String convertEnumerationToString(RTCStatsReport::IceCandidatePairState);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, RTCStatsReport::IceCandidatePairState);

template<> Optional<RTCStatsReport::IceCandidatePairState> parseEnumeration<RTCStatsReport::IceCandidatePairState>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<RTCStatsReport::IceCandidatePairState>();

String convertEnumerationToString(RTCStatsReport::IceCandidateType);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, RTCStatsReport::IceCandidateType);

template<> Optional<RTCStatsReport::IceCandidateType> parseEnumeration<RTCStatsReport::IceCandidateType>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<RTCStatsReport::IceCandidateType>();

String convertEnumerationToString(RTCStatsReport::CodecType);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, RTCStatsReport::CodecType);

template<> Optional<RTCStatsReport::CodecType> parseEnumeration<RTCStatsReport::CodecType>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<RTCStatsReport::CodecType>();

template<> RTCStatsReport::Stats convertDictionary<RTCStatsReport::Stats>(JSC::JSGlobalObject&, JSC::JSValue);

template<> RTCStatsReport::RTCRTPStreamStats convertDictionary<RTCStatsReport::RTCRTPStreamStats>(JSC::JSGlobalObject&, JSC::JSValue);

template<> RTCStatsReport::InboundRTPStreamStats convertDictionary<RTCStatsReport::InboundRTPStreamStats>(JSC::JSGlobalObject&, JSC::JSValue);

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const RTCStatsReport::InboundRTPStreamStats&);

template<> RTCStatsReport::OutboundRTPStreamStats convertDictionary<RTCStatsReport::OutboundRTPStreamStats>(JSC::JSGlobalObject&, JSC::JSValue);

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const RTCStatsReport::OutboundRTPStreamStats&);

template<> RTCStatsReport::MediaStreamTrackStats convertDictionary<RTCStatsReport::MediaStreamTrackStats>(JSC::JSGlobalObject&, JSC::JSValue);

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const RTCStatsReport::MediaStreamTrackStats&);

template<> RTCStatsReport::DataChannelStats convertDictionary<RTCStatsReport::DataChannelStats>(JSC::JSGlobalObject&, JSC::JSValue);

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const RTCStatsReport::DataChannelStats&);

template<> RTCStatsReport::IceCandidatePairStats convertDictionary<RTCStatsReport::IceCandidatePairStats>(JSC::JSGlobalObject&, JSC::JSValue);

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const RTCStatsReport::IceCandidatePairStats&);

template<> RTCStatsReport::IceCandidateStats convertDictionary<RTCStatsReport::IceCandidateStats>(JSC::JSGlobalObject&, JSC::JSValue);

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const RTCStatsReport::IceCandidateStats&);

template<> RTCStatsReport::CertificateStats convertDictionary<RTCStatsReport::CertificateStats>(JSC::JSGlobalObject&, JSC::JSValue);

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const RTCStatsReport::CertificateStats&);

template<> RTCStatsReport::CodecStats convertDictionary<RTCStatsReport::CodecStats>(JSC::JSGlobalObject&, JSC::JSValue);

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const RTCStatsReport::CodecStats&);

template<> RTCStatsReport::TransportStats convertDictionary<RTCStatsReport::TransportStats>(JSC::JSGlobalObject&, JSC::JSValue);

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const RTCStatsReport::TransportStats&);

template<> RTCStatsReport::PeerConnectionStats convertDictionary<RTCStatsReport::PeerConnectionStats>(JSC::JSGlobalObject&, JSC::JSValue);

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const RTCStatsReport::PeerConnectionStats&);


} // namespace WebCore

#endif // ENABLE(WEB_RTC)
