/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(STREAMS_API)

#include "JSDOMWrapper.h"
#include "ReadableStreamSource.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSReadableStreamSource : public JSDOMWrapper<ReadableStreamSource> {
public:
    using Base = JSDOMWrapper<ReadableStreamSource>;
    static JSReadableStreamSource* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<ReadableStreamSource>&& impl)
    {
        JSReadableStreamSource* ptr = new (NotNull, JSC::allocateCell<JSReadableStreamSource>(globalObject->vm().heap)) JSReadableStreamSource(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static ReadableStreamSource* toWrapped(JSC::VM&, JSC::JSValue);
    static void destroy(JSC::JSCell*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    mutable JSC::WriteBarrier<JSC::Unknown> m_controller;
    static void visitChildren(JSCell*, JSC::SlotVisitor&);

    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);

    // Custom attributes
    JSC::JSValue controller(JSC::JSGlobalObject&) const;

    // Custom functions
    JSC::JSValue start(JSC::JSGlobalObject&, JSC::CallFrame&, Ref<DeferredPromise>&&);
    JSC::JSValue pull(JSC::JSGlobalObject&, JSC::CallFrame&, Ref<DeferredPromise>&&);
protected:
    JSReadableStreamSource(JSC::Structure*, JSDOMGlobalObject&, Ref<ReadableStreamSource>&&);

    void finishCreation(JSC::VM&);
};

class JSReadableStreamSourceOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, ReadableStreamSource*)
{
    static NeverDestroyed<JSReadableStreamSourceOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(ReadableStreamSource* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, ReadableStreamSource&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ReadableStreamSource* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<ReadableStreamSource>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<ReadableStreamSource>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<ReadableStreamSource> {
    using WrapperClass = JSReadableStreamSource;
    using ToWrappedReturnType = ReadableStreamSource*;
};

} // namespace WebCore

#endif // ENABLE(STREAMS_API)
