/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(RESIZE_OBSERVER)

#include "JSResizeObserver.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(RESIZE_OBSERVER)
#include "JSDOMConvertCallbacks.h"
#include "JSDOMGlobalObject.h"
#include "JSResizeObserverCallback.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsResizeObserverPrototypeFunctionObserve(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsResizeObserverPrototypeFunctionUnobserve(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsResizeObserverPrototypeFunctionDisconnect(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsResizeObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSResizeObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSResizeObserverPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSResizeObserverPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSResizeObserverPrototype* ptr = new (NotNull, JSC::allocateCell<JSResizeObserverPrototype>(vm.heap)) JSResizeObserverPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSResizeObserverPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSResizeObserverPrototype, JSResizeObserverPrototype::Base);

using JSResizeObserverConstructor = JSDOMConstructor<JSResizeObserver>;

template<> EncodedJSValue JSC_HOST_CALL JSResizeObserverConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSResizeObserverConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "ResizeObserver");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto callback = convert<IDLCallbackFunction<JSResizeObserverCallback>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback", "ResizeObserver", nullptr); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = ResizeObserver::create(document, callback.releaseNonNull());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<ResizeObserver>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSResizeObserverConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSResizeObserverConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSResizeObserver::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("ResizeObserver"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSResizeObserverConstructor::s_info = { "ResizeObserver", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSResizeObserverConstructor) };

/* Hash table for prototype */

static const HashTableValue JSResizeObserverPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsResizeObserverConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSResizeObserverConstructor) } },
    { "observe", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsResizeObserverPrototypeFunctionObserve), (intptr_t) (1) } },
    { "unobserve", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsResizeObserverPrototypeFunctionUnobserve), (intptr_t) (1) } },
    { "disconnect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsResizeObserverPrototypeFunctionDisconnect), (intptr_t) (0) } },
};

const ClassInfo JSResizeObserverPrototype::s_info = { "ResizeObserverPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSResizeObserverPrototype) };

void JSResizeObserverPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSResizeObserver::info(), JSResizeObserverPrototypeTableValues, *this);
}

const ClassInfo JSResizeObserver::s_info = { "ResizeObserver", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSResizeObserver) };

JSResizeObserver::JSResizeObserver(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ResizeObserver>&& impl)
    : JSDOMWrapper<ResizeObserver>(structure, globalObject, WTFMove(impl))
{
}

void JSResizeObserver::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, ResizeObserver>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSResizeObserver::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSResizeObserverPrototype::create(vm, &globalObject, JSResizeObserverPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSResizeObserver::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSResizeObserver>(vm, globalObject);
}

JSValue JSResizeObserver::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSResizeObserverConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSResizeObserver::destroy(JSC::JSCell* cell)
{
    JSResizeObserver* thisObject = static_cast<JSResizeObserver*>(cell);
    thisObject->JSResizeObserver::~JSResizeObserver();
}

template<> inline JSResizeObserver* IDLOperation<JSResizeObserver>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSResizeObserver*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsResizeObserverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSResizeObserverPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSResizeObserver::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSResizeObserverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSResizeObserverPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsResizeObserverPrototypeFunctionObserveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSResizeObserver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target", "ResizeObserver", "observe", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.observe(*target);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsResizeObserverPrototypeFunctionObserve(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSResizeObserver>::call<jsResizeObserverPrototypeFunctionObserveBody>(*lexicalGlobalObject, *callFrame, "observe");
}

static inline JSC::EncodedJSValue jsResizeObserverPrototypeFunctionUnobserveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSResizeObserver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target", "ResizeObserver", "unobserve", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.unobserve(*target);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsResizeObserverPrototypeFunctionUnobserve(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSResizeObserver>::call<jsResizeObserverPrototypeFunctionUnobserveBody>(*lexicalGlobalObject, *callFrame, "unobserve");
}

static inline JSC::EncodedJSValue jsResizeObserverPrototypeFunctionDisconnectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSResizeObserver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.disconnect();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsResizeObserverPrototypeFunctionDisconnect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSResizeObserver>::call<jsResizeObserverPrototypeFunctionDisconnectBody>(*lexicalGlobalObject, *callFrame, "disconnect");
}

void JSResizeObserver::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSResizeObserver*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSResizeObserverOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsResizeObserver = jsCast<JSResizeObserver*>(handle.slot()->asCell());
    if (jsResizeObserver->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSResizeObserverOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsResizeObserver = static_cast<JSResizeObserver*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsResizeObserver->wrapped(), jsResizeObserver);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ResizeObserver@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14ResizeObserverE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ResizeObserver>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7ResizeObserver@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14ResizeObserverE[2];
#endif

    // If this fails ResizeObserver does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<ResizeObserver>::value, "ResizeObserver is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // ResizeObserver has subclasses. If ResizeObserver has subclasses that get passed
    // to toJS() we currently require ResizeObserver you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<ResizeObserver>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ResizeObserver& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ResizeObserver* JSResizeObserver::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSResizeObserver*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(RESIZE_OBSERVER)
