/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(RESIZE_OBSERVER)

#include "JSResizeObserverEntry.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMRectReadOnly.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsResizeObserverEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSResizeObserverEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsResizeObserverEntryTarget(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsResizeObserverEntryContentRect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSResizeObserverEntryPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSResizeObserverEntryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSResizeObserverEntryPrototype* ptr = new (NotNull, JSC::allocateCell<JSResizeObserverEntryPrototype>(vm.heap)) JSResizeObserverEntryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSResizeObserverEntryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSResizeObserverEntryPrototype, JSResizeObserverEntryPrototype::Base);

using JSResizeObserverEntryConstructor = JSDOMConstructorNotConstructable<JSResizeObserverEntry>;

template<> JSValue JSResizeObserverEntryConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSResizeObserverEntryConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSResizeObserverEntry::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("ResizeObserverEntry"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSResizeObserverEntryConstructor::s_info = { "ResizeObserverEntry", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSResizeObserverEntryConstructor) };

/* Hash table for prototype */

static const HashTableValue JSResizeObserverEntryPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsResizeObserverEntryConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSResizeObserverEntryConstructor) } },
    { "target", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsResizeObserverEntryTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "contentRect", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsResizeObserverEntryContentRect), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSResizeObserverEntryPrototype::s_info = { "ResizeObserverEntryPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSResizeObserverEntryPrototype) };

void JSResizeObserverEntryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSResizeObserverEntry::info(), JSResizeObserverEntryPrototypeTableValues, *this);
}

const ClassInfo JSResizeObserverEntry::s_info = { "ResizeObserverEntry", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSResizeObserverEntry) };

JSResizeObserverEntry::JSResizeObserverEntry(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ResizeObserverEntry>&& impl)
    : JSDOMWrapper<ResizeObserverEntry>(structure, globalObject, WTFMove(impl))
{
}

void JSResizeObserverEntry::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, ResizeObserverEntry>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSResizeObserverEntry::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSResizeObserverEntryPrototype::create(vm, &globalObject, JSResizeObserverEntryPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSResizeObserverEntry::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSResizeObserverEntry>(vm, globalObject);
}

JSValue JSResizeObserverEntry::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSResizeObserverEntryConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSResizeObserverEntry::destroy(JSC::JSCell* cell)
{
    JSResizeObserverEntry* thisObject = static_cast<JSResizeObserverEntry*>(cell);
    thisObject->JSResizeObserverEntry::~JSResizeObserverEntry();
}

template<> inline JSResizeObserverEntry* IDLAttribute<JSResizeObserverEntry>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSResizeObserverEntry*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsResizeObserverEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSResizeObserverEntryPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSResizeObserverEntry::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSResizeObserverEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSResizeObserverEntryPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsResizeObserverEntryTargetGetter(JSGlobalObject& lexicalGlobalObject, JSResizeObserverEntry& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Element>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.target());
    return result;
}

EncodedJSValue jsResizeObserverEntryTarget(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSResizeObserverEntry>::get<jsResizeObserverEntryTargetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "target");
}

static inline JSValue jsResizeObserverEntryContentRectGetter(JSGlobalObject& lexicalGlobalObject, JSResizeObserverEntry& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMRectReadOnly>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.contentRect());
    return result;
}

EncodedJSValue jsResizeObserverEntryContentRect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSResizeObserverEntry>::get<jsResizeObserverEntryContentRectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "contentRect");
}

void JSResizeObserverEntry::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSResizeObserverEntry*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSResizeObserverEntry::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSResizeObserverEntry*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSResizeObserverEntry::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSResizeObserverEntry*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSResizeObserverEntryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSResizeObserverEntryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsResizeObserverEntry = static_cast<JSResizeObserverEntry*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsResizeObserverEntry->wrapped(), jsResizeObserverEntry);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ResizeObserverEntry>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to ResizeObserverEntry.
    static_assert(!std::is_polymorphic<ResizeObserverEntry>::value, "ResizeObserverEntry is polymorphic but the IDL claims it is not");
    return createWrapper<ResizeObserverEntry>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ResizeObserverEntry& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ResizeObserverEntry* JSResizeObserverEntry::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSResizeObserverEntry*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(RESIZE_OBSERVER)
