/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSQLResultSetRowList.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/Vector.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSQLResultSetRowListPrototypeFunctionItem(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsSQLResultSetRowListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSQLResultSetRowListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSQLResultSetRowListLength(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSSQLResultSetRowListPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSQLResultSetRowListPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSQLResultSetRowListPrototype* ptr = new (NotNull, JSC::allocateCell<JSSQLResultSetRowListPrototype>(vm.heap)) JSSQLResultSetRowListPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSQLResultSetRowListPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSQLResultSetRowListPrototype, JSSQLResultSetRowListPrototype::Base);

using JSSQLResultSetRowListConstructor = JSDOMConstructorNotConstructable<JSSQLResultSetRowList>;

template<> JSValue JSSQLResultSetRowListConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSQLResultSetRowListConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSQLResultSetRowList::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SQLResultSetRowList"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSSQLResultSetRowListConstructor::s_info = { "SQLResultSetRowList", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLResultSetRowListConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSQLResultSetRowListPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLResultSetRowListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSQLResultSetRowListConstructor) } },
    { "length", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLResultSetRowListLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "item", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsSQLResultSetRowListPrototypeFunctionItem), (intptr_t) (1) } },
};

const ClassInfo JSSQLResultSetRowListPrototype::s_info = { "SQLResultSetRowListPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLResultSetRowListPrototype) };

void JSSQLResultSetRowListPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSQLResultSetRowList::info(), JSSQLResultSetRowListPrototypeTableValues, *this);
}

const ClassInfo JSSQLResultSetRowList::s_info = { "SQLResultSetRowList", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLResultSetRowList) };

JSSQLResultSetRowList::JSSQLResultSetRowList(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SQLResultSetRowList>&& impl)
    : JSDOMWrapper<SQLResultSetRowList>(structure, globalObject, WTFMove(impl))
{
}

void JSSQLResultSetRowList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SQLResultSetRowList>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSQLResultSetRowList::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSQLResultSetRowListPrototype::create(vm, &globalObject, JSSQLResultSetRowListPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSSQLResultSetRowList::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSQLResultSetRowList>(vm, globalObject);
}

JSValue JSSQLResultSetRowList::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSQLResultSetRowListConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSQLResultSetRowList::destroy(JSC::JSCell* cell)
{
    JSSQLResultSetRowList* thisObject = static_cast<JSSQLResultSetRowList*>(cell);
    thisObject->JSSQLResultSetRowList::~JSSQLResultSetRowList();
}

template<> inline JSSQLResultSetRowList* IDLAttribute<JSSQLResultSetRowList>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSQLResultSetRowList*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSSQLResultSetRowList* IDLOperation<JSSQLResultSetRowList>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSSQLResultSetRowList*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsSQLResultSetRowListConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSQLResultSetRowListPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSQLResultSetRowList::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSQLResultSetRowListConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSQLResultSetRowListPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSQLResultSetRowListLengthGetter(JSGlobalObject& lexicalGlobalObject, JSSQLResultSetRowList& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.length());
    return result;
}

EncodedJSValue jsSQLResultSetRowListLength(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSQLResultSetRowList>::get<jsSQLResultSetRowListLengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "length");
}

static inline JSC::EncodedJSValue jsSQLResultSetRowListPrototypeFunctionItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSQLResultSetRowList>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLRecord<IDLDOMString, IDLUnion<IDLNull, IDLDOMString, IDLUnrestrictedDouble>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.item(WTFMove(index))));
}

EncodedJSValue JSC_HOST_CALL jsSQLResultSetRowListPrototypeFunctionItem(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSSQLResultSetRowList>::call<jsSQLResultSetRowListPrototypeFunctionItemBody>(*lexicalGlobalObject, *callFrame, "item");
}

void JSSQLResultSetRowList::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSQLResultSetRowList*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSQLResultSetRowListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSQLResultSetRowListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSQLResultSetRowList = static_cast<JSSQLResultSetRowList*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSQLResultSetRowList->wrapped(), jsSQLResultSetRowList);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SQLResultSetRowList>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to SQLResultSetRowList.
    static_assert(!std::is_polymorphic<SQLResultSetRowList>::value, "SQLResultSetRowList is polymorphic but the IDL claims it is not");
    return createWrapper<SQLResultSetRowList>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SQLResultSetRowList& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SQLResultSetRowList* JSSQLResultSetRowList::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSQLResultSetRowList*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
