/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSQLStatementErrorCallback.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSSQLError.h"
#include "JSSQLTransaction.h"
#include "ScriptExecutionContext.h"


namespace WebCore {
using namespace JSC;

JSSQLStatementErrorCallback::JSSQLStatementErrorCallback(JSObject* callback, JSDOMGlobalObject* globalObject)
    : SQLStatementErrorCallback(globalObject->scriptExecutionContext())
    , m_data(new JSCallbackDataStrong(callback, globalObject, this))
{
}

JSSQLStatementErrorCallback::~JSSQLStatementErrorCallback()
{
    ScriptExecutionContext* context = scriptExecutionContext();
    // When the context is destroyed, all tasks with a reference to a callback
    // should be deleted. So if the context is 0, we are on the context thread.
    if (!context || context->isContextThread())
        delete m_data;
    else
        context->postTask(DeleteCallbackDataTask(m_data));
#ifndef NDEBUG
    m_data = nullptr;
#endif
}

CallbackResult<typename IDLBoolean::ImplementationType> JSSQLStatementErrorCallback::handleEvent(typename IDLInterface<SQLTransaction>::ParameterType transaction, typename IDLInterface<SQLError>::ParameterType error)
{
    if (!canInvokeCallback())
        return CallbackResultType::UnableToExecute;

    Ref<JSSQLStatementErrorCallback> protectedThis(*this);

    auto& globalObject = *m_data->globalObject();
    auto& vm = globalObject.vm();

    JSLockHolder lock(vm);
    auto& lexicalGlobalObject = globalObject;
    JSValue thisValue = jsUndefined();
    MarkedArgumentBuffer args;
    args.append(toJS<IDLInterface<SQLTransaction>>(lexicalGlobalObject, globalObject, transaction));
    args.append(toJS<IDLInterface<SQLError>>(lexicalGlobalObject, globalObject, error));
    ASSERT(!args.hasOverflowed());

    NakedPtr<JSC::Exception> returnedException;
    auto jsResult = m_data->invokeCallback(thisValue, args, JSCallbackData::CallbackType::Function, Identifier(), returnedException);
    if (returnedException) {
        reportException(&lexicalGlobalObject, returnedException);
        return CallbackResultType::ExceptionThrown;
     }

    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto returnValue = convert<IDLBoolean>(lexicalGlobalObject, jsResult);
    RETURN_IF_EXCEPTION(throwScope, CallbackResultType::ExceptionThrown);
    return returnValue;
}

JSC::JSValue toJS(SQLStatementErrorCallback& impl)
{
    if (!static_cast<JSSQLStatementErrorCallback&>(impl).callbackData())
        return jsNull();

    return static_cast<JSSQLStatementErrorCallback&>(impl).callbackData()->callback();
}

} // namespace WebCore
