/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSQLTransaction.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSSQLStatementCallback.h"
#include "JSSQLStatementErrorCallback.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSQLTransactionPrototypeFunctionExecuteSql(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsSQLTransactionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSQLTransactionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSQLTransactionPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSQLTransactionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSQLTransactionPrototype* ptr = new (NotNull, JSC::allocateCell<JSSQLTransactionPrototype>(vm.heap)) JSSQLTransactionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSQLTransactionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSQLTransactionPrototype, JSSQLTransactionPrototype::Base);

using JSSQLTransactionConstructor = JSDOMConstructorNotConstructable<JSSQLTransaction>;

template<> JSValue JSSQLTransactionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSQLTransactionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSQLTransaction::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SQLTransaction"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSSQLTransactionConstructor::s_info = { "SQLTransaction", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLTransactionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSQLTransactionPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLTransactionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSQLTransactionConstructor) } },
    { "executeSql", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsSQLTransactionPrototypeFunctionExecuteSql), (intptr_t) (1) } },
};

const ClassInfo JSSQLTransactionPrototype::s_info = { "SQLTransactionPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLTransactionPrototype) };

void JSSQLTransactionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSQLTransaction::info(), JSSQLTransactionPrototypeTableValues, *this);
}

const ClassInfo JSSQLTransaction::s_info = { "SQLTransaction", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLTransaction) };

JSSQLTransaction::JSSQLTransaction(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SQLTransaction>&& impl)
    : JSDOMWrapper<SQLTransaction>(structure, globalObject, WTFMove(impl))
{
}

void JSSQLTransaction::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SQLTransaction>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSQLTransaction::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSQLTransactionPrototype::create(vm, &globalObject, JSSQLTransactionPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSSQLTransaction::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSQLTransaction>(vm, globalObject);
}

JSValue JSSQLTransaction::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSQLTransactionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSQLTransaction::destroy(JSC::JSCell* cell)
{
    JSSQLTransaction* thisObject = static_cast<JSSQLTransaction*>(cell);
    thisObject->JSSQLTransaction::~JSSQLTransaction();
}

template<> inline JSSQLTransaction* IDLOperation<JSSQLTransaction>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSSQLTransaction*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsSQLTransactionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSQLTransactionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSQLTransaction::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSQLTransactionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSQLTransactionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsSQLTransactionPrototypeFunctionExecuteSqlBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSQLTransaction>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sqlStatement = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto arguments = callFrame->argument(1).isUndefined() ? Converter<IDLNullable<IDLSequence<IDLUnion<IDLNull, IDLDOMString, IDLUnrestrictedDouble>>>>::ReturnType{ } : convert<IDLNullable<IDLSequence<IDLUnion<IDLNull, IDLDOMString, IDLUnrestrictedDouble>>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto callback = convert<IDLNullable<IDLCallbackFunction<JSSQLStatementCallback>>>(*lexicalGlobalObject, callFrame->argument(2), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "callback", "SQLTransaction", "executeSql"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto errorCallback = convert<IDLNullable<IDLCallbackFunction<JSSQLStatementErrorCallback>>>(*lexicalGlobalObject, callFrame->argument(3), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 3, "errorCallback", "SQLTransaction", "executeSql"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.executeSql(WTFMove(sqlStatement), WTFMove(arguments), WTFMove(callback), WTFMove(errorCallback)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSQLTransactionPrototypeFunctionExecuteSql(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSSQLTransaction>::call<jsSQLTransactionPrototypeFunctionExecuteSqlBody>(*lexicalGlobalObject, *callFrame, "executeSql");
}

void JSSQLTransaction::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSQLTransaction*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSQLTransactionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSQLTransactionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSQLTransaction = static_cast<JSSQLTransaction*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSQLTransaction->wrapped(), jsSQLTransaction);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SQLTransaction>&& impl)
{
    return createWrapper<SQLTransaction>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SQLTransaction& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SQLTransaction* JSSQLTransaction::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSQLTransaction*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
