/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGAnimatedBoolean.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSVGAnimatedBooleanConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGAnimatedBooleanConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGAnimatedBooleanBaseVal(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGAnimatedBooleanBaseVal(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGAnimatedBooleanAnimVal(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSSVGAnimatedBooleanPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGAnimatedBooleanPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGAnimatedBooleanPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGAnimatedBooleanPrototype>(vm.heap)) JSSVGAnimatedBooleanPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGAnimatedBooleanPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGAnimatedBooleanPrototype, JSSVGAnimatedBooleanPrototype::Base);

using JSSVGAnimatedBooleanConstructor = JSDOMConstructorNotConstructable<JSSVGAnimatedBoolean>;

template<> JSValue JSSVGAnimatedBooleanConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGAnimatedBooleanConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGAnimatedBoolean::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGAnimatedBoolean"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSSVGAnimatedBooleanConstructor::s_info = { "SVGAnimatedBoolean", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnimatedBooleanConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedBooleanPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedBooleanConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGAnimatedBooleanConstructor) } },
    { "baseVal", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedBooleanBaseVal), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGAnimatedBooleanBaseVal) } },
    { "animVal", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedBooleanAnimVal), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSSVGAnimatedBooleanPrototype::s_info = { "SVGAnimatedBooleanPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnimatedBooleanPrototype) };

void JSSVGAnimatedBooleanPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGAnimatedBoolean::info(), JSSVGAnimatedBooleanPrototypeTableValues, *this);
}

const ClassInfo JSSVGAnimatedBoolean::s_info = { "SVGAnimatedBoolean", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnimatedBoolean) };

JSSVGAnimatedBoolean::JSSVGAnimatedBoolean(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGAnimatedBoolean>&& impl)
    : JSDOMWrapper<SVGAnimatedBoolean>(structure, globalObject, WTFMove(impl))
{
}

void JSSVGAnimatedBoolean::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGAnimatedBoolean>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGAnimatedBoolean::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGAnimatedBooleanPrototype::create(vm, &globalObject, JSSVGAnimatedBooleanPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSSVGAnimatedBoolean::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGAnimatedBoolean>(vm, globalObject);
}

JSValue JSSVGAnimatedBoolean::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedBooleanConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGAnimatedBoolean::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedBoolean* thisObject = static_cast<JSSVGAnimatedBoolean*>(cell);
    thisObject->JSSVGAnimatedBoolean::~JSSVGAnimatedBoolean();
}

template<> inline JSSVGAnimatedBoolean* IDLAttribute<JSSVGAnimatedBoolean>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSVGAnimatedBoolean*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSVGAnimatedBooleanConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGAnimatedBooleanPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGAnimatedBoolean::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGAnimatedBooleanConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGAnimatedBooleanPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSVGAnimatedBooleanBaseValGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAnimatedBoolean& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.baseVal());
    return result;
}

EncodedJSValue jsSVGAnimatedBooleanBaseVal(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGAnimatedBoolean>::get<jsSVGAnimatedBooleanBaseValGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "baseVal");
}

static inline bool setJSSVGAnimatedBooleanBaseValSetter(JSGlobalObject& lexicalGlobalObject, JSSVGAnimatedBoolean& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBaseVal(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSVGAnimatedBooleanBaseVal(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSVGAnimatedBoolean>::set<setJSSVGAnimatedBooleanBaseValSetter>(*lexicalGlobalObject, thisValue, encodedValue, "baseVal");
}

static inline JSValue jsSVGAnimatedBooleanAnimValGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAnimatedBoolean& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.animVal());
    return result;
}

EncodedJSValue jsSVGAnimatedBooleanAnimVal(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGAnimatedBoolean>::get<jsSVGAnimatedBooleanAnimValGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "animVal");
}

void JSSVGAnimatedBoolean::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGAnimatedBoolean*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGAnimatedBooleanOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGAnimatedBooleanOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGAnimatedBoolean = static_cast<JSSVGAnimatedBoolean*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGAnimatedBoolean->wrapped(), jsSVGAnimatedBoolean);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SVGAnimatedBoolean>&& impl)
{
    return createWrapper<SVGAnimatedBoolean>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SVGAnimatedBoolean& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SVGAnimatedBoolean* JSSVGAnimatedBoolean::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGAnimatedBoolean*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
