/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGClipPathElement.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedEnumeration.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSVGClipPathElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGClipPathElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGClipPathElementClipPathUnits(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSSVGClipPathElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGClipPathElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGClipPathElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGClipPathElementPrototype>(vm.heap)) JSSVGClipPathElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGClipPathElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGClipPathElementPrototype, JSSVGClipPathElementPrototype::Base);

using JSSVGClipPathElementConstructor = JSDOMConstructorNotConstructable<JSSVGClipPathElement>;

template<> JSValue JSSVGClipPathElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGGraphicsElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGClipPathElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGClipPathElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGClipPathElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSSVGClipPathElementConstructor::s_info = { "SVGClipPathElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGClipPathElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGClipPathElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGClipPathElementConstructor) } },
    { "clipPathUnits", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementClipPathUnits), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSSVGClipPathElementPrototype::s_info = { "SVGClipPathElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGClipPathElementPrototype) };

void JSSVGClipPathElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGClipPathElement::info(), JSSVGClipPathElementPrototypeTableValues, *this);
}

const ClassInfo JSSVGClipPathElement::s_info = { "SVGClipPathElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGClipPathElement) };

JSSVGClipPathElement::JSSVGClipPathElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGClipPathElement>&& impl)
    : JSSVGGraphicsElement(structure, globalObject, WTFMove(impl))
{
}

void JSSVGClipPathElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGClipPathElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGClipPathElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGClipPathElementPrototype::create(vm, &globalObject, JSSVGClipPathElementPrototype::createStructure(vm, &globalObject, JSSVGGraphicsElement::prototype(vm, globalObject)));
}

JSObject* JSSVGClipPathElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGClipPathElement>(vm, globalObject);
}

JSValue JSSVGClipPathElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGClipPathElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSSVGClipPathElement* IDLAttribute<JSSVGClipPathElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSVGClipPathElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSVGClipPathElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGClipPathElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGClipPathElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGClipPathElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGClipPathElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSVGClipPathElementClipPathUnitsGetter(JSGlobalObject& lexicalGlobalObject, JSSVGClipPathElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedEnumeration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.clipPathUnitsAnimated());
    return result;
}

EncodedJSValue jsSVGClipPathElementClipPathUnits(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGClipPathElement>::get<jsSVGClipPathElementClipPathUnitsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "clipPathUnits");
}

void JSSVGClipPathElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGClipPathElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
