/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGFEConvolveMatrixElement.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedInteger.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedNumberList.h"
#include "JSSVGAnimatedString.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSVGFEConvolveMatrixElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGFEConvolveMatrixElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementIn1(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementOrderX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementOrderY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementKernelMatrix(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementDivisor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementBias(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementTargetX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementTargetY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementEdgeMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementKernelUnitLengthX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementKernelUnitLengthY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementPreserveAlpha(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEConvolveMatrixElementResult(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSSVGFEConvolveMatrixElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGFEConvolveMatrixElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGFEConvolveMatrixElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGFEConvolveMatrixElementPrototype>(vm.heap)) JSSVGFEConvolveMatrixElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGFEConvolveMatrixElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGFEConvolveMatrixElementPrototype, JSSVGFEConvolveMatrixElementPrototype::Base);

using JSSVGFEConvolveMatrixElementConstructor = JSDOMConstructorNotConstructable<JSSVGFEConvolveMatrixElement>;

/* Hash table for constructor */

static const HashTableValue JSSVGFEConvolveMatrixElementConstructorTableValues[] =
{
    { "SVG_EDGEMODE_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_EDGEMODE_DUPLICATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_EDGEMODE_WRAP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_EDGEMODE_NONE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

template<> JSValue JSSVGFEConvolveMatrixElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGFEConvolveMatrixElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGFEConvolveMatrixElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGFEConvolveMatrixElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSSVGFEConvolveMatrixElement::info(), JSSVGFEConvolveMatrixElementConstructorTableValues, *this);
}

template<> const ClassInfo JSSVGFEConvolveMatrixElementConstructor::s_info = { "SVGFEConvolveMatrixElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGFEConvolveMatrixElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGFEConvolveMatrixElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGFEConvolveMatrixElementConstructor) } },
    { "in1", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementIn1), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "orderX", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementOrderX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "orderY", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementOrderY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "kernelMatrix", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementKernelMatrix), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "divisor", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementDivisor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "bias", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementBias), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "targetX", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementTargetX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "targetY", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementTargetY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "edgeMode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementEdgeMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "kernelUnitLengthX", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementKernelUnitLengthX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "kernelUnitLengthY", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementKernelUnitLengthY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "preserveAlpha", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementPreserveAlpha), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "x", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "y", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "width", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "height", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "result", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEConvolveMatrixElementResult), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "SVG_EDGEMODE_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_EDGEMODE_DUPLICATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_EDGEMODE_WRAP", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_EDGEMODE_NONE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

const ClassInfo JSSVGFEConvolveMatrixElementPrototype::s_info = { "SVGFEConvolveMatrixElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGFEConvolveMatrixElementPrototype) };

void JSSVGFEConvolveMatrixElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGFEConvolveMatrixElement::info(), JSSVGFEConvolveMatrixElementPrototypeTableValues, *this);
}

const ClassInfo JSSVGFEConvolveMatrixElement::s_info = { "SVGFEConvolveMatrixElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGFEConvolveMatrixElement) };

JSSVGFEConvolveMatrixElement::JSSVGFEConvolveMatrixElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGFEConvolveMatrixElement>&& impl)
    : JSSVGElement(structure, globalObject, WTFMove(impl))
{
}

void JSSVGFEConvolveMatrixElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGFEConvolveMatrixElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGFEConvolveMatrixElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGFEConvolveMatrixElementPrototype::create(vm, &globalObject, JSSVGFEConvolveMatrixElementPrototype::createStructure(vm, &globalObject, JSSVGElement::prototype(vm, globalObject)));
}

JSObject* JSSVGFEConvolveMatrixElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGFEConvolveMatrixElement>(vm, globalObject);
}

JSValue JSSVGFEConvolveMatrixElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEConvolveMatrixElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSSVGFEConvolveMatrixElement* IDLAttribute<JSSVGFEConvolveMatrixElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSVGFEConvolveMatrixElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSVGFEConvolveMatrixElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGFEConvolveMatrixElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGFEConvolveMatrixElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGFEConvolveMatrixElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGFEConvolveMatrixElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSVGFEConvolveMatrixElementIn1Getter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.in1Animated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementIn1(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementIn1Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "in1");
}

static inline JSValue jsSVGFEConvolveMatrixElementOrderXGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedInteger>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.orderXAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementOrderX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementOrderXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "orderX");
}

static inline JSValue jsSVGFEConvolveMatrixElementOrderYGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedInteger>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.orderYAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementOrderY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementOrderYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "orderY");
}

static inline JSValue jsSVGFEConvolveMatrixElementKernelMatrixGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedNumberList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.kernelMatrixAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementKernelMatrix(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementKernelMatrixGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "kernelMatrix");
}

static inline JSValue jsSVGFEConvolveMatrixElementDivisorGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedNumber>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.divisorAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementDivisor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementDivisorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "divisor");
}

static inline JSValue jsSVGFEConvolveMatrixElementBiasGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedNumber>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.biasAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementBias(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementBiasGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "bias");
}

static inline JSValue jsSVGFEConvolveMatrixElementTargetXGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedInteger>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.targetXAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementTargetX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementTargetXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "targetX");
}

static inline JSValue jsSVGFEConvolveMatrixElementTargetYGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedInteger>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.targetYAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementTargetY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementTargetYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "targetY");
}

static inline JSValue jsSVGFEConvolveMatrixElementEdgeModeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedEnumeration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.edgeModeAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementEdgeMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementEdgeModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "edgeMode");
}

static inline JSValue jsSVGFEConvolveMatrixElementKernelUnitLengthXGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedNumber>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.kernelUnitLengthXAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementKernelUnitLengthX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementKernelUnitLengthXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "kernelUnitLengthX");
}

static inline JSValue jsSVGFEConvolveMatrixElementKernelUnitLengthYGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedNumber>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.kernelUnitLengthYAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementKernelUnitLengthY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementKernelUnitLengthYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "kernelUnitLengthY");
}

static inline JSValue jsSVGFEConvolveMatrixElementPreserveAlphaGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedBoolean>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.preserveAlphaAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementPreserveAlpha(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementPreserveAlphaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "preserveAlpha");
}

static inline JSValue jsSVGFEConvolveMatrixElementXGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.xAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "x");
}

static inline JSValue jsSVGFEConvolveMatrixElementYGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.yAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "y");
}

static inline JSValue jsSVGFEConvolveMatrixElementWidthGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.widthAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "width");
}

static inline JSValue jsSVGFEConvolveMatrixElementHeightGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.heightAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "height");
}

static inline JSValue jsSVGFEConvolveMatrixElementResultGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEConvolveMatrixElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.resultAnimated());
    return result;
}

EncodedJSValue jsSVGFEConvolveMatrixElementResult(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEConvolveMatrixElement>::get<jsSVGFEConvolveMatrixElementResultGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "result");
}

void JSSVGFEConvolveMatrixElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGFEConvolveMatrixElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
