/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGFEOffsetElement.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsSVGFEOffsetElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGFEOffsetElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGFEOffsetElementIn1(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEOffsetElementDx(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEOffsetElementDy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEOffsetElementX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEOffsetElementY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEOffsetElementWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEOffsetElementHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGFEOffsetElementResult(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSSVGFEOffsetElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGFEOffsetElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGFEOffsetElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGFEOffsetElementPrototype>(vm.heap)) JSSVGFEOffsetElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGFEOffsetElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGFEOffsetElementPrototype, JSSVGFEOffsetElementPrototype::Base);

using JSSVGFEOffsetElementConstructor = JSDOMConstructorNotConstructable<JSSVGFEOffsetElement>;

template<> JSValue JSSVGFEOffsetElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGFEOffsetElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGFEOffsetElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGFEOffsetElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSSVGFEOffsetElementConstructor::s_info = { "SVGFEOffsetElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGFEOffsetElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGFEOffsetElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGFEOffsetElementConstructor) } },
    { "in1", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementIn1), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "dx", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementDx), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "dy", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementDy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "x", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "y", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "width", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "height", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "result", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementResult), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSSVGFEOffsetElementPrototype::s_info = { "SVGFEOffsetElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGFEOffsetElementPrototype) };

void JSSVGFEOffsetElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGFEOffsetElement::info(), JSSVGFEOffsetElementPrototypeTableValues, *this);
}

const ClassInfo JSSVGFEOffsetElement::s_info = { "SVGFEOffsetElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGFEOffsetElement) };

JSSVGFEOffsetElement::JSSVGFEOffsetElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGFEOffsetElement>&& impl)
    : JSSVGElement(structure, globalObject, WTFMove(impl))
{
}

void JSSVGFEOffsetElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGFEOffsetElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGFEOffsetElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGFEOffsetElementPrototype::create(vm, &globalObject, JSSVGFEOffsetElementPrototype::createStructure(vm, &globalObject, JSSVGElement::prototype(vm, globalObject)));
}

JSObject* JSSVGFEOffsetElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGFEOffsetElement>(vm, globalObject);
}

JSValue JSSVGFEOffsetElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEOffsetElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSSVGFEOffsetElement* IDLAttribute<JSSVGFEOffsetElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSVGFEOffsetElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsSVGFEOffsetElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGFEOffsetElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGFEOffsetElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGFEOffsetElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGFEOffsetElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSVGFEOffsetElementIn1Getter(JSGlobalObject& lexicalGlobalObject, JSSVGFEOffsetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.in1Animated());
    return result;
}

EncodedJSValue jsSVGFEOffsetElementIn1(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEOffsetElement>::get<jsSVGFEOffsetElementIn1Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "in1");
}

static inline JSValue jsSVGFEOffsetElementDxGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEOffsetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedNumber>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.dxAnimated());
    return result;
}

EncodedJSValue jsSVGFEOffsetElementDx(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEOffsetElement>::get<jsSVGFEOffsetElementDxGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "dx");
}

static inline JSValue jsSVGFEOffsetElementDyGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEOffsetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedNumber>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.dyAnimated());
    return result;
}

EncodedJSValue jsSVGFEOffsetElementDy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEOffsetElement>::get<jsSVGFEOffsetElementDyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "dy");
}

static inline JSValue jsSVGFEOffsetElementXGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEOffsetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.xAnimated());
    return result;
}

EncodedJSValue jsSVGFEOffsetElementX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEOffsetElement>::get<jsSVGFEOffsetElementXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "x");
}

static inline JSValue jsSVGFEOffsetElementYGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEOffsetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.yAnimated());
    return result;
}

EncodedJSValue jsSVGFEOffsetElementY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEOffsetElement>::get<jsSVGFEOffsetElementYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "y");
}

static inline JSValue jsSVGFEOffsetElementWidthGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEOffsetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.widthAnimated());
    return result;
}

EncodedJSValue jsSVGFEOffsetElementWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEOffsetElement>::get<jsSVGFEOffsetElementWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "width");
}

static inline JSValue jsSVGFEOffsetElementHeightGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEOffsetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.heightAnimated());
    return result;
}

EncodedJSValue jsSVGFEOffsetElementHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEOffsetElement>::get<jsSVGFEOffsetElementHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "height");
}

static inline JSValue jsSVGFEOffsetElementResultGetter(JSGlobalObject& lexicalGlobalObject, JSSVGFEOffsetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SVGAnimatedString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.resultAnimated());
    return result;
}

EncodedJSValue jsSVGFEOffsetElementResult(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGFEOffsetElement>::get<jsSVGFEOffsetElementResultGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "result");
}

void JSSVGFEOffsetElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGFEOffsetElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
