/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGLength.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSVGLengthPrototypeFunctionNewValueSpecifiedUnits(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGLengthPrototypeFunctionConvertToSpecifiedUnits(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsSVGLengthConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGLengthConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGLengthUnitType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGLengthValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGLengthValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGLengthValueInSpecifiedUnits(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGLengthValueInSpecifiedUnits(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGLengthValueAsString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSSVGLengthValueAsString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGLengthPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGLengthPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGLengthPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGLengthPrototype>(vm.heap)) JSSVGLengthPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGLengthPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGLengthPrototype, JSSVGLengthPrototype::Base);

using JSSVGLengthConstructor = JSDOMConstructorNotConstructable<JSSVGLength>;

/* Hash table for constructor */

static const HashTableValue JSSVGLengthConstructorTableValues[] =
{
    { "SVG_LENGTHTYPE_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_LENGTHTYPE_NUMBER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_LENGTHTYPE_PERCENTAGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_LENGTHTYPE_EMS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "SVG_LENGTHTYPE_EXS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "SVG_LENGTHTYPE_PX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "SVG_LENGTHTYPE_CM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "SVG_LENGTHTYPE_MM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "SVG_LENGTHTYPE_IN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "SVG_LENGTHTYPE_PT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "SVG_LENGTHTYPE_PC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(10) } },
};

static_assert(SVGLength::SVG_LENGTHTYPE_UNKNOWN == 0, "SVG_LENGTHTYPE_UNKNOWN in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_NUMBER == 1, "SVG_LENGTHTYPE_NUMBER in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_PERCENTAGE == 2, "SVG_LENGTHTYPE_PERCENTAGE in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_EMS == 3, "SVG_LENGTHTYPE_EMS in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_EXS == 4, "SVG_LENGTHTYPE_EXS in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_PX == 5, "SVG_LENGTHTYPE_PX in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_CM == 6, "SVG_LENGTHTYPE_CM in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_MM == 7, "SVG_LENGTHTYPE_MM in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_IN == 8, "SVG_LENGTHTYPE_IN in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_PT == 9, "SVG_LENGTHTYPE_PT in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_PC == 10, "SVG_LENGTHTYPE_PC in SVGLength does not match value from IDL");

template<> JSValue JSSVGLengthConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGLengthConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGLength::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("SVGLength"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSSVGLength::info(), JSSVGLengthConstructorTableValues, *this);
}

template<> const ClassInfo JSSVGLengthConstructor::s_info = { "SVGLength", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGLengthConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGLengthPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGLengthConstructor) } },
    { "unitType", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthUnitType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "value", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGLengthValue) } },
    { "valueInSpecifiedUnits", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthValueInSpecifiedUnits), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGLengthValueInSpecifiedUnits) } },
    { "valueAsString", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthValueAsString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGLengthValueAsString) } },
    { "newValueSpecifiedUnits", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsSVGLengthPrototypeFunctionNewValueSpecifiedUnits), (intptr_t) (2) } },
    { "convertToSpecifiedUnits", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsSVGLengthPrototypeFunctionConvertToSpecifiedUnits), (intptr_t) (1) } },
    { "SVG_LENGTHTYPE_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_LENGTHTYPE_NUMBER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_LENGTHTYPE_PERCENTAGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_LENGTHTYPE_EMS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "SVG_LENGTHTYPE_EXS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "SVG_LENGTHTYPE_PX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "SVG_LENGTHTYPE_CM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "SVG_LENGTHTYPE_MM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "SVG_LENGTHTYPE_IN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "SVG_LENGTHTYPE_PT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "SVG_LENGTHTYPE_PC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(10) } },
};

const ClassInfo JSSVGLengthPrototype::s_info = { "SVGLengthPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGLengthPrototype) };

void JSSVGLengthPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGLength::info(), JSSVGLengthPrototypeTableValues, *this);
}

const ClassInfo JSSVGLength::s_info = { "SVGLength", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGLength) };

JSSVGLength::JSSVGLength(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGLength>&& impl)
    : JSDOMWrapper<SVGLength>(structure, globalObject, WTFMove(impl))
{
}

void JSSVGLength::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, SVGLength>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSSVGLength::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSSVGLengthPrototype::create(vm, &globalObject, JSSVGLengthPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSSVGLength::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGLength>(vm, globalObject);
}

JSValue JSSVGLength::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGLengthConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGLength::destroy(JSC::JSCell* cell)
{
    JSSVGLength* thisObject = static_cast<JSSVGLength*>(cell);
    thisObject->JSSVGLength::~JSSVGLength();
}

template<> inline JSSVGLength* IDLAttribute<JSSVGLength>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSSVGLength*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSSVGLength* IDLOperation<JSSVGLength>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSSVGLength*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsSVGLengthConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGLengthPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGLength::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSSVGLengthConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGLengthPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsSVGLengthUnitTypeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGLength& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.unitType());
    return result;
}

EncodedJSValue jsSVGLengthUnitType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGLength>::get<jsSVGLengthUnitTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "unitType");
}

static inline JSValue jsSVGLengthValueGetter(JSGlobalObject& lexicalGlobalObject, JSSVGLength& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.valueForBindings());
    return result;
}

EncodedJSValue jsSVGLengthValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGLength>::get<jsSVGLengthValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "value");
}

static inline bool setJSSVGLengthValueSetter(JSGlobalObject& lexicalGlobalObject, JSSVGLength& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setValueForBindings(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSVGLengthValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSVGLength>::set<setJSSVGLengthValueSetter>(*lexicalGlobalObject, thisValue, encodedValue, "value");
}

static inline JSValue jsSVGLengthValueInSpecifiedUnitsGetter(JSGlobalObject& lexicalGlobalObject, JSSVGLength& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.valueInSpecifiedUnits());
    return result;
}

EncodedJSValue jsSVGLengthValueInSpecifiedUnits(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGLength>::get<jsSVGLengthValueInSpecifiedUnitsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "valueInSpecifiedUnits");
}

static inline bool setJSSVGLengthValueInSpecifiedUnitsSetter(JSGlobalObject& lexicalGlobalObject, JSSVGLength& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setValueInSpecifiedUnits(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSVGLengthValueInSpecifiedUnits(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSVGLength>::set<setJSSVGLengthValueInSpecifiedUnitsSetter>(*lexicalGlobalObject, thisValue, encodedValue, "valueInSpecifiedUnits");
}

static inline JSValue jsSVGLengthValueAsStringGetter(JSGlobalObject& lexicalGlobalObject, JSSVGLength& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.valueAsString());
    return result;
}

EncodedJSValue jsSVGLengthValueAsString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSSVGLength>::get<jsSVGLengthValueAsStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "valueAsString");
}

static inline bool setJSSVGLengthValueAsStringSetter(JSGlobalObject& lexicalGlobalObject, JSSVGLength& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setValueAsString(WTFMove(nativeValue));
    });
    return true;
}

bool setJSSVGLengthValueAsString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSSVGLength>::set<setJSSVGLengthValueAsStringSetter>(*lexicalGlobalObject, thisValue, encodedValue, "valueAsString");
}

static inline JSC::EncodedJSValue jsSVGLengthPrototypeFunctionNewValueSpecifiedUnitsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGLength>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto unitType = convert<IDLUnsignedShort>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto valueInSpecifiedUnits = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.newValueSpecifiedUnits(WTFMove(unitType), WTFMove(valueInSpecifiedUnits)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGLengthPrototypeFunctionNewValueSpecifiedUnits(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSSVGLength>::call<jsSVGLengthPrototypeFunctionNewValueSpecifiedUnitsBody>(*lexicalGlobalObject, *callFrame, "newValueSpecifiedUnits");
}

static inline JSC::EncodedJSValue jsSVGLengthPrototypeFunctionConvertToSpecifiedUnitsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGLength>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto unitType = convert<IDLUnsignedShort>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.convertToSpecifiedUnits(WTFMove(unitType)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGLengthPrototypeFunctionConvertToSpecifiedUnits(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSSVGLength>::call<jsSVGLengthPrototypeFunctionConvertToSpecifiedUnitsBody>(*lexicalGlobalObject, *callFrame, "convertToSpecifiedUnits");
}

void JSSVGLength::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGLength*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGLengthOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGLengthOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGLength = static_cast<JSSVGLength*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGLength->wrapped(), jsSVGLength);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SVGLength@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore9SVGLengthE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SVGLength>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7SVGLength@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore9SVGLengthE[2];
#endif

    // If this fails SVGLength does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<SVGLength>::value, "SVGLength is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // SVGLength has subclasses. If SVGLength has subclasses that get passed
    // to toJS() we currently require SVGLength you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<SVGLength>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SVGLength& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SVGLength* JSSVGLength::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGLength*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
